/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.deprecation;

import VASSAL.tools.deprecation.Walker;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Processor {
    private static final byte[] ZIPSIG = new byte[]{80, 75, 3, 4};
    private static final byte[] CLASSSIG = new byte[]{-54, -2, -70, -66};

    private static boolean checkSig(InputStream in, byte[] sig) {
        try {
            return Arrays.equals(in.readNBytes(sig.length), sig);
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean isZipArchive(Path p) {
        boolean bl;
        block8: {
            InputStream in = Files.newInputStream(p, new OpenOption[0]);
            try {
                bl = Processor.checkSig(in, ZIPSIG);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            in.close();
        }
        return bl;
    }

    private static boolean isClassFile(Path p) {
        boolean bl;
        block8: {
            InputStream in = Files.newInputStream(p, new OpenOption[0]);
            try {
                bl = Processor.checkSig(in, CLASSSIG);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            in.close();
        }
        return bl;
    }

    private static boolean isClassFile(InputStream in) {
        try {
            in.mark(CLASSSIG.length);
            boolean ret = Processor.checkSig(in, CLASSSIG);
            in.reset();
            return ret;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void process(Walker walker, byte[] b) {
        walker.setInput(b);
        walker.walk();
    }

    public static void process(Walker walker, InputStream in) throws IOException {
        walker.setInput(in);
        walker.walk();
    }

    public static void process(Walker walker, ZipFile zf) throws IOException {
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            ZipEntry ze = entries.nextElement();
            if (!ze.getName().endsWith(".class")) continue;
            try (BufferedInputStream in = new BufferedInputStream(zf.getInputStream(ze));){
                if (!Processor.isClassFile(in)) continue;
                Processor.process(walker, in);
            }
            catch (IOException e) {
                System.err.println("Failed reading " + ze.getName());
                throw e;
            }
        }
    }

    public static void process(Walker walker, String src) throws IOException {
        try (Stream<Path> s = Files.walk(Paths.get(src, new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));){
            for (Path p : s::iterator) {
                if (p.getFileName().toString().endsWith(".class")) {
                    if (!Processor.isClassFile(p)) continue;
                    try {
                        BufferedInputStream in = new BufferedInputStream(Files.newInputStream(p, new OpenOption[0]));
                        try {
                            if (!Processor.isClassFile(in)) continue;
                            Processor.process(walker, in);
                            continue;
                        }
                        finally {
                            ((InputStream)in).close();
                            continue;
                        }
                    }
                    catch (IOException e) {
                        System.err.println("Failed reading " + p);
                        throw e;
                    }
                }
                if (!Processor.isZipArchive(p)) continue;
                try (ZipFile zf = new ZipFile(p.toFile());){
                    Processor.process(walker, zf);
                }
            }
        }
    }

    public static void readCompSet(InputStream in, Consumer<String[]> callback) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(in, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.isEmpty()) continue;
                callback.accept(line.split("\t"));
            }
        }
    }
}

