/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.deprecation;

import VASSAL.tools.deprecation.Walker;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class DependencyWalker
implements Walker {
    private Consumer<String> thisClassBeginCallback = s -> {};
    private Consumer<String> thisClassEndCallback = s -> {};
    private Consumer<String> classCallback = s -> {};
    private Consumer<String> methodCallback = s -> {};
    private Consumer<String> fieldCallback = s -> {};
    private ClassReader reader;
    private String thisClass;

    public void setThisClassBeginCallback(Consumer<String> cb) {
        this.thisClassBeginCallback = cb;
    }

    public void setThisClassEndCallback(Consumer<String> cb) {
        this.thisClassEndCallback = cb;
    }

    public void setClassCallback(Consumer<String> cb) {
        this.classCallback = cb;
    }

    public void setMethodCallback(Consumer<String> cb) {
        this.methodCallback = cb;
    }

    public void setFieldCallback(Consumer<String> cb) {
        this.fieldCallback = cb;
    }

    @Override
    public void setInput(byte[] classFile) {
        this.reader = new ClassReader(classFile);
    }

    @Override
    public void setInput(InputStream in) throws IOException {
        this.reader = new ClassReader(in);
    }

    @Override
    public void setInput(String className) throws IOException {
        this.reader = new ClassReader(className);
    }

    @Override
    public void walk() {
        this.reader.accept((ClassVisitor)new ClassDependencyVisitor(), 0);
    }

    private void addDesc(String desc) {
        this.addType(Type.getType((String)desc));
    }

    private void addType(Type t) {
        switch (t.getSort()) {
            case 9: {
                this.addType(t.getElementType());
                break;
            }
            case 10: {
                this.addName(t.getInternalName());
                break;
            }
            case 11: {
                this.addMethodDesc(t.getDescriptor());
            }
        }
    }

    private void addMethodDesc(String desc) {
        this.addType(Type.getReturnType((String)desc));
        for (Type t : Type.getArgumentTypes((String)desc)) {
            this.addType(t);
        }
    }

    private void addName(String name) {
        if (name != null) {
            this.classCallback.accept(name.replace('/', '.'));
        }
    }

    private void addThisClassName(String name) {
        this.addInternalName(name);
        this.thisClass = Type.getObjectType((String)name).getInternalName().replace('/', '.');
        this.thisClassBeginCallback.accept(this.thisClass);
    }

    private void addInternalName(String name) {
        this.addType(Type.getObjectType((String)name));
    }

    private void addInternalNames(String[] names) {
        for (String n : names) {
            this.addInternalName(n);
        }
    }

    private void addConstant(Object cst) {
        if (cst instanceof Type) {
            this.addType((Type)cst);
        } else if (cst instanceof Handle) {
            Handle h = (Handle)cst;
            this.addInternalName(h.getOwner());
            this.addMethodDesc(h.getDesc());
        }
    }

    private void addConstants(Object[] cst) {
        for (Object c : cst) {
            this.addConstant(c);
        }
    }

    private String typeString(Type t) {
        switch (t.getSort()) {
            case 1: {
                return "boolean";
            }
            case 2: {
                return "char";
            }
            case 3: {
                return "byte";
            }
            case 4: {
                return "short";
            }
            case 5: {
                return "int";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "long";
            }
            case 8: {
                return "double";
            }
            case 9: {
                return this.typeString(t.getElementType()) + "[]".repeat(t.getDimensions());
            }
            case 10: {
                return t.getInternalName();
            }
        }
        throw new IllegalArgumentException();
    }

    private void addMethod(String owner, String name, String desc) {
        ArrayList<String> args = new ArrayList<String>();
        for (Type t : Type.getArgumentTypes((String)desc)) {
            args.add(this.typeString(t));
        }
        this.methodCallback.accept((owner + "." + name + "(" + String.join((CharSequence)", ", args) + ")").replace('/', '.'));
    }

    private void addField(String owner, String name) {
        this.fieldCallback.accept(owner.replace('/', '.') + "." + name);
    }

    private void addSignature(String signature) {
        new SignatureReader(signature).accept((SignatureVisitor)new SignatureDependencyVisitor());
    }

    private void addTypeSignature(String signature) {
        new SignatureReader(signature).acceptType((SignatureVisitor)new SignatureDependencyVisitor());
    }

    private class ClassDependencyVisitor
    extends ClassVisitor {
        public ClassDependencyVisitor() {
            super(589824);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            DependencyWalker.this.addThisClassName(name);
            if (signature == null) {
                if (superName != null) {
                    DependencyWalker.this.addInternalName(superName);
                }
                DependencyWalker.this.addInternalNames(interfaces);
            } else {
                DependencyWalker.this.addSignature(signature);
            }
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            DependencyWalker.this.addDesc(desc);
            return new AnnotationDependencyVisitor();
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            DependencyWalker.this.addDesc(desc);
            return new AnnotationDependencyVisitor();
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if (signature == null) {
                DependencyWalker.this.addDesc(desc);
            } else {
                DependencyWalker.this.addTypeSignature(signature);
            }
            if (value instanceof Type) {
                DependencyWalker.this.addType((Type)value);
            }
            return new FieldDependencyVisitor();
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (signature == null) {
                DependencyWalker.this.addMethodDesc(desc);
            } else {
                DependencyWalker.this.addSignature(signature);
            }
            if (exceptions != null) {
                DependencyWalker.this.addInternalNames(exceptions);
            }
            return new MethodDependencyVisitor();
        }

        public void visitEnd() {
            DependencyWalker.this.thisClassEndCallback.accept(DependencyWalker.this.thisClass);
        }
    }

    private class SignatureDependencyVisitor
    extends SignatureVisitor {
        private String signatureClassName;

        public SignatureDependencyVisitor() {
            super(589824);
        }

        public void visitClassType(String name) {
            this.signatureClassName = name;
            DependencyWalker.this.addInternalName(name);
        }

        public void visitInnerClassType(String name) {
            this.signatureClassName = this.signatureClassName + "$" + name;
            DependencyWalker.this.addInternalName(this.signatureClassName);
        }
    }

    private class MethodDependencyVisitor
    extends MethodVisitor {
        public MethodDependencyVisitor() {
            super(589824);
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return new AnnotationDependencyVisitor();
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            DependencyWalker.this.addDesc(desc);
            return new AnnotationDependencyVisitor();
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            DependencyWalker.this.addDesc(desc);
            return new AnnotationDependencyVisitor();
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            DependencyWalker.this.addDesc(desc);
            return new AnnotationDependencyVisitor();
        }

        public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            DependencyWalker.this.addDesc(desc);
            return new AnnotationDependencyVisitor();
        }

        public void visitTypeInsn(int opcode, String type) {
            DependencyWalker.this.addType(Type.getObjectType((String)type));
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            DependencyWalker.this.addInternalName(owner);
            DependencyWalker.this.addDesc(desc);
            DependencyWalker.this.addField(owner, name);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean isInterface) {
            DependencyWalker.this.addInternalName(owner);
            DependencyWalker.this.addMethodDesc(desc);
            DependencyWalker.this.addMethod(owner, name, desc);
        }

        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            DependencyWalker.this.addMethodDesc(desc);
            DependencyWalker.this.addConstant(bsm);
            DependencyWalker.this.addConstants(bsmArgs);
        }

        public void visitLdcInsn(Object cst) {
            DependencyWalker.this.addConstant(cst);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            DependencyWalker.this.addDesc(desc);
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            if (signature == null) {
                DependencyWalker.this.addDesc(desc);
            } else {
                DependencyWalker.this.addSignature(signature);
            }
        }

        public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
            DependencyWalker.this.addDesc(desc);
            return new AnnotationDependencyVisitor();
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            if (type != null) {
                DependencyWalker.this.addInternalName(type);
            }
        }

        public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            DependencyWalker.this.addDesc(desc);
            return new AnnotationDependencyVisitor();
        }
    }

    private class FieldDependencyVisitor
    extends FieldVisitor {
        public FieldDependencyVisitor() {
            super(589824);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            DependencyWalker.this.addDesc(desc);
            return new AnnotationDependencyVisitor();
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            DependencyWalker.this.addDesc(desc);
            return new AnnotationDependencyVisitor();
        }
    }

    private class AnnotationDependencyVisitor
    extends AnnotationVisitor {
        public AnnotationDependencyVisitor() {
            super(589824);
        }

        public void visit(String name, Object value) {
            if (value instanceof Type) {
                DependencyWalker.this.addType((Type)value);
            }
        }

        public void visitEnum(String name, String desc, String value) {
            DependencyWalker.this.addDesc(desc);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            DependencyWalker.this.addDesc(desc);
            return this;
        }

        public AnnotationVisitor visitArray(String name) {
            return this;
        }
    }
}

