/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.tools.NamedKeyStroke;
import java.awt.Color;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.KeyStroke;

public class SequenceEncoder {
    private StringBuilder buffer;
    private final char delim;
    private static final String UGLY = "-.0123456789EINaefilnrstuy";
    private final boolean uglyDelim;

    public SequenceEncoder(char delimiter) {
        this.delim = delimiter;
        this.uglyDelim = UGLY.indexOf(this.delim) != -1;
    }

    public SequenceEncoder(String val, char delimiter) {
        this(delimiter);
        this.append(val);
    }

    private void startBufferOrAddDelimiter() {
        if (this.buffer == null) {
            this.buffer = new StringBuilder();
        } else {
            this.buffer.append(this.delim);
        }
    }

    public SequenceEncoder append(String s) {
        this.startBufferOrAddDelimiter();
        if (s == null || s.isEmpty()) {
            return this;
        }
        if (s.charAt(0) == '\\' || s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'') {
            this.buffer.append('\'');
            this.appendEscapedString(s);
            this.buffer.append('\'');
        } else {
            this.appendEscapedString(s);
        }
        return this;
    }

    private void appendEscapedChar(char c) {
        if (c == this.delim) {
            this.buffer.append('\\');
        }
        this.buffer.append(c);
    }

    public SequenceEncoder append(char c) {
        this.startBufferOrAddDelimiter();
        if (c == '\\' || c == '\'') {
            this.buffer.append('\'');
            this.appendEscapedChar(c);
            this.buffer.append('\'');
        } else {
            this.appendEscapedChar(c);
        }
        return this;
    }

    public SequenceEncoder append(int i) {
        if (this.uglyDelim) {
            return this.append(String.valueOf(i));
        }
        this.startBufferOrAddDelimiter();
        this.buffer.append(i);
        return this;
    }

    public SequenceEncoder append(long l) {
        if (this.uglyDelim) {
            return this.append(String.valueOf(l));
        }
        this.startBufferOrAddDelimiter();
        this.buffer.append(l);
        return this;
    }

    public SequenceEncoder append(double d) {
        if (this.uglyDelim) {
            return this.append(String.valueOf(d));
        }
        this.startBufferOrAddDelimiter();
        this.buffer.append(d);
        return this;
    }

    public SequenceEncoder append(boolean b) {
        if (this.uglyDelim) {
            return this.append(String.valueOf(b));
        }
        this.startBufferOrAddDelimiter();
        this.buffer.append(b);
        return this;
    }

    public SequenceEncoder append(KeyStroke stroke) {
        return this.append(HotKeyConfigurer.encode(stroke));
    }

    public SequenceEncoder append(NamedKeyStroke stroke) {
        return this.append(NamedHotKeyConfigurer.encode(stroke));
    }

    public SequenceEncoder append(Color color) {
        return this.append(ColorConfigurer.colorToString(color));
    }

    public SequenceEncoder append(String[] s) {
        return this.append(StringArrayConfigurer.arrayToString(s));
    }

    public SequenceEncoder append(PropertyExpression p) {
        return this.append(p.getExpression());
    }

    public String getValue() {
        return this.buffer != null ? this.buffer.toString() : null;
    }

    private void appendEscapedString(String s) {
        int begin = 0;
        int end = s.indexOf(this.delim);
        while (begin <= end) {
            this.buffer.append(s, begin, end).append('\\');
            begin = end;
            end = s.indexOf(this.delim, end + 1);
        }
        this.buffer.append(s, begin, s.length());
    }

    public static void main(String[] args) {
        SequenceEncoder se = new SequenceEncoder(',');
        for (String arg : args) {
            se.append(arg);
        }
        System.out.println(se.getValue());
        Decoder st = new Decoder(se.getValue(), ',');
        while (st.hasMoreTokens()) {
            System.out.println(st.nextToken());
        }
    }

    public static class Decoder
    implements Iterator<String> {
        private String val;
        private final char delim;
        private StringBuilder buf;
        private int start;
        private final int stop;

        public Decoder(String value, char delimiter) {
            this.val = value;
            this.delim = delimiter;
            this.start = 0;
            this.stop = this.val != null ? this.val.length() : 0;
        }

        public Decoder(Decoder d) {
            this.val = d.val;
            this.delim = d.delim;
            this.start = d.start;
            this.stop = d.stop;
        }

        public boolean hasMoreTokens() {
            return this.val != null;
        }

        public String getRemaining() {
            if (!this.hasMoreTokens()) {
                return "";
            }
            return this.val.substring(this.start, this.stop);
        }

        public String nextToken() {
            int i;
            if (!this.hasMoreTokens()) {
                throw new NoSuchElementException();
            }
            if (this.start == this.stop) {
                this.val = null;
                return "";
            }
            if (this.buf != null) {
                this.buf.setLength(0);
            }
            CharSequence tok = null;
            for (i = this.start; i < this.stop; ++i) {
                if (this.val.charAt(i) != this.delim) continue;
                if (i > 0 && this.val.charAt(i - 1) == '\\') {
                    if (this.buf == null) {
                        this.buf = new StringBuilder();
                    }
                    this.buf.append(this.val, this.start, i - 1);
                    this.start = i;
                    continue;
                }
                if (this.buf == null || this.buf.length() == 0) {
                    tok = this.val.substring(this.start, i);
                } else {
                    this.buf.append(this.val, this.start, i);
                }
                this.start = i + 1;
                break;
            }
            if (this.start < i) {
                if (this.buf == null || this.buf.length() == 0) {
                    tok = this.val.substring(this.start);
                } else {
                    this.buf.append(this.val, this.start, this.stop);
                }
                this.val = null;
            }
            return this.unquote(tok != null ? tok : this.buf).intern();
        }

        private String unquote(CharSequence cs) {
            int len = cs.length();
            return (len > 1 && cs.charAt(0) == '\'' && cs.charAt(len - 1) == '\'' ? cs.subSequence(1, len - 1) : cs).toString();
        }

        @Override
        public boolean hasNext() {
            return this.hasMoreTokens();
        }

        @Override
        public String next() {
            return this.nextToken();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Decoder copy() {
            return new Decoder(this);
        }

        public int nextInt(int defaultValue) {
            if (this.val != null) {
                try {
                    defaultValue = Integer.parseInt(this.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return defaultValue;
        }

        public long nextLong(long defaultValue) {
            if (this.val != null) {
                try {
                    defaultValue = Long.parseLong(this.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return defaultValue;
        }

        public double nextDouble(double defaultValue) {
            if (this.val != null) {
                try {
                    defaultValue = Double.parseDouble(this.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return defaultValue;
        }

        public boolean nextBoolean(boolean defaultValue) {
            return this.val != null ? "true".equals(this.nextToken()) : defaultValue;
        }

        public char nextChar(char defaultValue) {
            if (this.val != null) {
                String s = this.nextToken();
                defaultValue = s.length() > 0 ? s.charAt(0) : defaultValue;
            }
            return defaultValue;
        }

        public KeyStroke nextKeyStroke(char defaultValue) {
            return this.nextKeyStroke(KeyStroke.getKeyStroke((int)defaultValue, 128));
        }

        public Color nextColor(Color defaultValue) {
            if (this.val != null) {
                String s = this.nextToken();
                defaultValue = s.length() > 0 ? ColorConfigurer.stringToColor(s) : null;
            }
            return defaultValue;
        }

        public KeyStroke nextKeyStroke(KeyStroke defaultValue) {
            if (this.val != null) {
                String s = this.nextToken();
                defaultValue = s.length() == 0 ? null : (s.indexOf(44) < 0 ? KeyStroke.getKeyStroke((int)s.charAt(0), 128) : HotKeyConfigurer.decode(s));
            }
            return defaultValue;
        }

        public NamedKeyStroke nextNamedKeyStroke(char defaultValue) {
            return this.nextNamedKeyStroke(NamedKeyStroke.of(defaultValue, 128));
        }

        public NamedKeyStroke nextNamedKeyStroke() {
            return this.nextNamedKeyStroke(NamedKeyStroke.NULL_KEYSTROKE);
        }

        public NamedKeyStroke nextNamedKeyStroke(NamedKeyStroke defaultValue) {
            if (this.val != null) {
                String s = this.nextToken();
                defaultValue = s.length() == 0 ? null : (s.indexOf(44) < 0 ? NamedKeyStroke.of(s.charAt(0), 128) : NamedHotKeyConfigurer.decode(s));
            }
            return defaultValue == null ? NamedKeyStroke.NULL_KEYSTROKE : defaultValue;
        }

        public String nextToken(String defaultValue) {
            return this.val != null ? this.nextToken() : (defaultValue != null ? defaultValue.intern() : null);
        }

        public String[] nextStringArray(int minLength) {
            String[] retVal = this.val != null ? StringArrayConfigurer.stringToArray(this.nextToken()) : new String[]{};
            if (retVal.length < minLength) {
                retVal = Arrays.copyOf(retVal, minLength);
            }
            return retVal;
        }
    }
}

