/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.image.ImageUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class IconButton
extends JButton {
    private static final long serialVersionUID = 1L;
    public static final int PLUS_ICON = 0;
    public static final int MINUS_ICON = 1;
    public static final int TICK_ICON = 2;
    public static final int CROSS_ICON = 3;

    public IconButton(int type) {
        this(type, 22);
    }

    public IconButton(int type, int size) {
        this(type, size, IconButton.getDefaultColor(type), 2.0f);
    }

    public static Color getDefaultColor(int type) {
        switch (type) {
            case 2: {
                return Color.green;
            }
            case 3: {
                return Color.red;
            }
        }
        return Color.black;
    }

    public IconButton(int type, int size, Color color, float width) {
        this.setMinimumSize(new Dimension(size, size));
        this.setPreferredSize(new Dimension(size, size));
        BufferedImage image = ImageUtils.createCompatibleTranslucentImage(size, size);
        Graphics2D g = image.createGraphics();
        g.setStroke(new BasicStroke(width));
        g.setColor(color);
        switch (type) {
            case 0: {
                g.drawLine(5, size / 2, size - 5, size / 2);
                g.drawLine(size / 2, 5, size / 2, size - 5);
                break;
            }
            case 1: {
                g.drawLine(5, size / 2, size - 5, size / 2);
                break;
            }
            case 2: {
                g.drawLine(5, size / 2, size / 2, size - 5);
                g.drawLine(size / 2, size - 5, 5, size - 5);
                break;
            }
            case 3: {
                g.drawLine(5, 5, size - 5, size - 5);
                g.drawLine(5, size - 5, size - 5, 5);
            }
        }
        this.setIcon(new ImageIcon(image));
    }
}

