/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.script;

import VASSAL.script.CompileResult;
import VASSAL.script.ScriptInterpreter;
import VASSAL.tools.WarningDialog;
import bsh.BeanShellExpressionValidator;
import bsh.EvalError;
import bsh.NameSpace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public class BeanShell {
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private static final BeanShell instance = new BeanShell();
    protected static final String INIT_SCRIPT = "/VASSAL/script/init_script.bsh";
    protected ScriptInterpreter globalInterpreter = new ScriptInterpreter(this.getClass().getClassLoader());

    public static BeanShell getInstance() {
        return instance;
    }

    public BeanShell() {
        this.init();
    }

    public void init() {
        URL ini = instance.getClass().getResource(INIT_SCRIPT);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(ini.openStream(), StandardCharsets.UTF_8));){
            CompileResult result = this.compile(in);
            if (!result.isSuccess()) {
                result.printStackTrace();
            }
        }
        catch (IOException e) {
            WarningDialog.show(e, "", new Object[0]);
        }
    }

    public CompileResult compile(Reader in) {
        try {
            this.globalInterpreter.eval(in);
        }
        catch (EvalError e) {
            return new CompileResult(e);
        }
        return new CompileResult();
    }

    public NameSpace getGlobalNameSpace() {
        return this.globalInterpreter.getNameSpace();
    }

    public void executeActionScript(String scriptName) {
        try {
            this.globalInterpreter.evaluate(scriptName + "();");
        }
        catch (EvalError e) {
            e.printStackTrace();
        }
    }

    public static boolean validateExpression(String expression) {
        return new BeanShellExpressionValidator(expression).isValid();
    }

    public static Object wrap(String value) {
        if (value == null) {
            return "";
        }
        if (TRUE.equals(value)) {
            return Boolean.TRUE;
        }
        if (FALSE.equals(value)) {
            return Boolean.FALSE;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return value;
        }
    }
}

