/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.build.module.ModuleExtension;
import VASSAL.configure.ExtensionTree;
import VASSAL.i18n.Resources;
import VASSAL.launch.EditorWindow;
import VASSAL.launch.ModuleManagerUpdateHelper;
import VASSAL.tools.DataArchive;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.menu.MenuManager;
import java.io.IOException;
import javax.swing.JDialog;
import org.apache.commons.lang3.StringUtils;

public class ExtensionEditorWindow
extends EditorWindow {
    private static final long serialVersionUID = 1L;
    protected static ExtensionEditorWindow instance = null;
    protected ModuleExtension extension;

    public ExtensionEditorWindow(GameModule mod, ModuleExtension ext) {
        this.setExtensionName(ext.getDataArchive().getArchive().getFile().getName());
        this.setModuleName(mod.getDataArchive().getArchive().getFile().getName());
        this.extension = ext;
        this.tree = new ExtensionTree(mod, this.helpWindow, ext, this);
        this.treeStateChanged(false);
        this.scrollPane.setViewportView(this.tree);
        this.tree.populateEditMenu(this);
        MenuManager mm = MenuManager.getInstance();
        mm.addAction("Editor.ModuleEditor.reference_manual", this.tree.getHelpAction());
        this.toolBar.addSeparator();
        this.toolBar.add(this.extension.getEditAction(new JDialog(this)));
        this.saveAction.setEnabled(true);
        this.saveAsAction.setEnabled(true);
        this.pack();
    }

    public void moduleLoading(GameModule mod) {
    }

    @Override
    public String getEditorType() {
        return Resources.getString("Editor.ExtensionEditor.component_type");
    }

    @Override
    public void updateWindowTitle() {
        Object title;
        if (!StringUtils.isEmpty((CharSequence)this.extensionName)) {
            title = this.extensionName;
            if (!StringUtils.isEmpty((CharSequence)this.moduleName)) {
                title = (String)title + " " + Resources.getString("Editor.ExtensionEditor.extends_what_module", this.moduleName);
            }
            title = (String)title + " - " + Resources.getString("Editor.ExtensionEditor.editor_name", Info.getVersion());
        } else {
            title = Resources.getString("Editor.ExtensionEditor.editor_name", Info.getVersion());
        }
        this.setTitle((String)title);
    }

    @Override
    protected void save() {
        this.saver(() -> {
            DataArchive da = this.extension.getDataArchive();
            try {
                this.extension.save();
                this.setExtensionName(da.getName());
                ModuleManagerUpdateHelper.sendExtensionUpdate(da.getArchive().getFile());
            }
            catch (IOException e) {
                WriteErrorDialog.error(e, da.getArchive().getFile().getName());
            }
        });
    }

    @Override
    protected void saveAs() {
        this.saver(() -> {
            DataArchive da = this.extension.getDataArchive();
            try {
                this.extension.saveAs();
                this.setExtensionName(da.getName());
                ModuleManagerUpdateHelper.sendExtensionUpdate(da.getArchive().getFile());
            }
            catch (IOException e) {
                WriteErrorDialog.error(e, da.getArchive().getFile().getName());
            }
        });
    }

    public ModuleExtension getExtension() {
        return this.extension;
    }
}

