/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomVmOptions {
    private static final Logger log = LoggerFactory.getLogger(CustomVmOptions.class);
    private static final String VM_OPTIONS_FILE_NAME = "vassal.vmoptions";

    public void ensureCustomVmOptionsFileExistsInConfDir() {
        File confDir = Info.getConfDir();
        File vmOptionsFile = new File(confDir, VM_OPTIONS_FILE_NAME);
        if (!vmOptionsFile.exists()) {
            this.createInitialVmOptionsFile(confDir);
        }
    }

    private void createInitialVmOptionsFile(File confDir) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        try (InputStream is = classLoader.getResourceAsStream(VM_OPTIONS_FILE_NAME);){
            if (is == null) {
                log.error("Template for custom VM options vassal.vmoptions not found in the Vassal distribution");
                return;
            }
            Files.copy(is, Path.of(confDir.getAbsolutePath(), VM_OPTIONS_FILE_NAME), new CopyOption[0]);
        }
        catch (IOException e) {
            log.error("Unable to copy vassal.vmoptions to " + confDir.getAbsolutePath(), (Throwable)e);
        }
    }

    public List<String> getCustomVmOptions() {
        try {
            List<String> allLines = Files.readAllLines(Path.of(Info.getConfDir().getAbsolutePath(), VM_OPTIONS_FILE_NAME));
            return allLines.stream().filter(s -> !s.startsWith("#")).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toList());
        }
        catch (IOException e) {
            log.error("Unable to read vassal.vmoptions", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

