/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.i18n;

import VASSAL.i18n.Resources;
import VASSAL.i18n.Translation;
import VASSAL.tools.ReadErrorDialog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;

public class VassalTranslation
extends Translation {
    protected String[] allKeys;
    protected Properties baseValues = new Properties();

    public VassalTranslation() {
        this.setConfigureName("General.VASSAL");
        try (InputStream is = this.getClass().getResourceAsStream(".properties");){
            if (is == null) {
                throw new FileNotFoundException("VASSAL.properties not found");
            }
            try (BufferedInputStream in = new BufferedInputStream(is);){
                this.baseValues.load(in);
            }
        }
        catch (IOException e) {
            ReadErrorDialog.error(e, ".properties");
        }
    }

    @Override
    protected String getI18nPrefix() {
        return "";
    }

    @Override
    protected String getDescription() {
        return "General.VASSAL";
    }

    public void clearProperties() {
        this.localProperties = new Properties();
        this.dirty = false;
        this.allKeys = null;
    }

    @Override
    public String getAttributeValueString(String key) {
        return this.baseValues.getProperty(key);
    }

    @Override
    public String[] getAttributeDescriptions() {
        this.initkeys();
        return this.allKeys;
    }

    @Override
    public String[] getAttributeNames() {
        this.initkeys();
        return this.allKeys;
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        this.initkeys();
        Object[] types = new Class[this.allKeys.length];
        Arrays.fill(types, String.class);
        return types;
    }

    protected void initkeys() {
        if (this.allKeys == null) {
            this.allKeys = Resources.getVassalKeys().toArray(new String[0]);
        }
    }

    public void saveProperties(File file, Locale locale) throws IOException {
        try (OutputStream fout = Files.newOutputStream(file.toPath(), new OpenOption[0]);
             BufferedOutputStream out = new BufferedOutputStream(fout);){
            this.localProperties.store(out, locale.getDisplayName());
            this.dirty = false;
        }
    }

    protected void loadProperties(InputStream in) throws IOException {
        try (InputStream inputStream = in;){
            this.localProperties.load(in);
            this.dirty = false;
        }
    }
}

