/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.i18n;

import VASSAL.counters.GamePiece;
import VASSAL.i18n.Localization;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PieceI18nData {
    protected GamePiece piece;
    protected List<Property> properties = new ArrayList<Property>();

    public PieceI18nData(GamePiece piece) {
        this.piece = piece;
    }

    public List<Property> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public void add(String value, String description) {
        if (value != null && value.length() > 0) {
            this.properties.add(new Property(value, description));
        }
    }

    public String translate(String value) {
        String localisedValue = value;
        String i18nKey = null;
        for (Property p : this.getProperties()) {
            if (!p.getName().equals(value)) continue;
            i18nKey = "Piece." + p.getName();
            break;
        }
        if (i18nKey != null) {
            localisedValue = Localization.getInstance().translate(i18nKey, value);
        }
        return localisedValue;
    }

    public static class Property {
        private final String name;
        private final String description;

        public Property(String value, String description) {
            this.name = value;
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public String getName() {
            return this.name;
        }
    }
}

