/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.KeyStroke;

public class MenuSeparator
extends Decorator
implements TranslatablePiece {
    public static final String ID = "menuSeparator;";
    public static final String SEPARATOR_NAME = "<separator>";
    protected KeyCommand[] command;
    protected String desc;
    protected NamedKeyStroke key;
    protected KeyCommand separatorCommand;

    public MenuSeparator() {
        this("menuSeparator;;", null);
    }

    public MenuSeparator(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public void mySetType(String type) {
        type = type.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        this.desc = st.nextToken();
        this.key = st.nextNamedKeyStroke(null);
        this.command = null;
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.desc).append(this.key);
        return ID + se.getValue();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.command == null) {
            this.separatorCommand = new KeyCommand(SEPARATOR_NAME, this.key, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.command = new KeyCommand[]{this.separatorCommand};
        }
        if (this.command.length > 0) {
            this.command[0].setEnabled(this.getMap() != null);
        }
        return this.command;
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        return null;
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public String getDescription() {
        return this.buildDescription("Editor.MenuSeparator.trait_description", this.desc);
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.MenuSeparator.trait_description");
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof MenuSeparator)) {
            return false;
        }
        MenuSeparator c = (MenuSeparator)o;
        if (!Objects.equals(this.desc, c.desc)) {
            return false;
        }
        return Objects.equals(this.key, c.key);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("MenuSeparator.html");
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Arrays.asList(this.key);
    }

    public static class Ed
    implements PieceEditor {
        private final StringConfigurer descInput;
        private final NamedHotKeyConfigurer keyInput;
        private final TraitConfigPanel controls = new TraitConfigPanel();

        public Ed(MenuSeparator p) {
            this.descInput = new StringConfigurer(p.desc);
            this.descInput.setHintKey("Editor.description_hint");
            this.controls.add("Editor.description_label", (Configurer)this.descInput);
            this.keyInput = new NamedHotKeyConfigurer(p.key);
            this.controls.add("Editor.MenuSeparator.if_hidden", (Configurer)this.keyInput);
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.descInput.getValueString()).append(this.keyInput.getValueString());
            return MenuSeparator.ID + se.getValue();
        }

        @Override
        public String getState() {
            return "";
        }
    }
}

