/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.GameState;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.MatCargo;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.Stack;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.KeyStroke;

public class Mat
extends Decorator
implements TranslatablePiece {
    public static final String ID = "mat;";
    public static final String MAT_NAME = "MatName";
    public static final String MAT_ID = "MatID";
    public static final String MAT_CONTENTS = "MatContents";
    public static final String MAT_NUM_CARGO = "MatNumCargo";
    protected String matName;
    protected String desc;
    protected List<GamePiece> contents = new ArrayList<GamePiece>();

    public Mat() {
        this("mat;Mat;;", null);
    }

    public Mat(String name) {
        this(ID + name + ";;", null);
    }

    public Mat(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public void mySetType(String type) {
        type = type.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        this.matName = st.nextToken();
        this.desc = st.nextToken();
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.matName).append(this.desc);
        return ID + se.getValue();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        return KeyCommand.NONE;
    }

    @Override
    public String myGetState() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.contents.size());
        for (GamePiece p : this.contents) {
            se.append(p.getId());
        }
        return se.getValue();
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        return null;
    }

    public List<GamePiece> getContents() {
        return new ArrayList<GamePiece>(this.contents);
    }

    public List<Point> getOffsets(int x, int y) {
        ArrayList<Point> offsets = new ArrayList<Point>();
        for (GamePiece piece : this.getContents()) {
            Point pt = piece.getPosition();
            pt.x -= x;
            pt.y -= y;
            offsets.add(pt);
        }
        return offsets;
    }

    @Override
    public void mySetState(String newState) {
        this.contents.clear();
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(newState, ';');
        int num = st.nextInt(0);
        GameState gs = GameModule.getGameModule().getGameState();
        for (int i = 0; i < num; ++i) {
            GamePiece piece = gs.getPieceForId(st.nextToken());
            if (piece == null) continue;
            this.addCargo(piece);
        }
        GameModule.getGameModule().setMatSupport(true);
    }

    public boolean hasCargo(GamePiece p) {
        return this.contents.contains(p);
    }

    public int getCargoCount() {
        return this.contents.size();
    }

    public void addCargo(GamePiece p) {
        if (!(p instanceof Decorator) || this.hasCargo(p)) {
            return;
        }
        this.contents.add(p);
        MatCargo cargo = (MatCargo)Decorator.getDecorator(Decorator.getOutermost(p), MatCargo.class);
        if (cargo != null) {
            GamePiece outer = Decorator.getOutermost(this);
            if (cargo.getMat() != this) {
                cargo.setMat(outer);
            }
        }
    }

    public Command makeAddCargoCommand(GamePiece p) {
        GamePiece mt;
        GamePiece cargo;
        ChangeTracker ct = new ChangeTracker(this);
        ChangeTracker ct2 = new ChangeTracker(p);
        ChangeTracker ct3 = null;
        if (p instanceof Decorator && !this.hasCargo(p) && (cargo = Decorator.getDecorator(Decorator.getOutermost(p), MatCargo.class)) != null && (mt = ((MatCargo)cargo).getMat()) != null && mt != Decorator.getOutermost(this)) {
            ct3 = new ChangeTracker(mt);
            Mat mat = (Mat)Decorator.getDecorator(mt, Mat.class);
            mat.removeCargo(p);
        }
        this.addCargo(p);
        Command c = ct.getChangeCommand().append(ct2.getChangeCommand());
        if (ct3 != null) {
            c = c.append(ct3.getChangeCommand());
        }
        return c;
    }

    public void removeCargo(GamePiece p) {
        if (p instanceof Decorator && this.hasCargo(p)) {
            this.contents.remove(p);
        }
    }

    public Command makeRemoveCargoCommand(GamePiece p) {
        ChangeTracker ct = new ChangeTracker(this);
        ChangeTracker ct2 = new ChangeTracker(p);
        this.removeCargo(p);
        return ct.getChangeCommand().append(ct2.getChangeCommand());
    }

    public Command makeRemoveAllCargoCommand() {
        Command c = new NullCommand();
        for (GamePiece p : this.getContents()) {
            c = c.append(this.makeRemoveCargoCommand(p));
        }
        return c;
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    public void drawCargo(Graphics g, int x, int y, Component obs, double zoom) {
        Point matPosition = this.getPosition();
        for (GamePiece piece : this.getContents()) {
            Point cargoPos = piece.getPosition();
            Stack parent = piece.getParent();
            if (parent instanceof Stack) {
                parent.draw(g, x - (matPosition.x - cargoPos.x), y - (matPosition.y - cargoPos.y), obs, zoom);
                continue;
            }
            piece.draw(g, x - (this.getPosition().x - cargoPos.x), y - (this.getPosition().y - cargoPos.y), obs, zoom);
        }
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public String getDescription() {
        return this.buildDescription("Editor.Mat.trait_description", this.matName, this.desc);
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.Mat.trait_description");
    }

    @Override
    public Object getProperty(Object key) {
        if (MAT_NAME.equals(key)) {
            return this.matName;
        }
        if (MAT_ID.equals(key)) {
            return this.matName + "_" + this.getProperty("PieceUID");
        }
        if (MAT_CONTENTS.equals(key)) {
            return new ArrayList<GamePiece>(this.contents);
        }
        if (MAT_NUM_CARGO.equals(key)) {
            return String.valueOf(this.contents.size());
        }
        if ("NoStack".equals(key)) {
            return Boolean.TRUE;
        }
        return super.getProperty(key);
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if (MAT_NAME.equals(key)) {
            return this.matName;
        }
        if (MAT_ID.equals(key)) {
            return this.matName + "_" + this.getProperty("PieceUID");
        }
        if (MAT_NUM_CARGO.equals(key)) {
            return String.valueOf(this.contents.size());
        }
        if ("NoStack".equals(key)) {
            return Boolean.TRUE;
        }
        return super.getLocalizedProperty(key);
    }

    @Override
    public void setProperty(Object key, Object value) {
        if (MAT_NAME.equals(key)) {
            this.matName = (String)value;
            return;
        }
        super.setProperty(key, value);
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof Mat)) {
            return false;
        }
        Mat c = (Mat)o;
        if (!Objects.equals(this.matName, c.matName)) {
            return false;
        }
        return Objects.equals(this.desc, c.desc);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Mat.html");
    }

    @Override
    public List<String> getPropertyNames() {
        return Arrays.asList(MAT_NAME, MAT_ID, MAT_NUM_CARGO, "CurrentMatProp0", "CurrentMatProp1", "CurrentMatProp2", "CurrentMatProp3", "CurrentMatProp4", "CurrentMatProp5", "CurrentMatProp6", "CurrentMatProp7", "CurrentMatProp8", "CurrentMatProp9");
    }

    public static class Ed
    implements PieceEditor {
        private final StringConfigurer matNameInput;
        private final StringConfigurer descInput;
        private final TraitConfigPanel controls = new TraitConfigPanel();

        public Ed(Mat p) {
            this.matNameInput = new StringConfigurer(p.matName);
            this.matNameInput.setHintKey("Editor.Mat.name_hint");
            this.controls.add("Editor.Mat.name_label", (Configurer)this.matNameInput);
            this.descInput = new StringConfigurer(p.desc);
            this.descInput.setHintKey("Editor.description_hint");
            this.controls.add("Editor.description_label", (Configurer)this.descInput);
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.matNameInput.getValueString());
            se.append(this.descInput.getValueString());
            return Mat.ID + se.getValue();
        }

        @Override
        public String getState() {
            return "";
        }
    }
}

