/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.Player;
import VASSAL.chat.Room;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SimpleRoom
implements Room {
    private String name;
    private final List<Player> players = new ArrayList<Player>();

    public SimpleRoom() {
    }

    public SimpleRoom(String name) {
        this(name, new Player[0]);
    }

    public SimpleRoom(String name, Player[] players) {
        this.name = name;
        this.setPlayers(players);
    }

    public SimpleRoom(Room copy) {
        this.name = copy.getName();
        this.players.addAll(copy.getPlayerList());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPlayers(Player[] players) {
        this.players.clear();
        for (Player p : players) {
            this.addPlayer(p);
        }
    }

    @Override
    public void addPlayer(Player p) {
        int index = this.players.indexOf(p);
        if (index < 0) {
            this.players.add(p);
        } else {
            this.players.set(index, p);
        }
    }

    public Player getPlayer(String id) {
        for (Player player : this.players) {
            if (!player.getId().equals(id)) continue;
            return player;
        }
        return null;
    }

    @Override
    public void removePlayer(Player p) {
        this.players.remove(p);
    }

    public boolean contains(Player p) {
        return this.players.contains(p);
    }

    public String toString() {
        return this.name;
    }

    public int numPlayers() {
        return this.players.size();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof SimpleRoom) {
            return this.name != null && this.name.equals(((SimpleRoom)o).name);
        }
        return false;
    }

    @Override
    public List<Player> getPlayerList() {
        return Collections.unmodifiableList(this.players);
    }
}

