/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.Player;
import VASSAL.chat.PlayerEncoder;
import VASSAL.chat.PrivMsgCommand;
import VASSAL.chat.PrivateChatManager;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.tools.SequenceEncoder;

public class PrivateChatEncoder
implements CommandEncoder {
    public static final String COMMAND_PREFIX = "PRIV_CHAT";
    private final PlayerEncoder playerEncoder;
    private final PrivateChatManager pChatMgr;

    public PrivateChatEncoder(PlayerEncoder playerEncoder, PrivateChatManager pChatMgr) {
        this.playerEncoder = playerEncoder;
        this.pChatMgr = pChatMgr;
    }

    @Override
    public String encode(Command c) {
        if (!(c instanceof PrivMsgCommand)) {
            return null;
        }
        PrivMsgCommand cmd = (PrivMsgCommand)c;
        SequenceEncoder se = new SequenceEncoder(COMMAND_PREFIX, '/');
        se.append(this.playerEncoder.playerToString(cmd.getSender())).append(cmd.getMessage());
        return se.getValue();
    }

    @Override
    public Command decode(String s) {
        if (!s.startsWith(COMMAND_PREFIX)) {
            return null;
        }
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, '/');
        st.nextToken();
        Player sender = this.playerEncoder.stringToPlayer(st.nextToken());
        return new PrivMsgCommand(this.pChatMgr, sender, st.nextToken());
    }
}

