/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.widget;

import VASSAL.build.Buildable;
import VASSAL.build.Widget;
import VASSAL.i18n.Resources;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class BoxWidget
extends Widget
implements ItemListener,
PropertyChangeListener {
    private JPanel panel;
    private JComboBox<Widget> box;
    private final DefaultComboBoxModel<Widget> widgets = new DefaultComboBoxModel();
    private final CardLayout layout = new CardLayout();
    private final JPanel multiPanel = new JPanel();
    private final List<Widget> built = new ArrayList<Widget>();
    private final Dimension size = new Dimension();
    private final Map<Object, String> keys = new HashMap<Object, String>();
    private int count = 0;

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.BoxWidget.component_type");
    }

    @Override
    public void add(Buildable b) {
        if (b instanceof Widget) {
            Widget w = (Widget)b;
            this.widgets.addElement(w);
            w.addPropertyChangeListener(this);
            if (this.panel != null) {
                this.multiPanel.add(this.getKey(w), w.getComponent());
            }
        }
        super.add(b);
    }

    @Override
    public void remove(Buildable b) {
        if (b instanceof Widget) {
            this.widgets.removeElement(b);
        }
        super.remove(b);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("name".equals(evt.getPropertyName()) && this.box != null) {
            this.box.revalidate();
        }
    }

    @Override
    public Component getComponent() {
        if (this.panel == null) {
            this.rebuild();
            this.box = new JComboBox();
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.multiPanel.setLayout(this.layout);
            if (this.size.width > 0 && this.size.height > 0) {
                this.multiPanel.setPreferredSize(this.size);
            }
            this.box.setModel(this.widgets);
            this.box.setRenderer(new Widget.MyCellRenderer());
            this.box.addItemListener(this);
            this.panel.add(this.box);
            this.panel.add(this.multiPanel);
            this.itemStateChanged(null);
        }
        return this.panel;
    }

    private String getKey(Object o) {
        String s = this.keys.get(o);
        if (s == null) {
            s = String.valueOf(this.count++);
            this.keys.put(o, s);
        }
        return s;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.box.getSelectedItem() != null) {
            Widget w = (Widget)this.box.getSelectedItem();
            if (!this.built.contains(w)) {
                this.multiPanel.add(this.getKey(w), w.getComponent());
                this.built.add(w);
            }
            this.layout.show(this.multiPanel, this.getKey(w));
        }
    }

    private boolean allChildrenBuilt() {
        return this.box != null && this.box.getModel().getSize() == this.built.size();
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"entryName", "width", "height"};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class};
    }

    @Override
    public void setAttribute(String name, Object value) {
        if ("entryName".equals(name)) {
            this.setConfigureName((String)value);
        } else if ("width".equals(name)) {
            this.size.width = Integer.parseInt(value.toString());
        } else if ("height".equals(name)) {
            this.size.height = Integer.parseInt(value.toString());
        }
    }

    @Override
    public String getAttributeValueString(String name) {
        if ("entryName".equals(name)) {
            return this.getConfigureName();
        }
        if ("width".equals(name)) {
            int w = this.allChildrenBuilt() ? this.multiPanel.getLayout().preferredLayoutSize((Container)this.multiPanel).width : this.size.width;
            return String.valueOf(w);
        }
        if ("height".equals(name)) {
            int h = this.allChildrenBuilt() ? this.multiPanel.getLayout().preferredLayoutSize((Container)this.multiPanel).height : this.size.height;
            return String.valueOf(h);
        }
        return null;
    }
}

