/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.noteswindow;

import VASSAL.build.GameModule;
import VASSAL.build.module.PlayerRoster;
import java.util.Date;
import java.util.Objects;

public class SecretNote {
    private final String owner;
    private final String name;
    private final String text;
    private final boolean hidden;
    private final Date date;
    private final String handle;

    public SecretNote(String name, String owner, String text, boolean hidden) {
        this(name, owner, text, hidden, new Date(), SecretNote.findHandle());
    }

    private static String findHandle() {
        return PlayerRoster.isActive() && PlayerRoster.getMySide() != null ? PlayerRoster.getMySide() : (String)GameModule.getGameModule().getPrefs().getOption("RealName").getValue();
    }

    public SecretNote(String name, String owner, String text, boolean hidden, Date created, String id) {
        this.name = name;
        this.owner = owner;
        this.text = text;
        this.hidden = hidden;
        this.date = created;
        this.handle = id;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public Date getDate() {
        return this.date;
    }

    public String getHandle() {
        return this.handle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecretNote)) {
            return false;
        }
        SecretNote secretNote = (SecretNote)o;
        return Objects.equals(this.name, secretNote.name) && Objects.equals(this.owner, secretNote.owner);
    }

    public int hashCode() {
        return Objects.hash(this.owner, this.name);
    }

    public String getText() {
        return this.text;
    }
}

