/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.metadata;

import VASSAL.build.GameModule;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.ModuleMetaData;
import VASSAL.i18n.Resources;
import VASSAL.tools.io.FileArchive;
import VASSAL.tools.io.ZipWriter;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SaveMetaData
extends AbstractMetaData {
    private static final Logger logger = LoggerFactory.getLogger(SaveMetaData.class);
    public static final String ZIP_ENTRY_NAME = "savedata";
    public static final String DATA_VERSION = "1";
    public static final String PROMPT_LOG_COMMENT = "promptLogComment";
    protected ModuleMetaData moduleData;

    public SaveMetaData() {
        if (((Boolean)GameModule.getGameModule().getPrefs().getValue(PROMPT_LOG_COMMENT)).booleanValue()) {
            JDialog d = new JDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, GameModule.getGameModule().getPlayerWindow()), true);
            d.setTitle(Resources.getString("BasicLogger.log_file_comments"));
            JLabel desc = new JLabel("<html><body><p style='width: 400px;'>" + Resources.getString("BasicLogger.enter_comments") + "</p></body></html>");
            JLabel commentLabel = new JLabel(Resources.getString("BasicLogger.log_file_comments"));
            JTextField commentField = new JTextField("", 32);
            commentLabel.setLabelFor(commentField);
            JCheckBox stopBox = new JCheckBox(Resources.getString("Editor.SaveMetaData.dont_ask_again"), false);
            JButton okay = new JButton(Resources.getString("General.ok"));
            okay.addActionListener(e -> {
                if (stopBox.isSelected()) {
                    GameModule.getGameModule().getPrefs().setValue(PROMPT_LOG_COMMENT, false);
                }
                String comments = commentField.getText();
                this.setDescription(new AbstractMetaData.Attribute("description", comments));
                d.dispose();
            });
            JButton cancel = new JButton(Resources.getString("General.cancel"));
            cancel.addActionListener(e1 -> {
                if (stopBox.isSelected()) {
                    GameModule.getGameModule().getPrefs().setValue(PROMPT_LOG_COMMENT, false);
                }
                d.dispose();
            });
            d.setLayout((LayoutManager)new MigLayout("insets dialog, nogrid", "", "[]unrel[]unrel:push[]"));
            d.add((Component)desc, "align left, wrap");
            d.add((Component)commentLabel, "align right, gapx rel");
            d.add((Component)commentField, "pushx, growx, wrap");
            d.add((Component)stopBox, "align center, gapx unrel, span");
            d.add((Component)okay, "tag ok, split");
            d.add((Component)cancel, "tag cancel");
            d.getRootPane().setDefaultButton(okay);
            KeyStroke k = KeyStroke.getKeyStroke(27, 0);
            int w = 2;
            d.getRootPane().registerKeyboardAction(ee -> {
                if (stopBox.isSelected()) {
                    GameModule.getGameModule().getPrefs().setValue(PROMPT_LOG_COMMENT, false);
                }
                d.dispose();
            }, k, 2);
            commentField.requestFocus();
            d.pack();
            d.setLocationRelativeTo(d.getParent());
            d.setVisible(true);
        }
    }

    public SaveMetaData(ZipFile zip) {
        this.read(zip);
    }

    public String getModuleName() {
        return this.moduleData == null ? "" : this.moduleData.getName();
    }

    public String getModuleVersion() {
        return this.moduleData == null ? "" : this.moduleData.getVersion();
    }

    public ModuleMetaData getModuleData() {
        return this.moduleData;
    }

    @Override
    public String getZipEntryName() {
        return ZIP_ENTRY_NAME;
    }

    @Override
    public String getMetaDataVersion() {
        return DATA_VERSION;
    }

    @Override
    public void save(FileArchive archive) throws IOException {
        super.save(archive);
        this.copyModuleMetadata(archive);
    }

    @Override
    public void save(ZipWriter zw) throws IOException {
        super.save(zw);
        this.copyModuleMetadata(zw);
    }

    @Override
    protected void addElements(Document doc, Element root) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(ZipFile zip) {
        try (ZipFile zipFile = zip;){
            ZipEntry data = zip.getEntry(this.getZipEntryName());
            if (data == null) {
                return;
            }
            AbstractMetaData.XMLHandler handler = new AbstractMetaData.XMLHandler(this);
            try (InputStream zin = zip.getInputStream(data);
                 BufferedInputStream in = new BufferedInputStream(zin);){
                XMLReader xMLReader = parser;
                synchronized (xMLReader) {
                    parser.setContentHandler(handler);
                    parser.setDTDHandler(handler);
                    parser.setEntityResolver(handler);
                    parser.setErrorHandler(handler);
                    parser.parse(new InputSource(in));
                }
            }
            this.moduleData = new ModuleMetaData(zip);
        }
        catch (IOException | SAXException e) {
            logger.error("", (Throwable)e);
        }
    }
}

