/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.Drawable;
import VASSAL.command.Command;
import VASSAL.configure.ColorConfigurer;
import VASSAL.counters.ColoredBorder;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Stack;
import VASSAL.i18n.Resources;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;

public class HighlightLastMoved
extends AbstractConfigurable
implements Drawable,
MouseListener,
GameComponent {
    public static final String ENABLED = "enabled";
    public static final String COLOR = "color";
    public static final String THICKNESS = "thickness";
    protected ColoredBorder highlighter = new ColoredBorder(Color.RED, 2);
    protected GamePiece lastMoved;
    protected static final java.util.Map<Map, HighlightLastMoved> instances = new HashMap<Map, HighlightLastMoved>();
    protected boolean enabled = true;
    protected boolean currentlyEnabled;

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.HighlightLastMoved.enabled"), Resources.getString("Editor.color_label"), Resources.getString("Editor.HighlightLastMoved.thickness")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{Boolean.class, Color.class, Integer.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{ENABLED, COLOR, THICKNESS};
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (COLOR.equals(key)) {
            if (value instanceof String) {
                value = ColorConfigurer.stringToColor((String)value);
            }
            this.highlighter.setColor((Color)value);
        } else if (THICKNESS.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.highlighter.setThickness((Integer)value);
        } else if (ENABLED.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.enabled = (Boolean)value;
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (COLOR.equals(key)) {
            return ColorConfigurer.colorToString(this.highlighter.getColor());
        }
        if (THICKNESS.equals(key)) {
            return String.valueOf(this.highlighter.getThickness());
        }
        if (ENABLED.equals(key)) {
            return String.valueOf(this.enabled);
        }
        return null;
    }

    @Override
    public void addTo(Buildable parent) {
        Map map = (Map)parent;
        map.addDrawComponent(this);
        map.addLocalMouseListener(this);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        instances.put(map, this);
    }

    @Override
    public void removeFrom(Buildable parent) {
        Map map = (Map)parent;
        map.removeDrawComponent(this);
        map.removeLocalMouseListener(this);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
        instances.remove(map);
    }

    @Override
    public void draw(Graphics g, Map map) {
        if (this.lastMoved == null || !this.enabled) {
            return;
        }
        if (this.lastMoved.getMap() == map) {
            Graphics2D g2d = (Graphics2D)g;
            double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
            double zoom = map.getZoom() * os_scale;
            this.highlighter.draw(this.lastMoved, g, (int)((double)this.lastMoved.getPosition().x * zoom), (int)((double)this.lastMoved.getPosition().y * zoom), map.getView(), zoom);
        } else {
            this.lastMoved = null;
        }
    }

    @Override
    public void setup(boolean gameStarting) {
        this.currentlyEnabled = gameStarting && this.enabled;
        this.lastMoved = null;
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    public static void setLastMoved(GamePiece p) {
        HighlightLastMoved h = instances.get(p.getMap());
        if (h != null) {
            h.setLastMovedPiece(p);
        }
    }

    public void setLastMovedPiece(GamePiece p) {
        if (this.currentlyEnabled) {
            this.lastMoved = p.getParent() instanceof Stack ? p.getParent() : p;
            if (this.lastMoved.getMap() != null) {
                this.lastMoved.getMap().getPieceCollection().moveToFront(this.lastMoved);
            }
        }
    }

    @Override
    public boolean drawAboveCounters() {
        return true;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.lastMoved = null;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.html", "LastMoveHighlighter");
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.HighlightLastMoved.component_type");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }
}

