/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GlobalKeyCommand;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import java.util.List;
import javax.swing.SwingUtilities;

public class StartupGlobalKeyCommand
extends GlobalKeyCommand
implements GameComponent {
    private boolean hasStarted = false;

    public StartupGlobalKeyCommand() {
        this.launch.setAttribute("buttonText", "");
        this.launch.setAttribute("tooltip", "");
        this.launch.setAttribute("icon", "");
        this.launch.setAttribute("buttonHotkey", "");
    }

    @Override
    public void addTo(Buildable parent) {
        super.addTo(parent);
        GameModule.getGameModule().getGameState().addGameComponent(this);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.StartupGlobalKeyCommand.component_type");
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.html", "StartupGlobalKeyCommand");
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String key) {
        if (List.of("buttonText", "tooltip", "icon", "buttonHotkey").contains(key)) {
            return () -> false;
        }
        return super.getAttributeVisibility(key);
    }

    @Override
    public void setup(boolean gameStarting) {
        if (gameStarting && !this.hasStarted) {
            SwingUtilities.invokeLater(this::apply);
        }
        this.hasStarted = gameStarting;
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }
}

