/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractFolder;
import VASSAL.build.AbstractToolbarItem;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.SpecialDie;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.MutablePropertiesContainer;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.NullCommand;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.PlayerIdFormattedStringConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.search.HTMLImageFinder;
import VASSAL.tools.FormattedString;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.UniqueIdManager;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.OwningOpMultiResolutionImage;
import VASSAL.tools.imageop.SourceOp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecialDiceButton
extends AbstractToolbarItem
implements CommandEncoder,
UniqueIdManager.Identifyable {
    private static final Logger logger = LoggerFactory.getLogger(SpecialDiceButton.class);
    protected static final UniqueIdManager idMgr = new UniqueIdManager("SpecialDiceButton");
    public static final String SHOW_RESULTS_COMMAND = "SHOW_RESULTS\t";
    protected List<SpecialDie> dice = new ArrayList<SpecialDie>();
    protected Random ran;
    protected boolean reportResultAsText = true;
    protected boolean reportResultInWindow = false;
    protected boolean reportResultInButton = false;
    protected String id;
    protected String sMapName;
    protected JDialog dialog;
    protected JLabel dialogLabel;
    protected Color bgColor;
    protected ResultsIcon resultsIcon = new ResultsIcon();
    protected FormattedString format = new FormattedString();
    protected String chatResultFormat = "** $name$ = [$result1$] *** &lt;$PlayerName$&gt;";
    protected String windowTitleResultFormat = "$name$";
    protected String tooltip = "";
    protected final MutableProperty.Impl property = new MutableProperty.Impl("", this);
    public static final String RESULT_CHATTER = "resultChatter";
    public static final String CHAT_RESULT_FORMAT = "format";
    public static final String RESULT_N = "result#";
    public static final String RESULT_TOTAL = "numericalTotal";
    public static final String RESULT_WINDOW = "resultWindow";
    public static final String WINDOW_TITLE_RESULT_FORMAT = "windowTitleResultFormat";
    public static final String RESULT_BUTTON = "resultButton";
    public static final String WINDOW_X = "windowX";
    public static final String WINDOW_Y = "windowY";
    public static final String BACKGROUND_COLOR = "backgroundColor";
    public static final String DICE_SET = "diceSet";
    public static final String NONE = "&lt;none&gt;";
    private static final int[] EMPTY = new int[0];
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String BUTTON_TEXT = "text";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String TOOLTIP = "tooltip";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String NAME = "name";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String ICON = "icon";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String HOTKEY = "hotkey";

    public SpecialDiceButton() {
        this.dialog = new JDialog(GameModule.getGameModule().getPlayerWindow());
        this.dialog.setLayout((LayoutManager)new MigLayout("ins 0"));
        this.dialogLabel = new JLabel();
        this.dialogLabel.setIcon(this.resultsIcon);
        this.dialog.add(this.dialogLabel);
        ActionListener rollAction = e -> this.DR();
        String desc = Resources.getString("Editor.SpecialDiceButton.symbols");
        this.setLaunchButton(this.makeLaunchButton(desc, desc, "/images/die.gif", rollAction));
        this.setAttribute(NAME, desc);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.SpecialDiceButton.component_type");
    }

    protected String getReportPrefix() {
        return " *** " + this.getConfigureName() + " = ";
    }

    protected void DR() {
        int[] results = new int[this.dice.size()];
        int i = 0;
        for (SpecialDie sd : this.dice) {
            int faceCount = sd.getFaceCount();
            results[i++] = faceCount == 0 ? 0 : this.ran.nextInt(sd.getFaceCount());
        }
        this.setFormat(results);
        Command c = this.reportResults(results);
        if (this.reportResultAsText) {
            c = c.append(this.reportTextResults(results));
        }
        GameModule.getGameModule().sendAndLog(c);
    }

    private Command reportResults(int[] results) {
        this.resultsIcon.setResults(results);
        if (this.reportResultInWindow) {
            this.dialogLabel.setSize(new Dimension(this.resultsIcon.width, this.resultsIcon.height));
            this.dialogLabel.setMinimumSize(new Dimension(this.resultsIcon.width, this.resultsIcon.height));
            this.format.setFormat(this.windowTitleResultFormat);
            this.dialog.setTitle(this.format.getLocalizedText(this, "Editor.SpecialDiceButton.window_title"));
            this.dialog.pack();
            this.dialog.setVisible(true);
            this.dialogLabel.repaint();
        }
        if (this.reportResultInButton) {
            this.launch.repaint();
        }
        return new ShowResults(this, results);
    }

    private Command reportTextResults(int[] results) {
        int total = 0;
        for (int i = 0; i < this.dice.size(); ++i) {
            SpecialDie die = this.dice.get(i);
            total += die.getIntValue(results[i]);
        }
        this.format.setFormat(this.chatResultFormat);
        Object msg = this.format.getLocalizedText(this, "Editor.report_format");
        if (((String)msg).length() > 0) {
            msg = ((String)msg).startsWith("*") ? "*" + (String)msg : "* " + (String)msg;
        }
        Command c = ((String)msg).length() == 0 ? new NullCommand() : new Chatter.DisplayText(GameModule.getGameModule().getChatter(), (String)msg);
        c.execute();
        c.append(this.property.setPropertyValue(String.valueOf(total)));
        return c;
    }

    protected void setFormat(int[] results) {
        this.format.setProperty(NAME, this.getLocalizedConfigureName());
        int total = 0;
        for (int i = 0; i < this.dice.size(); ++i) {
            SpecialDie die = this.dice.get(i);
            this.format.setProperty("result" + (i + 1), die.getTextValue(results[i]));
            total += die.getIntValue(results[i]);
        }
        this.format.setProperty(RESULT_TOTAL, String.valueOf(total));
        this.format.setFormat(this.chatResultFormat);
    }

    @Override
    public String[] getAttributeNames() {
        return (String[])ArrayUtils.addAll((Object[])super.getAttributeNames(), (Object[])new String[]{RESULT_CHATTER, CHAT_RESULT_FORMAT, RESULT_WINDOW, WINDOW_TITLE_RESULT_FORMAT, RESULT_BUTTON, WINDOW_X, WINDOW_Y, BACKGROUND_COLOR});
    }

    @Override
    public String[] getAttributeDescriptions() {
        return (String[])ArrayUtils.addAll((Object[])super.getAttributeDescriptions(), (Object[])new String[]{Resources.getString("Editor.SpecialDiceButton.report_results_text"), Resources.getString("Editor.report_format"), Resources.getString("Editor.SpecialDiceButton.result_window"), Resources.getString("Editor.SpecialDiceButton.window_title"), Resources.getString("Editor.SpecialDiceButton.result_button"), Resources.getString("Editor.width"), Resources.getString("Editor.height"), Resources.getString("Editor.background_color")});
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return (Class[])ArrayUtils.addAll((Object[])super.getAttributeTypes(), (Object[])new Class[]{Boolean.class, ReportFormatConfig.class, Boolean.class, ReportFormatConfig.class, Boolean.class, Integer.class, Integer.class, Color.class});
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (List.of(WINDOW_X, WINDOW_Y, BACKGROUND_COLOR).contains(name)) {
            return () -> this.reportResultInWindow || this.reportResultInButton;
        }
        if (CHAT_RESULT_FORMAT.equals(name)) {
            return () -> this.reportResultAsText;
        }
        if (WINDOW_TITLE_RESULT_FORMAT.equals(name)) {
            return () -> this.reportResultInWindow;
        }
        return null;
    }

    public void addSpecialDie(SpecialDie d) {
        this.dice.add(d);
    }

    public void removeSpecialDie(SpecialDie d) {
        this.dice.remove(d);
    }

    @Override
    public void addTo(Buildable parent) {
        if (parent instanceof AbstractFolder) {
            parent = ((AbstractFolder)parent).getNonFolderAncestor();
        }
        this.resultsIcon.setResults(new int[this.dice.size()]);
        this.launch.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (SpecialDiceButton.this.launch.isShowing()) {
                    SpecialDiceButton.this.dialog.setLocationRelativeTo(SpecialDiceButton.this.launch);
                    SpecialDiceButton.this.launch.removeHierarchyListener(this);
                }
            }
        });
        GameModule mod = GameModule.getGameModule();
        this.ran = mod.getRNG();
        mod.getToolBar().add(this.launch);
        idMgr.add(this);
        mod.addCommandEncoder(this);
        this.property.addTo((MutablePropertiesContainer)((Object)parent));
    }

    @Override
    public void removeFrom(Buildable b) {
        GameModule mod = GameModule.getGameModule();
        mod.removeCommandEncoder(this);
        mod.getToolBar().remove(this.launch);
        mod.getToolBar().revalidate();
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getIdentifier() {
        return UniqueIdManager.getIdentifier(this);
    }

    private boolean getBoolVal(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return "true".equals(o);
        }
        return false;
    }

    @Override
    public void setAttribute(String key, Object o) {
        if (NAME.equals(key)) {
            this.setConfigureName((String)o);
            this.property.setPropertyName(this.getConfigureName() + "_result");
            this.getLaunchButton().setToolTipText((String)o);
        } else if (RESULT_CHATTER.equals(key)) {
            this.reportResultAsText = this.getBoolVal(o);
        } else if (CHAT_RESULT_FORMAT.equals(key)) {
            this.chatResultFormat = (String)o;
        } else if (RESULT_BUTTON.equals(key)) {
            this.reportResultInButton = this.getBoolVal(o);
            if (this.reportResultInButton) {
                this.launch.setIcon(this.resultsIcon);
            }
        } else if (RESULT_WINDOW.equals(key)) {
            this.reportResultInWindow = this.getBoolVal(o);
        } else if (WINDOW_TITLE_RESULT_FORMAT.equals(key)) {
            this.windowTitleResultFormat = (String)o;
        } else if (WINDOW_X.equals(key)) {
            if (o instanceof String) {
                o = Integer.valueOf((String)o);
            }
            this.resultsIcon.width = (Integer)o;
            this.dialog.pack();
        } else if (WINDOW_Y.equals(key)) {
            if (o instanceof String) {
                o = Integer.valueOf((String)o);
            }
            this.resultsIcon.height = (Integer)o;
            this.dialog.pack();
        } else if (BACKGROUND_COLOR.equals(key)) {
            if (o instanceof String) {
                o = ColorConfigurer.stringToColor((String)o);
            }
            this.bgColor = (Color)o;
        } else if (TOOLTIP.equals(key)) {
            this.tooltip = (String)o;
            this.launch.setAttribute(key, o);
        } else {
            super.setAttribute(key, o);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (RESULT_CHATTER.equals(key)) {
            return String.valueOf(this.reportResultAsText);
        }
        if (CHAT_RESULT_FORMAT.equals(key)) {
            return this.chatResultFormat;
        }
        if (RESULT_BUTTON.equals(key)) {
            return String.valueOf(this.reportResultInButton);
        }
        if (RESULT_WINDOW.equals(key)) {
            return String.valueOf(this.reportResultInWindow);
        }
        if (WINDOW_TITLE_RESULT_FORMAT.equals(key)) {
            return this.windowTitleResultFormat;
        }
        if (WINDOW_X.equals(key)) {
            return String.valueOf(this.resultsIcon.width);
        }
        if (WINDOW_Y.equals(key)) {
            return String.valueOf(this.resultsIcon.height);
        }
        if (BACKGROUND_COLOR.equals(key)) {
            return ColorConfigurer.colorToString(this.bgColor);
        }
        if (TOOLTIP.equals(key)) {
            return this.tooltip.length() == 0 ? this.launch.getAttributeValueString(this.name) : this.tooltip;
        }
        return super.getAttributeValueString(key);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{SpecialDie.class};
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("SpecialDiceButton.html");
    }

    public static String intArrayToString(int[] ia) {
        if (ia == null || ia.length == 0) {
            return "";
        }
        SequenceEncoder se = new SequenceEncoder(',');
        for (int value : ia) {
            se.append(String.valueOf(value));
        }
        return se.getValue();
    }

    public static int[] stringToIntArray(String s) {
        if (s == null || s.length() == 0) {
            return EMPTY;
        }
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, ',');
        ArrayList<String> l = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        int[] val = new int[l.size()];
        for (int i = 0; i < val.length; ++i) {
            val[i] = Integer.parseInt((String)l.get(i));
        }
        return val;
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.getConfigureName() + "_result");
        return l;
    }

    @Override
    public String encode(Command c) {
        if (!(c instanceof ShowResults)) {
            return null;
        }
        ShowResults c2 = (ShowResults)c;
        SequenceEncoder se = new SequenceEncoder(c2.target.getIdentifier(), '\t');
        for (int i = 0; i < c2.rolls.length; ++i) {
            se.append(Integer.toString(c2.rolls[i]));
        }
        return SHOW_RESULTS_COMMAND + se.getValue();
    }

    @Override
    public Command decode(String s) {
        SequenceEncoder.Decoder st = null;
        if (s.startsWith(SHOW_RESULTS_COMMAND + this.getConfigureName()) || s.startsWith(SHOW_RESULTS_COMMAND + this.getId())) {
            st = new SequenceEncoder.Decoder(s, '\t');
            st.nextToken();
            st.nextToken();
        } else if (s.startsWith(this.getId() + "\t")) {
            st = new SequenceEncoder.Decoder(s, '\t');
            st.nextToken();
        }
        if (st == null) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        int[] results = new int[l.size()];
        int i = 0;
        for (String n : l) {
            results[i++] = Integer.parseInt(n);
        }
        return new ShowResults(this, results);
    }

    @Override
    public List<String> getFormattedStringList() {
        return List.of(this.windowTitleResultFormat, this.chatResultFormat);
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        HTMLImageFinder h = new HTMLImageFinder(this.chatResultFormat);
        h.addImageNames(s);
    }

    private class ResultsIcon
    implements Icon {
        private int width;
        private int height;
        private Icon[] icons;

        private void setResults(int[] results) {
            this.icons = new Icon[results.length];
            if (results.length > SpecialDiceButton.this.dice.size()) {
                logger.warn("Special Die Button (" + SpecialDiceButton.this.getConfigureName() + "): more results (" + results.length + ") requested than dice (" + SpecialDiceButton.this.dice.size() + ")");
            }
            for (int i = 0; i < results.length && i < SpecialDiceButton.this.dice.size(); ++i) {
                SourceOp sop;
                String imageName = SpecialDiceButton.this.dice.get(i).getImageName(results[i]);
                if (imageName.length() <= 0 || (sop = Op.load(imageName)).getImage() == null) continue;
                this.icons[i] = new ImageIcon(new OwningOpMultiResolutionImage(sop));
            }
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (SpecialDiceButton.this.bgColor != null) {
                g.setColor(SpecialDiceButton.this.bgColor);
                g.fillRect(x, y, this.width, this.height);
            }
            int offset = 0;
            for (Icon icon : this.icons) {
                if (icon == null) continue;
                icon.paintIcon(c, g, x + offset, y);
                offset += icon.getIconWidth();
            }
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    public static class ShowResults
    extends Command {
        private final SpecialDiceButton target;
        private final int[] rolls;

        public ShowResults(SpecialDiceButton oTarget, int[] results) {
            this.target = oTarget;
            this.rolls = Arrays.copyOf(results, results.length);
        }

        @Override
        protected void executeCommand() {
            this.target.setFormat(this.rolls);
            this.target.reportResults(this.rolls);
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }
    }

    public static class ReportFormatConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new PlayerIdFormattedStringConfigurer(key, name, new String[]{SpecialDiceButton.NAME, SpecialDiceButton.RESULT_N, SpecialDiceButton.RESULT_TOTAL});
        }
    }

    @Deprecated(since="2020-10-01", forRemoval=true)
    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, "/images/die.gif");
        }
    }
}

