/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.BadDataReport;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.DiceButton;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.ConfigurerWindow;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.search.HTMLImageFinder;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.swing.SwingUtils;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class RandomTextButton
extends DiceButton {
    protected String[] m_faces;
    protected boolean isNumeric;
    public static final String FACES = "faces";
    public static final String NUMERIC = "numeric";

    public RandomTextButton() {
        ActionListener ranAction = e -> {
            if (this.promptAlways) {
                this.promptAlways = false;
                AutoConfigurer ac = (AutoConfigurer)this.getConfigurer();
                ConfigurerWindow w = new ConfigurerWindow(ac, true);
                List<String> hideAttributes = Arrays.asList("name", "text", "tooltip", "icon", "hotkey", "prompt", "reportFormat", "reportTotal", FACES, NUMERIC);
                for (String attr : hideAttributes) {
                    ac.getConfigurer(attr).getControls().setVisible(false);
                    ac.getLabel(attr).setVisible(false);
                }
                SwingUtils.repack(w, true);
                w.setVisible(true);
                for (String attr : hideAttributes) {
                    ac.getConfigurer(attr).getControls().setVisible(true);
                    ac.getLabel(attr).setVisible(true);
                }
                if (!w.isCancelled()) {
                    this.DR();
                }
                this.promptAlways = true;
            } else {
                this.DR();
            }
        };
        this.makeLaunchButton("", "", "", ranAction);
        this.setAttributeTranslatable(FACES, true);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.RandomTextButton.component_type");
    }

    @Override
    protected void DR() {
        String report;
        StringBuilder result = new StringBuilder();
        int total = this.addToTotal;
        for (int i = 0; i < this.nDice; ++i) {
            int roll = this.ran.nextInt(this.nSides) + 1;
            if (this.isNumeric) {
                try {
                    if (roll <= this.m_faces.length) {
                        roll = Integer.parseInt(this.m_faces[roll - 1]) + this.plus;
                    } else {
                        ErrorDialog.dataWarning(new BadDataReport(Resources.getString("Dice.random_text_too_few_faces", this.name), String.valueOf(roll)));
                        roll = this.plus;
                    }
                }
                catch (NumberFormatException ex) {
                    ErrorDialog.dataWarning(new BadDataReport(Resources.getString("Dice.random_text_non_numeric", this.name), this.m_faces[roll - 1]));
                    roll = 1;
                }
            }
            if (this.reportTotal && this.isNumeric) {
                total += roll;
                continue;
            }
            if (!this.isNumeric) {
                if (this.m_faces != null && roll <= this.m_faces.length) {
                    result.append(this.m_faces[roll - 1]);
                } else {
                    ErrorDialog.dataWarning(new BadDataReport(Resources.getString("Dice.random_text_too_few_faces", this.name), String.valueOf(roll)));
                    result.append('0');
                }
            } else {
                result.append(roll);
            }
            if (i >= this.nDice - 1) continue;
            result.append(',');
        }
        if (this.reportTotal && this.isNumeric) {
            result.append(total);
        }
        Command c = (report = this.formatResult(result.toString())).length() == 0 ? new NullCommand() : new Chatter.DisplayText(GameModule.getGameModule().getChatter(), report);
        c.execute();
        c.append(this.property.setPropertyValue(result.toString()));
        GameModule.getGameModule().sendAndLog(c);
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (List.of("reportTotal", "plus", "addToTotal").contains(name)) {
            return () -> this.isNumeric;
        }
        return super.getAttributeVisibility(name);
    }

    @Override
    public String[] getAttributeNames() {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(super.getAttributeNames()));
        l.remove("nSides");
        l.add(FACES);
        l.add(NUMERIC);
        return l.toArray(new String[0]);
    }

    @Override
    public String[] getAttributeDescriptions() {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(super.getAttributeDescriptions()));
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(super.getAttributeNames()));
        l.remove(names.indexOf("nSides"));
        l.add(Resources.getString("Editor.RandomTextButton.faces"));
        l.add(Resources.getString("Editor.RandomTextButton.faces_numeric"));
        return l.toArray(new String[0]);
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        ArrayList l = new ArrayList(Arrays.asList(super.getAttributeTypes()));
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(super.getAttributeNames()));
        l.remove(names.indexOf("nSides"));
        l.add(String[].class);
        l.add(Boolean.class);
        return l.toArray(new Class[0]);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (NUMERIC.equals(key)) {
            this.isNumeric = Boolean.TRUE.equals(value) || "true".equals(value);
        } else if (FACES.equals(key)) {
            if (value instanceof String) {
                value = StringArrayConfigurer.stringToArray((String)value);
            }
            this.m_faces = value;
            this.nSides = this.m_faces.length;
        } else {
            super.setAttribute(key, value);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NUMERIC.equals(key)) {
            return String.valueOf(this.isNumeric);
        }
        if (FACES.equals(key)) {
            return StringArrayConfigurer.arrayToString(this.m_faces);
        }
        return super.getAttributeValueString(key);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.html", "RandomTextButton");
    }

    @Override
    public List<String> getFormattedStringList() {
        return new ArrayList<String>(Arrays.asList(this.m_faces));
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        for (String f : this.m_faces) {
            HTMLImageFinder h = new HTMLImageFinder(f);
            h.addImageNames(s);
        }
    }
}

