"use strict";
// Copyright 2012-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
// tslint:disable:max-line-length | This is generated code - line lengths are difficult to control
const cloudwatch = require("@aws-cdk/aws-cloudwatch");
const topic_base_1 = require("./topic-base");
topic_base_1.TopicBase.prototype.metric = function (metricName, props) {
    return new cloudwatch.Metric({
        namespace: 'AWS/SNS',
        metricName,
        dimensions: { TopicName: this.topicName },
        ...props
    }).attachTo(this);
};
topic_base_1.TopicBase.prototype.metricPublishSize = function (props) {
    return this.metric('PublishSize', { statistic: 'Average', ...props });
};
topic_base_1.TopicBase.prototype.metricNumberOfMessagesPublished = function (props) {
    return this.metric('NumberOfMessagesPublished', { statistic: 'Sum', ...props });
};
topic_base_1.TopicBase.prototype.metricNumberOfNotificationsDelivered = function (props) {
    return this.metric('NumberOfNotificationsDelivered', { statistic: 'Sum', ...props });
};
topic_base_1.TopicBase.prototype.metricNumberOfNotificationsFailed = function (props) {
    return this.metric('NumberOfNotificationsFailed', { statistic: 'Sum', ...props });
};
topic_base_1.TopicBase.prototype.metricNumberOfNotificationsFilteredOut = function (props) {
    return this.metric('NumberOfNotificationsFilteredOut', { statistic: 'Sum', ...props });
};
topic_base_1.TopicBase.prototype.metricNumberOfNotificationsFilteredOutNoMessageAttributes = function (props) {
    return this.metric('NumberOfNotificationsFilteredOut-NoMessageAttributes', { statistic: 'Sum', ...props });
};
topic_base_1.TopicBase.prototype.metricNumberOfNotificationsFilteredOutInvalidAttributes = function (props) {
    return this.metric('NumberOfNotificationsFilteredOut-InvalidAttributes', { statistic: 'Sum', ...props });
};
topic_base_1.TopicBase.prototype.metricSMSMonthToDateSpentUSD = function (props) {
    return this.metric('SMSMonthToDateSpentUSD', { statistic: 'Maximum', ...props });
};
topic_base_1.TopicBase.prototype.metricSMSSuccessRate = function (props) {
    return this.metric('SMSSuccessRate', { statistic: 'Sum', ...props });
};
//# sourceMappingURL=data:application/json;base64,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