<p align="center">
   <a href="https://hypixel.net" style="text-decoration: none">
      <img src="https://i.imgur.com/eFWzNiy.png">
   </a>
</p>
<p align="center">
    <a href="https://api.hypixel.net">
        <img src="https://img.shields.io/badge/hypixel--api-python-brightgreen.svg?colorA=2d2306&colorB=705810"
             alt="Hypixel API - Python">
    </a>
    <a href="https://pypi.org/project/hypixel/" style="text-decoration: none">
        <img src="https://img.shields.io/pypi/v/hypixel.svg?colorA=2d2306&colorB=705810"
             alt="PyPi Version">
    </a>
    <a href="https://gitlab.com/SnuggIe/hypixel.py/pipelines" style="text-decoration: none">
        <img src="https://img.shields.io/badge/build-not yet implemented :(-brightgreen.svg?colorA=2d2306&colorB=705810"
             alt="Automated CI Testing">
    </a>
    <a href="https://python.org/downloads/" style="text-decoration: none">
        <img src="https://img.shields.io/pypi/pyversions/hypixel.svg?colorA=2d2306&colorB=705810"
             alt="Supported Python Versions">
    </a>
    <a href="https://hypixel.net/player/Snuggle" style="text-decoration: none">
        <img src="https://img.shields.io/badge/made%20by-snuggle%20|%20hypixel%20moderator-brightgreen.svg?colorA=2d2306&colorB=705810"
             alt="Made by Snuggle">
    </a>
    <a href="https://hypixel.readthedocs.io" style="text-decoration: none">
        <img src="https://img.shields.io/readthedocs/hypixel.svg?colorA=2d2306&colorB=705810"
             alt="Docs: Unknown">
    </a>
</p>

hypixel.py: A simple, community Python library which allows you to get values from the [Hypixel API](https://api.hypixel.net) using JSON requests.
Designed for use with the latest version of Python with two previous versions also tested.<br><br>
### 🎮🕹️ Being used to power my [Hypixel Discord bot](https://github.com/Snuggle/hypixel-bot) and hopefully other people's projects soon!
<p align="center">
   <a href="https://github.com/Snuggle/hypixel-bot" style="text-decoration: none">
      <img src="https://i.imgur.com/8MjYLF1.png">
   </a>
</p>


<hr>

## How to install

If you're using Windows:
```
pip install hypixel
```

If you're using Linux:

```
python3 -m pip install -U hypixel
```

If you're using Mac:

```
pip3 install hypixel
```

Then, put on the top of your code ```import hypixel```.

## Recent Changes
For the latest news and updates to this library, check out our [changelog](http://hypixel.readthedocs.io/en/latest/whats_new.html).

## What can you do?
If you learn-by-reading, take a look at [http://hypixel.readthedocs.io/](http://hypixel.readthedocs.io/en/latest/) to see what this library is capable of. Get creating straight away!

## Are there any examples?
Yup! There are currently two different examples that you can view: one's pretty simple, and the others a bit more advanced. Check them out at: [Examples](./.examples/).

You could also look at my Hypixel bot for Discord, which uses this library and provides players an awesome way to look at people's statistics! https://sprinkly.net/hypixelbot

## Can I contribute to this?
Heckas! You would be super awesome if you did that! Get started by checking out the guidelines on contributing here, have a look at [the contributing guidelines](./docs/contributing.md)!

## Got any issues?
Check out the current [Issues](https://github.com/Snuggle/hypixel.py/issues/) for anyone else with your issue, or post a [new Issue](https://github.com/Snuggle/hypixel.py/issues/new/) for help! 
