lexer grammar MDXLexer;

options {
    language = Python;
//    language = Java;
//    caseSensitiveLiterals=false;
}

PLUS : '+';
MINUS : '-';
ASTERISK : '*';
SOLIDUS : '/';
DOT : '.' ;

DIMENSION : 'DIMENSION';
HIERARCHY : 'HIERARCHY';
LEVEL : 'LEVEL';
LEVELS : 'LEVELS';

CATALOG_NAME : 'CATALOG_NAME';
SCHEMA_NAME : 'SCHEMA_NAME';
CUBE_NAME : 'CUBE_NAME';
DIMENSION_UNIQUE_NAME : 'DIMENSION_UNIQUE_NAME';
HIERARCHY_UNIQUE_NAME : 'HIERARCHY_UNIQUE_NAME';
LEVEL_UNIQUE_NAME : 'LEVEL_UNIQUE_NAME';
LEVEL_NUMBER : 'LEVEL_NUMBER';
MEMBER_UNIQUE_NAME : 'MEMBER_UNIQUE_NAME';
MEMBER_NAME : 'MEMBER_NAME';
MEMBER_TYPE : 'MEMBER_TYPE';
MEMBER_GUID : 'MEMBER_GUID';
MEMBER_CAPTION : 'MEMBER_CAPTION';
MEMBER_ORDINAL : 'MEMBER_ORDINAL';
CHILDREN_CARDINALITY : 'CHILDREN_CARDINALITY';
PARENT_LEVEL : 'PARENT_LEVEL';
PARENT_UNIQUE_NAME : 'PARENT_UNIQUE_NAME';
PARENT_COUNT : 'PARENT_COUNT';
DESCRIPTION : 'DESCRIPTION';
IIF : 'IIF';
CASE : 'CASE';
END : 'END';
COALESCEEMPTY : 'COALESCEEMPTY';
WHEN : 'WHEN';
THEN : 'THEN';
ELSE : 'ELSE';
MEMBERS : 'MEMBERS' ;
//CHILDREN : 'CHILDREN' ;
BOTTOMCOUNT : 'BOTTOMCOUNT' ;
BOTTOMPERCENT : 'BOTTOMPERCENT' ;
BOTTOMSUM : 'BOTTOMSUM' ;
CROSSJOIN : 'CROSSJOIN' ;
DESCENDANTS : 'DESCENDANTS' ;
DISTINCT : 'DISTINCT' ;
DRILLDOWNLEVEL : 'DRILLDOWNLEVEL' ;
DRILLDOWNLEVELBOTTOM : 'DRILLDOWNLEVELBOTTOM' ;
DRILLDOWNLEVELTOP : 'DRILLDOWNLEVELTOP' ;
DRILLDOWNMEMBER : 'DRILLDOWNMEMBER' ;
RECURSIVE : 'RECURSIVE' ;
DRILLDOWNMEMBERBOTTOM : 'DRILLDOWNMEMBERBOTTOM' ;
DRILLDOWNMEMBERTOP : 'DRILLDOWNMEMBERTOP' ;
DRILLUPLEVEL : 'DRILLUPLEVEL' ;
DRILLUPMEMBER : 'DRILLUPMEMBER' ;
EXCEPT : 'EXCEPT' ;
ALL : 'ALL' ;
EXTRACT : 'EXTRACT' ;
FILTER : 'FILTER' ;
GENERATE : 'GENERATE' ;
HIERARCHIZE : 'HIERARCHIZE' ;
INTERSECT : 'INTERSECT' ;
LASTPERIODS : 'LASTPERIODS' ;
MTD : 'MTD' ;
ORDER : 'ORDER' ;
ASC : 'ASC' ;
DESC : 'DESC' ;
BASC : 'BASC' ;
BDESC : 'BDESC' ;
PERIODSTODATE : 'PERIODSTODATE' ;
QTD : 'QTD' ;
TOGGLEDRILLSTATE : 'TOGGLEDRILLSTATE' ;
TOPCOUNT : 'TOPCOUNT' ;
TOPPERCENT : 'TOPPERCENT' ;
TOPSUM : 'TOPSUM' ;
UNION : 'UNION' ;
WTD : 'WTD' ;
YTD : 'YTD' ;
SELF : 'SELF' ;
AFTER : 'AFTER' ;
BEFORE : 'BEFORE' ;
BEFORE_AND_AFTER : 'BEFORE_AND_AFTER' ;
SELF_AND_AFTER : 'SELF_AND_AFTER' ;
SELF_AND_BEFORE : 'SELF_AND_BEFORE' ;
SELF_BEFORE_AFTER : 'SELF_BEFORE_AFTER' ;
PARENT : 'PARENT' ;
FIRSTCHILD : 'FIRSTCHILD' ;
LASTCHILD : 'LASTCHILD' ;
PREVMEMBER : 'PREVMEMBER' ;
NEXTMEMBER : 'NEXTMEMBER' ;
LEAD : 'LEAD' ;
LAG : 'LAG' ;
FIRSTSIBLING : 'FIRSTSIBLING' ;
LASTSIBLING : 'LASTSIBLING' ;
CURRENTMEMBER : 'CURRENTMEMBER' ;
DEFAULTMEMBER : 'DEFAULTMEMBER' ;
ANCESTOR : 'ANCESTOR' ;
CLOSINGPERIOD : 'CLOSINGPERIOD' ;
COUSIN : 'COUSIN' ;
OPENINGPERIOD : 'OPENINGPERIOD' ;
PARALLELPERIOD : 'PARALLELPERIOD' ;
ITEM : 'ITEM' ;
AGGREGATE : 'AGGREGATE' ;
AVG : 'AVG' ;
CORRELATION : 'CORRELATION' ;
COVARIANCE : 'COVARIANCE' ;
COUNT : 'COUNT' ;
INCLUDEEMPTY : 'INCLUDEEMPTY' ;
LINREGINTERCEPT : 'LINREGINTERCEPT' ;
LINREGPOINT : 'LINREGPOINT' ;
LINREGR2 : 'LINREGR2' ;
LINREGSLOPE : 'LINREGSLOPE' ;
LINREGVARIANCE : 'LINREGVARIANCE' ;
MAX : 'MAX' ;
MEDIAN : 'MEDIAN' ;
MIN : 'MIN' ;
RANK : 'RANK' ;
STDEV : 'STDEV' ;
SUM : 'SUM' ;
VAR : 'VAR' ;
OR : 'OR' ;
XOR : 'XOR' ;
AND : 'AND' ;
NOT : 'NOT' ; 
ISEMPTY : 'ISEMPTY' ;
EQ : '=';
GT : '>' ;
LT : '<' ;
GE : '>=' ;
LE : '<=' ;
WITH : 'WITH' ;
SELECT : 'SELECT' ;
FROM : 'FROM' ;
WHERE : 'WHERE' ;
AS : 'AS' ;
SOLVE_ORDER : 'SOLVE_ORDER' ;
SET : 'SET' ;
EMPTY : 'EMPTY';
NON 	:	 'NON';
ON : 'ON' ;
//COLUMNS : 'COLUMNS' ;
//ROWS : 'ROWS' ;
PAGES : 'PAGES' ;
CHAPTERS : 'CHAPTERS' ;
SECTIONS : 'SECTIONS' ;
AXIS : 'AXIS' ;
PROPERTIES : 'PROPERTIES' ;
CELL : 'CELL' ;
CELL_ORDINAL : 'CELL_ORDINAL' ;
VALUE : 'VALUE' ;
FORMATTED_VALUE : 'FORMATTED_VALUE' ;
FORMAT_STRING : 'FORMAT_STRING' ;
FORE_COLOR : 'FORE_COLOR' ;
BACK_COLOR : 'BACK_COLOR' ;
FONT_NAME : 'FONT_NAME' ;
FONT_SIZE : 'FONT_SIZE' ;
FONT_FLAGS : 'FONT_FLAGS' ;
CREATE : 'CREATE' ;
DROP : 'DROP' ;
GLOBAL : 'GLOBAL' ;
SESSION : 'SESSION' ;
MEMBER : 'MEMBER';

SEMICOLON 	: ';';
COLON 	: ':';
COMMA 		: ',';
CONCAT 		: '||';
LBRACE 		: '{';
LPAREN 		: '(';
NE 		: '<>';
RBRACE 		: '}';
RPAREN 		: ')';
QUOTE 		: '\'';


NUMBER  	: ('0'..'9')+
		;
ID		
		:  ('a'..'z'|'A'..'Z'|'_'|'$') ('a'..'z'|'A'..'Z'|'_'|'0'..'9'|'$')*
		;
AMP_QUOTED_ID: '[&' (ID ((' ' | '\t')+ ID)* | NUMBER) ']'
		;
QUOTED_ID: ('[' (ID ((' ' | '\t')+ ID)* | NUMBER) ']')
		;
STRING  : '"' (~'"')* '"'
		| '\'' (~'\'')* '\''
		;
		
WS	:	(	' '
		|	'\t'
		|	'\f'
		|	'\r'    // Macintosh
		|	'\n'    // Unix
		)+
		{$channel=HIDDEN;}
	;
		



//REGULAR_IDENTIFIER : ('a'..'z' | 'A'..'Z') ('a'..'z' | 'A'..'Z' | '0'..'9' | '_')* ;
//DELIMITED_IDENTIFIER : '[' (~']'|']]')+ ']' ;

COMMENT
    :   '//' ~('\n'|'\r')* '\r'? '\n' {$channel=HIDDEN;}
    |   '--' ~('\n'|'\r')* '\r'? '\n' {$channel=HIDDEN;}
    |   '/*' ( options {greedy=false;} : . )* '*/' {$channel=HIDDEN;}
    ;



