f3dasm_optimize
---------------
*Optimization extension package for the framework for data-driven design \& analysis of structures and materials*

***

[![Python](https://img.shields.io/pypi/pyversions/f3dasm_optimize)](https://www.python.org)
[![pypi](https://img.shields.io/pypi/v/f3dasm_optimize.svg)](https://pypi.org/project/f3dasm_optimize/)
[![GitHub license](https://img.shields.io/badge/license-BSD-blue)](https://github.com/bessagroup/f3dasm_optimize)

[**Docs**](https://bessagroup.github.io/f3dasm/)
| [**Installation**](https://bessagroup.github.io/f3dasm/general/gettingstarted.html)
| [**GitHub**](https://github.com/bessagroup/f3dasm)
| [**PyPI**](https://pypi.org/project/f3dasm/)
| [**Practical sessions**](https://github.com/mpvanderschelling/f3dasm_teach)

## Summary

Welcome to `f3dasm_optimize`, an optimization extension Python package for data-driven design and analysis of structures and materials.


## Authorship

* Current created and developer: [M.P. van der Schelling](https://github.com/mpvanderschelling/) (M.P.vanderSchelling@tudelft.nl)

The Bessa research group at TU Delft is small... At the moment, we have limited availability to help future users/developers adapting the code to new problems, but we will do our best to help!

## Getting started

The best way to get started is to follow the [installation instructions](https://f3dasm.readthedocs.io/en/latest/rst_doc_files/general/gettingstarted.html) of the `f3dasm` package.

## Referencing

If you use or edit our work, please cite at least one of the appropriate references:

[1] Bessa, M. A., Bostanabad, R., Liu, Z., Hu, A., Apley, D. W., Brinson, C., Chen, W., & Liu, W. K. (2017). A framework for data-driven analysis of materials under uncertainty: Countering the curse of dimensionality. Computer Methods in Applied Mechanics and Engineering, 320, 633-667.

[2] Bessa, M. A., & Pellegrino, S. (2018). Design of ultra-thin shell structures in the stochastic post-buckling range using Bayesian machine learning and optimization. International Journal of Solids and Structures, 139, 174-188.

[3] Bessa, M. A., Glowacki, P., & Houlder, M. (2019). Bayesian machine learning in metamaterial design: fragile becomes super-compressible. Advanced Materials, 31(48), 1904845.

[4] Mojtaba, M., Bostanabad, R., Chen, W., Ehmann, K., Cao, J., & Bessa, M. A. (2019). Deep learning predicts path-dependent plasticity. Proceedings of the National Academy of Sciences, 116(52), 26414-26420.

## Community Support

If you find any **issues, bugs or problems** with this template, please use the [GitHub issue tracker](https://github.com/bessagroup/f3dasm_optimize/issues) to report them.

## License

Copyright 2023, Martin van der Schelling

All rights reserved.

This project is licensed under the BSD 3-Clause License. See [LICENSE](https://github.com/bessagroup/f3dasm_optimize/blob/main/LICENSE) for the full license text.