import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Provides an [EC2 key pair](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html) resource. A key pair is used to control login access to EC2 instances.
 *
 * Currently this resource requires an existing user-supplied key pair. This key pair's public key will be registered with AWS to allow logging-in to EC2 instances.
 *
 * When importing an existing key pair the public key material may be in any format supported by AWS. Supported formats (per the [AWS documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html#how-to-generate-your-own-key-and-import-it-to-aws)) are:
 *
 * * OpenSSH public key format (the format in ~/.ssh/authorized_keys)
 * * Base64 encoded DER format
 * * SSH public key file format as specified in RFC4716
 *
 * @schema CfnKeyPairProps
 */
export interface CfnKeyPairProps {
    /**
     * The name for the key pair.
     *
     * @schema CfnKeyPairProps#KeyName
     */
    readonly keyName?: string;
    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `key_name`.
     *
     * @schema CfnKeyPairProps#KeyNamePrefix
     */
    readonly keyNamePrefix?: string;
    /**
     * The public key material.
     *
     * @schema CfnKeyPairProps#PublicKey
     */
    readonly publicKey: string;
    /**
     * Key-value map of resource tags. If configured with a provider [`default_tags` configuration block](https://www.terraform.io/docs/providers/aws/index.html#default_tags-configuration-block) present, tags with matching keys will overwrite those defined at the provider-level.
     *
     * @schema CfnKeyPairProps#Tags
     */
    readonly tags?: TagsDefinition[];
    /**
     * @schema CfnKeyPairProps#TagsAll
     */
    readonly tagsAll?: TagsAllDefinition[];
}
/**
 * Converts an object of type 'CfnKeyPairProps' to JSON representation.
 */
export declare function toJson_CfnKeyPairProps(obj: CfnKeyPairProps | undefined): Record<string, any> | undefined;
/**
 * @schema TagsDefinition
 */
export interface TagsDefinition {
    /**
     * @schema TagsDefinition#MapKey
     */
    readonly mapKey: string;
    /**
     * @schema TagsDefinition#MapValue
     */
    readonly mapValue: string;
}
/**
 * Converts an object of type 'TagsDefinition' to JSON representation.
 */
export declare function toJson_TagsDefinition(obj: TagsDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema TagsAllDefinition
 */
export interface TagsAllDefinition {
    /**
     * @schema TagsAllDefinition#MapKey
     */
    readonly mapKey: string;
    /**
     * @schema TagsAllDefinition#MapValue
     */
    readonly mapValue: string;
}
/**
 * Converts an object of type 'TagsAllDefinition' to JSON representation.
 */
export declare function toJson_TagsAllDefinition(obj: TagsAllDefinition | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `TF::AWS::KeyPair`
 *
 * @cloudformationResource TF::AWS::KeyPair
 * @stability external
 * @link https://github.com/iann0036/cfn-tf-custom-types.git
 */
export declare class CfnKeyPair extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "TF::AWS::KeyPair";
    /**
     * Resource props.
     */
    readonly props: CfnKeyPairProps;
    /**
     * Attribute `TF::AWS::KeyPair.tfcfnid`
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrTfcfnid: string;
    /**
     * Attribute `TF::AWS::KeyPair.Arn`
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrArn: string;
    /**
     * Attribute `TF::AWS::KeyPair.Fingerprint`
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrFingerprint: string;
    /**
     * Attribute `TF::AWS::KeyPair.Id`
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrId: string;
    /**
     * Attribute `TF::AWS::KeyPair.KeyPairId`
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrKeyPairId: string;
    /**
     * Create a new `TF::AWS::KeyPair`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnKeyPairProps);
}
