# coding: utf-8

"""
    Mail-in-a-Box

    Mail-in-a-Box API HTTP specification.  # Introduction This API is documented in [**OpenAPI format**](http://spec.openapis.org/oas/v3.0.3). ([View the full HTTP specification](https://raw.githubusercontent.com/mail-in-a-box/mailinabox/api-spec/api/mailinabox.yml).)  All endpoints are relative to `https://{host}/admin` and are secured with [`Basic Access` authentication](https://en.wikipedia.org/wiki/Basic_access_authentication). If you have multi-factor authentication enabled, authentication with a `user:password` combination will fail unless a valid OTP is supplied via the `x-auth-token` header. Authentication via a `user:user_key` pair is possible without the header being present.   # noqa: E501

    The version of the OpenAPI document: 0.51.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from mailinabox_api.configuration import Configuration


class WebDomain(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "custom_root": "str",
        "domain": "str",
        "root": "str",
        "ssl_certificate": "list[OneOfstringstring]",
        "static_enabled": "bool",
    }

    attribute_map = {
        "custom_root": "custom_root",
        "domain": "domain",
        "root": "root",
        "ssl_certificate": "ssl_certificate",
        "static_enabled": "static_enabled",
    }

    def __init__(
        self,
        custom_root=None,
        domain=None,
        root=None,
        ssl_certificate=None,
        static_enabled=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """WebDomain - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._custom_root = None
        self._domain = None
        self._root = None
        self._ssl_certificate = None
        self._static_enabled = None
        self.discriminator = None

        self.custom_root = custom_root
        self.domain = domain
        self.root = root
        self.ssl_certificate = ssl_certificate
        self.static_enabled = static_enabled

    @property
    def custom_root(self):
        """Gets the custom_root of this WebDomain.  # noqa: E501


        :return: The custom_root of this WebDomain.  # noqa: E501
        :rtype: str
        """
        return self._custom_root

    @custom_root.setter
    def custom_root(self, custom_root):
        """Sets the custom_root of this WebDomain.


        :param custom_root: The custom_root of this WebDomain.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and custom_root is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `custom_root`, must not be `None`"
            )  # noqa: E501

        self._custom_root = custom_root

    @property
    def domain(self):
        """Gets the domain of this WebDomain.  # noqa: E501

        Hostname format.  # noqa: E501

        :return: The domain of this WebDomain.  # noqa: E501
        :rtype: str
        """
        return self._domain

    @domain.setter
    def domain(self, domain):
        """Sets the domain of this WebDomain.

        Hostname format.  # noqa: E501

        :param domain: The domain of this WebDomain.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and domain is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `domain`, must not be `None`"
            )  # noqa: E501

        self._domain = domain

    @property
    def root(self):
        """Gets the root of this WebDomain.  # noqa: E501


        :return: The root of this WebDomain.  # noqa: E501
        :rtype: str
        """
        return self._root

    @root.setter
    def root(self, root):
        """Sets the root of this WebDomain.


        :param root: The root of this WebDomain.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and root is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `root`, must not be `None`"
            )  # noqa: E501

        self._root = root

    @property
    def ssl_certificate(self):
        """Gets the ssl_certificate of this WebDomain.  # noqa: E501


        :return: The ssl_certificate of this WebDomain.  # noqa: E501
        :rtype: list[OneOfstringstring]
        """
        return self._ssl_certificate

    @ssl_certificate.setter
    def ssl_certificate(self, ssl_certificate):
        """Sets the ssl_certificate of this WebDomain.


        :param ssl_certificate: The ssl_certificate of this WebDomain.  # noqa: E501
        :type: list[OneOfstringstring]
        """
        if (
            self.local_vars_configuration.client_side_validation
            and ssl_certificate is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `ssl_certificate`, must not be `None`"
            )  # noqa: E501

        self._ssl_certificate = ssl_certificate

    @property
    def static_enabled(self):
        """Gets the static_enabled of this WebDomain.  # noqa: E501


        :return: The static_enabled of this WebDomain.  # noqa: E501
        :rtype: bool
        """
        return self._static_enabled

    @static_enabled.setter
    def static_enabled(self, static_enabled):
        """Sets the static_enabled of this WebDomain.


        :param static_enabled: The static_enabled of this WebDomain.  # noqa: E501
        :type: bool
        """
        if (
            self.local_vars_configuration.client_side_validation
            and static_enabled is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `static_enabled`, must not be `None`"
            )  # noqa: E501

        self._static_enabled = static_enabled

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WebDomain):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, WebDomain):
            return True

        return self.to_dict() != other.to_dict()
