# coding: utf-8

"""
    Mail-in-a-Box

    Mail-in-a-Box API HTTP specification.  # Introduction This API is documented in [**OpenAPI format**](http://spec.openapis.org/oas/v3.0.3). ([View the full HTTP specification](https://raw.githubusercontent.com/mail-in-a-box/mailinabox/api-spec/api/mailinabox.yml).)  All endpoints are relative to `https://{host}/admin` and are secured with [`Basic Access` authentication](https://en.wikipedia.org/wiki/Basic_access_authentication). If you have multi-factor authentication enabled, authentication with a `user:password` combination will fail unless a valid OTP is supplied via the `x-auth-token` header. Authentication via a `user:user_key` pair is possible without the header being present.   # noqa: E501

    The version of the OpenAPI document: 0.51.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from mailinabox_api.configuration import Configuration


class DNSDumpDomainRecord(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "explanation": "str",
        "qname": "str",
        "rtype": "DNSRecordType",
        "value": "str",
    }

    attribute_map = {
        "explanation": "explanation",
        "qname": "qname",
        "rtype": "rtype",
        "value": "value",
    }

    def __init__(
        self,
        explanation=None,
        qname=None,
        rtype=None,
        value=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """DNSDumpDomainRecord - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._explanation = None
        self._qname = None
        self._rtype = None
        self._value = None
        self.discriminator = None

        self.explanation = explanation
        self.qname = qname
        if rtype is not None:
            self.rtype = rtype
        self.value = value

    @property
    def explanation(self):
        """Gets the explanation of this DNSDumpDomainRecord.  # noqa: E501


        :return: The explanation of this DNSDumpDomainRecord.  # noqa: E501
        :rtype: str
        """
        return self._explanation

    @explanation.setter
    def explanation(self, explanation):
        """Sets the explanation of this DNSDumpDomainRecord.


        :param explanation: The explanation of this DNSDumpDomainRecord.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and explanation is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `explanation`, must not be `None`"
            )  # noqa: E501

        self._explanation = explanation

    @property
    def qname(self):
        """Gets the qname of this DNSDumpDomainRecord.  # noqa: E501

        Hostname format.  # noqa: E501

        :return: The qname of this DNSDumpDomainRecord.  # noqa: E501
        :rtype: str
        """
        return self._qname

    @qname.setter
    def qname(self, qname):
        """Sets the qname of this DNSDumpDomainRecord.

        Hostname format.  # noqa: E501

        :param qname: The qname of this DNSDumpDomainRecord.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and qname is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `qname`, must not be `None`"
            )  # noqa: E501

        self._qname = qname

    @property
    def rtype(self):
        """Gets the rtype of this DNSDumpDomainRecord.  # noqa: E501


        :return: The rtype of this DNSDumpDomainRecord.  # noqa: E501
        :rtype: DNSRecordType
        """
        return self._rtype

    @rtype.setter
    def rtype(self, rtype):
        """Sets the rtype of this DNSDumpDomainRecord.


        :param rtype: The rtype of this DNSDumpDomainRecord.  # noqa: E501
        :type: DNSRecordType
        """

        self._rtype = rtype

    @property
    def value(self):
        """Gets the value of this DNSDumpDomainRecord.  # noqa: E501


        :return: The value of this DNSDumpDomainRecord.  # noqa: E501
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this DNSDumpDomainRecord.


        :param value: The value of this DNSDumpDomainRecord.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and value is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `value`, must not be `None`"
            )  # noqa: E501

        self._value = value

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DNSDumpDomainRecord):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DNSDumpDomainRecord):
            return True

        return self.to_dict() != other.to_dict()
