import sqlalchemy as sa

from alembic import op
from sqlalchemy.dialects import postgresql


revision = "cce98484f923"
down_revision = "b3fbbe647373"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "auth_user",
        sa.Column("id", postgresql.UUID(as_uuid=True), nullable=False),
        sa.Column("username", sa.String(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("username"),
    )
    op.create_index(
        "auth_user_username_idx", "auth_user", ["username"], unique=False
    )
    op.add_column(
        "auth_session",
        sa.Column("auth_user", postgresql.UUID(as_uuid=True), nullable=True),
    )
    op.alter_column(
        "auth_session", "user", existing_type=sa.VARCHAR(), nullable=True
    )
    op.create_index(
        "auth_session_expiration_time_idx",
        "auth_session",
        ["expiration_time"],
        unique=False,
    )
    op.drop_index("auth_session_expiration_time", table_name="auth_session")
    op.drop_index("auth_session_user_creation_time", table_name="auth_session")
    op.create_foreign_key(
        None, "auth_session", "auth_user", ["auth_user"], ["id"]
    )
    # ### end Alembic commands ###
