import sqlalchemy as sa

from alembic import op
from sqlalchemy.dialects import postgresql


revision = "b3fbbe647373"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "auth_session",
        sa.Column("session", sa.String(), nullable=False),
        sa.Column("user", sa.String(), nullable=False),
        sa.Column("creation_time", postgresql.TIMESTAMP(), nullable=False),
        sa.Column("expiration_time", postgresql.TIMESTAMP(), nullable=False),
        sa.PrimaryKeyConstraint("session"),
    )
    op.create_index(
        "auth_session_expiration_time",
        "auth_session",
        ["expiration_time"],
        unique=False,
    )
    op.create_index(
        "auth_session_user_creation_time",
        "auth_session",
        ["user", "creation_time"],
        unique=False,
    )
    op.create_table(
        "local_id_map",
        sa.Column("scope", sa.String(), nullable=False),
        sa.Column("value", sa.String(), nullable=False),
        sa.Column("id", postgresql.UUID(as_uuid=True), nullable=False),
        sa.Column("timestamp", postgresql.TIMESTAMP(), nullable=False),
        sa.PrimaryKeyConstraint("scope", "value"),
    )
    op.create_table(
        "project",
        sa.Column("id", postgresql.UUID(as_uuid=True), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("version", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("name"),
    )
    op.create_index("project_name_idx", "project", ["name"], unique=False)
    op.create_table(
        "stats",
        sa.Column("flag", postgresql.UUID(as_uuid=True), nullable=False),
        sa.Column("interval", postgresql.TIMESTAMP(), nullable=False),
        sa.Column("positive_count", sa.Integer(), nullable=True),
        sa.Column("negative_count", sa.Integer(), nullable=True),
        sa.PrimaryKeyConstraint("flag", "interval"),
    )
    op.create_table(
        "flag",
        sa.Column("id", postgresql.UUID(as_uuid=True), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("enabled", sa.Boolean(), nullable=True),
        sa.Column("project", postgresql.UUID(as_uuid=True), nullable=False),
        sa.ForeignKeyConstraint(
            ["project"],
            ["project.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("project", "name"),
    )
    op.create_index(
        "flag_project_name_idx", "flag", ["project", "name"], unique=False
    )
    op.create_table(
        "variable",
        sa.Column("id", postgresql.UUID(as_uuid=True), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column(
            "type",
            sa.Enum("STRING", "NUMBER", "TIMESTAMP", "SET", name="type"),
            nullable=False,
        ),
        sa.Column("project", postgresql.UUID(as_uuid=True), nullable=False),
        sa.ForeignKeyConstraint(
            ["project"],
            ["project.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("project", "name"),
    )
    op.create_index(
        "variable_project_name_idx",
        "variable",
        ["project", "name"],
        unique=False,
    )
    op.create_table(
        "check",
        sa.Column("id", postgresql.UUID(as_uuid=True), nullable=False),
        sa.Column(
            "operator",
            sa.Enum(
                "EQUAL",
                "LESS_THAN",
                "LESS_OR_EQUAL",
                "GREATER_THAN",
                "GREATER_OR_EQUAL",
                "CONTAINS",
                "PERCENT",
                "REGEXP",
                "WILDCARD",
                "SUBSET",
                "SUPERSET",
                name="operator",
            ),
            nullable=False,
        ),
        sa.Column("value_string", sa.String(), nullable=True),
        sa.Column("value_number", postgresql.DOUBLE_PRECISION(), nullable=True),
        sa.Column("value_timestamp", postgresql.TIMESTAMP(), nullable=True),
        sa.Column("value_set", postgresql.ARRAY(sa.String()), nullable=True),
        sa.Column("variable", postgresql.UUID(as_uuid=True), nullable=False),
        sa.ForeignKeyConstraint(
            ["variable"],
            ["variable.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "condition",
        sa.Column("id", postgresql.UUID(as_uuid=True), nullable=False),
        sa.Column("flag", postgresql.UUID(as_uuid=True), nullable=False),
        sa.Column(
            "checks",
            postgresql.ARRAY(postgresql.UUID(as_uuid=True), as_tuple=True),
            nullable=True,
        ),
        sa.ForeignKeyConstraint(
            ["flag"],
            ["flag.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    # ### end Alembic commands ###
