import sqlalchemy as sa

from alembic import op
from sqlalchemy.dialects import postgresql


revision = "33ace31b89cc"
down_revision = "94e4203113b0"
branch_labels = None
depends_on = None


def upgrade():
    op.execute('ALTER TYPE "type" RENAME TO "variable_type";')
    op.execute('ALTER TYPE "operator" RENAME TO "check_operator";')

    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "changelog",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("timestamp", postgresql.TIMESTAMP(), nullable=False),
        sa.Column("auth_user", postgresql.UUID(as_uuid=True), nullable=False),
        sa.Column("flag", postgresql.UUID(as_uuid=True), nullable=False),
        sa.Column(
            "actions",
            postgresql.ARRAY(
                sa.Enum(
                    "ENABLE_FLAG",
                    "DISABLE_FLAG",
                    "ADD_CONDITION",
                    "DISABLE_CONDITION",
                    "RESET_FLAG",
                    name="changelog_actions",
                )
            ),
            nullable=True,
        ),
        sa.ForeignKeyConstraint(
            ["auth_user"],
            ["auth_user.id"],
        ),
        sa.ForeignKeyConstraint(
            ["flag"],
            ["flag.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    # ### end Alembic commands ###
