# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class WorkflowDefinitionImpl(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'created_by': 'str',
        'created_on': 'int',
        'last_modified_by': 'str',
        'last_modified_on': 'int',
        'system': 'bool',
        'resource_type': 'str',
        'name': 'str',
        'description': 'str',
        'process_id': 'str',
        'start_label': 'str',
        'form_required': 'bool',
        'start_form_key_available': 'bool',
        'start_form_json_model_available': 'bool',
        'enabled': 'bool',
        'domain_assignment_rules': 'list[AssetAssignmentRuleImpl]',
        'asset_assignment_rules': 'list[AssetAssignmentRuleImpl]',
        'business_item_resource_type': 'str',
        'exclusivity': 'str',
        'guest_user_accessible': 'bool',
        'registered_user_accessible': 'bool',
        'candidate_user_check_enabled': 'bool',
        'global_create': 'bool',
        'start_events': 'list[str]',
        'configuration_variables': 'dict(str, str)',
        'start_roles': 'list[RoleImpl]',
        'stop_roles': 'list[RoleImpl]',
        'reassign_roles': 'list[RoleImpl]'
    }

    attribute_map = {
        'id': 'id',
        'created_by': 'createdBy',
        'created_on': 'createdOn',
        'last_modified_by': 'lastModifiedBy',
        'last_modified_on': 'lastModifiedOn',
        'system': 'system',
        'resource_type': 'resourceType',
        'name': 'name',
        'description': 'description',
        'process_id': 'processId',
        'start_label': 'startLabel',
        'form_required': 'formRequired',
        'start_form_key_available': 'startFormKeyAvailable',
        'start_form_json_model_available': 'startFormJsonModelAvailable',
        'enabled': 'enabled',
        'domain_assignment_rules': 'domainAssignmentRules',
        'asset_assignment_rules': 'assetAssignmentRules',
        'business_item_resource_type': 'businessItemResourceType',
        'exclusivity': 'exclusivity',
        'guest_user_accessible': 'guestUserAccessible',
        'registered_user_accessible': 'registeredUserAccessible',
        'candidate_user_check_enabled': 'candidateUserCheckEnabled',
        'global_create': 'globalCreate',
        'start_events': 'startEvents',
        'configuration_variables': 'configurationVariables',
        'start_roles': 'startRoles',
        'stop_roles': 'stopRoles',
        'reassign_roles': 'reassignRoles'
    }

    def __init__(self, id=None, created_by=None, created_on=None, last_modified_by=None, last_modified_on=None, system=None, resource_type=None, name=None, description=None, process_id=None, start_label=None, form_required=None, start_form_key_available=None, start_form_json_model_available=None, enabled=None, domain_assignment_rules=None, asset_assignment_rules=None, business_item_resource_type=None, exclusivity=None, guest_user_accessible=None, registered_user_accessible=None, candidate_user_check_enabled=None, global_create=None, start_events=None, configuration_variables=None, start_roles=None, stop_roles=None, reassign_roles=None, local_vars_configuration=None):  # noqa: E501
        """WorkflowDefinitionImpl - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._created_by = None
        self._created_on = None
        self._last_modified_by = None
        self._last_modified_on = None
        self._system = None
        self._resource_type = None
        self._name = None
        self._description = None
        self._process_id = None
        self._start_label = None
        self._form_required = None
        self._start_form_key_available = None
        self._start_form_json_model_available = None
        self._enabled = None
        self._domain_assignment_rules = None
        self._asset_assignment_rules = None
        self._business_item_resource_type = None
        self._exclusivity = None
        self._guest_user_accessible = None
        self._registered_user_accessible = None
        self._candidate_user_check_enabled = None
        self._global_create = None
        self._start_events = None
        self._configuration_variables = None
        self._start_roles = None
        self._stop_roles = None
        self._reassign_roles = None
        self.discriminator = None

        self.id = id
        if created_by is not None:
            self.created_by = created_by
        if created_on is not None:
            self.created_on = created_on
        if last_modified_by is not None:
            self.last_modified_by = last_modified_by
        if last_modified_on is not None:
            self.last_modified_on = last_modified_on
        if system is not None:
            self.system = system
        self.resource_type = resource_type
        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if process_id is not None:
            self.process_id = process_id
        if start_label is not None:
            self.start_label = start_label
        if form_required is not None:
            self.form_required = form_required
        if start_form_key_available is not None:
            self.start_form_key_available = start_form_key_available
        if start_form_json_model_available is not None:
            self.start_form_json_model_available = start_form_json_model_available
        if enabled is not None:
            self.enabled = enabled
        if domain_assignment_rules is not None:
            self.domain_assignment_rules = domain_assignment_rules
        if asset_assignment_rules is not None:
            self.asset_assignment_rules = asset_assignment_rules
        if business_item_resource_type is not None:
            self.business_item_resource_type = business_item_resource_type
        if exclusivity is not None:
            self.exclusivity = exclusivity
        if guest_user_accessible is not None:
            self.guest_user_accessible = guest_user_accessible
        if registered_user_accessible is not None:
            self.registered_user_accessible = registered_user_accessible
        if candidate_user_check_enabled is not None:
            self.candidate_user_check_enabled = candidate_user_check_enabled
        if global_create is not None:
            self.global_create = global_create
        if start_events is not None:
            self.start_events = start_events
        if configuration_variables is not None:
            self.configuration_variables = configuration_variables
        if start_roles is not None:
            self.start_roles = start_roles
        if stop_roles is not None:
            self.stop_roles = stop_roles
        if reassign_roles is not None:
            self.reassign_roles = reassign_roles

    @property
    def id(self):
        """Gets the id of this WorkflowDefinitionImpl.  # noqa: E501

        The id of the represented object (entity).  # noqa: E501

        :return: The id of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this WorkflowDefinitionImpl.

        The id of the represented object (entity).  # noqa: E501

        :param id: The id of this WorkflowDefinitionImpl.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def created_by(self):
        """Gets the created_by of this WorkflowDefinitionImpl.  # noqa: E501

        The id of the user that created this resource.  # noqa: E501

        :return: The created_by of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this WorkflowDefinitionImpl.

        The id of the user that created this resource.  # noqa: E501

        :param created_by: The created_by of this WorkflowDefinitionImpl.  # noqa: E501
        :type: str
        """

        self._created_by = created_by

    @property
    def created_on(self):
        """Gets the created_on of this WorkflowDefinitionImpl.  # noqa: E501

        The timestamp (in UTC time standard) of the creation of this resource.  # noqa: E501

        :return: The created_on of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: int
        """
        return self._created_on

    @created_on.setter
    def created_on(self, created_on):
        """Sets the created_on of this WorkflowDefinitionImpl.

        The timestamp (in UTC time standard) of the creation of this resource.  # noqa: E501

        :param created_on: The created_on of this WorkflowDefinitionImpl.  # noqa: E501
        :type: int
        """

        self._created_on = created_on

    @property
    def last_modified_by(self):
        """Gets the last_modified_by of this WorkflowDefinitionImpl.  # noqa: E501

        The id of the user who modified this resource the last time.  # noqa: E501

        :return: The last_modified_by of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: str
        """
        return self._last_modified_by

    @last_modified_by.setter
    def last_modified_by(self, last_modified_by):
        """Sets the last_modified_by of this WorkflowDefinitionImpl.

        The id of the user who modified this resource the last time.  # noqa: E501

        :param last_modified_by: The last_modified_by of this WorkflowDefinitionImpl.  # noqa: E501
        :type: str
        """

        self._last_modified_by = last_modified_by

    @property
    def last_modified_on(self):
        """Gets the last_modified_on of this WorkflowDefinitionImpl.  # noqa: E501

        The timestamp (in UTC time standard) of the last modification of this resource.  # noqa: E501

        :return: The last_modified_on of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: int
        """
        return self._last_modified_on

    @last_modified_on.setter
    def last_modified_on(self, last_modified_on):
        """Sets the last_modified_on of this WorkflowDefinitionImpl.

        The timestamp (in UTC time standard) of the last modification of this resource.  # noqa: E501

        :param last_modified_on: The last_modified_on of this WorkflowDefinitionImpl.  # noqa: E501
        :type: int
        """

        self._last_modified_on = last_modified_on

    @property
    def system(self):
        """Gets the system of this WorkflowDefinitionImpl.  # noqa: E501

        Whether this is a system resource or not.  # noqa: E501

        :return: The system of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: bool
        """
        return self._system

    @system.setter
    def system(self, system):
        """Sets the system of this WorkflowDefinitionImpl.

        Whether this is a system resource or not.  # noqa: E501

        :param system: The system of this WorkflowDefinitionImpl.  # noqa: E501
        :type: bool
        """

        self._system = system

    @property
    def resource_type(self):
        """Gets the resource_type of this WorkflowDefinitionImpl.  # noqa: E501

        The type of this resource, i.e. [Community, Asset, Domain, Attribute, Relation, WorkflowInstance].  # noqa: E501

        :return: The resource_type of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this WorkflowDefinitionImpl.

        The type of this resource, i.e. [Community, Asset, Domain, Attribute, Relation, WorkflowInstance].  # noqa: E501

        :param resource_type: The resource_type of this WorkflowDefinitionImpl.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and resource_type is None:  # noqa: E501
            raise ValueError("Invalid value for `resource_type`, must not be `None`")  # noqa: E501
        allowed_values = ["View", "Asset", "Community", "Domain", "AssetType", "DomainType", "Status", "User", "ClassificationMatch", "UserGroup", "Attribute", "StringAttribute", "ScriptAttribute", "BooleanAttribute", "DateAttribute", "NumericAttribute", "SingleValueListAttribute", "MultiValueListAttribute", "Comment", "Attachment", "Responsibility", "Workflow", "Job", "Relation", "RelationType", "ComplexRelation", "ComplexRelationType", "ArticulationRule", "Assignment", "Scope", "RelationTrace", "ValidationRule", "DataQualityRule", "DataQualityMetric", "Address", "InstantMessagingAccount", "Email", "PhoneNumber", "Website", "Activity", "FormProperty", "WorkflowTask", "ActivityChange", "WorkflowInstance", "Role", "AttributeType", "BooleanAttributeType", "DateAttributeType", "DateTimeAttributeType", "MultiValueListAttributeType", "NumericAttributeType", "ScriptAttributeType", "SingleValueListAttributeType", "StringAttributeType", "ViewSharingRule", "ViewAssignmentRule", "JdbcDriverFile", "JdbcDriver", "JdbcIngestionProperties", "CsvIngestionProperties", "ExcelIngestionProperties", "ConnectionStringParameter", "AssignedCharacteristicType", "Notification", "Tag", "ComplexRelationLegType", "ComplexRelationAttributeType", "ComplexRelationLeg", "BaseDataType", "AdvancedDataType", "DiagramPicture", "DiagramPictureSharingRule", "DiagramPictureAssignmentRule", "Rating", "Classification", "PhysicalDataConnector", "Context"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and resource_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `resource_type` ({0}), must be one of {1}"  # noqa: E501
                .format(resource_type, allowed_values)
            )

        self._resource_type = resource_type

    @property
    def name(self):
        """Gets the name of this WorkflowDefinitionImpl.  # noqa: E501

        The name of the resource.  # noqa: E501

        :return: The name of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this WorkflowDefinitionImpl.

        The name of the resource.  # noqa: E501

        :param name: The name of this WorkflowDefinitionImpl.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """Gets the description of this WorkflowDefinitionImpl.  # noqa: E501

        The description of the resource.  # noqa: E501

        :return: The description of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this WorkflowDefinitionImpl.

        The description of the resource.  # noqa: E501

        :param description: The description of this WorkflowDefinitionImpl.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def process_id(self):
        """Gets the process_id of this WorkflowDefinitionImpl.  # noqa: E501

        The <code>id</code> that uniquely identifies a workflow definition in the application.<p>It is present in the BPMN notation in the ID property of the '<process..' tag. Deploying a BPMN in DGC creates a new version if a process with the same ID already exists.  # noqa: E501

        :return: The process_id of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: str
        """
        return self._process_id

    @process_id.setter
    def process_id(self, process_id):
        """Sets the process_id of this WorkflowDefinitionImpl.

        The <code>id</code> that uniquely identifies a workflow definition in the application.<p>It is present in the BPMN notation in the ID property of the '<process..' tag. Deploying a BPMN in DGC creates a new version if a process with the same ID already exists.  # noqa: E501

        :param process_id: The process_id of this WorkflowDefinitionImpl.  # noqa: E501
        :type: str
        """

        self._process_id = process_id

    @property
    def start_label(self):
        """Gets the start_label of this WorkflowDefinitionImpl.  # noqa: E501

        The label used for starting this workflow.  # noqa: E501

        :return: The start_label of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: str
        """
        return self._start_label

    @start_label.setter
    def start_label(self, start_label):
        """Sets the start_label of this WorkflowDefinitionImpl.

        The label used for starting this workflow.  # noqa: E501

        :param start_label: The start_label of this WorkflowDefinitionImpl.  # noqa: E501
        :type: str
        """

        self._start_label = start_label

    @property
    def form_required(self):
        """Gets the form_required of this WorkflowDefinitionImpl.  # noqa: E501

        Whether the start event for this workflow requires user interaction through a form or not.  # noqa: E501

        :return: The form_required of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: bool
        """
        return self._form_required

    @form_required.setter
    def form_required(self, form_required):
        """Sets the form_required of this WorkflowDefinitionImpl.

        Whether the start event for this workflow requires user interaction through a form or not.  # noqa: E501

        :param form_required: The form_required of this WorkflowDefinitionImpl.  # noqa: E501
        :type: bool
        """

        self._form_required = form_required

    @property
    def start_form_key_available(self):
        """Gets the start_form_key_available of this WorkflowDefinitionImpl.  # noqa: E501

        @deprecated This field will be removed in the future. Please, use 'startFormJsonModelAvailable' to recognize if start form model is available.  # noqa: E501

        :return: The start_form_key_available of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: bool
        """
        return self._start_form_key_available

    @start_form_key_available.setter
    def start_form_key_available(self, start_form_key_available):
        """Sets the start_form_key_available of this WorkflowDefinitionImpl.

        @deprecated This field will be removed in the future. Please, use 'startFormJsonModelAvailable' to recognize if start form model is available.  # noqa: E501

        :param start_form_key_available: The start_form_key_available of this WorkflowDefinitionImpl.  # noqa: E501
        :type: bool
        """

        self._start_form_key_available = start_form_key_available

    @property
    def start_form_json_model_available(self):
        """Gets the start_form_json_model_available of this WorkflowDefinitionImpl.  # noqa: E501

        Whether the workflow has the start form json model available or not. If true, then the external form definition for this task is needed to render the task.  # noqa: E501

        :return: The start_form_json_model_available of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: bool
        """
        return self._start_form_json_model_available

    @start_form_json_model_available.setter
    def start_form_json_model_available(self, start_form_json_model_available):
        """Sets the start_form_json_model_available of this WorkflowDefinitionImpl.

        Whether the workflow has the start form json model available or not. If true, then the external form definition for this task is needed to render the task.  # noqa: E501

        :param start_form_json_model_available: The start_form_json_model_available of this WorkflowDefinitionImpl.  # noqa: E501
        :type: bool
        """

        self._start_form_json_model_available = start_form_json_model_available

    @property
    def enabled(self):
        """Gets the enabled of this WorkflowDefinitionImpl.  # noqa: E501

        Whether workflow is enabled or not.<p>A workflow has to be enabled for a user to be able to start a workflow. A workflow is enabled if it's status is put on the status 'enabled'  # noqa: E501

        :return: The enabled of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this WorkflowDefinitionImpl.

        Whether workflow is enabled or not.<p>A workflow has to be enabled for a user to be able to start a workflow. A workflow is enabled if it's status is put on the status 'enabled'  # noqa: E501

        :param enabled: The enabled of this WorkflowDefinitionImpl.  # noqa: E501
        :type: bool
        """

        self._enabled = enabled

    @property
    def domain_assignment_rules(self):
        """Gets the domain_assignment_rules of this WorkflowDefinitionImpl.  # noqa: E501

        The list of domain assignment rules.  # noqa: E501

        :return: The domain_assignment_rules of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: list[AssetAssignmentRuleImpl]
        """
        return self._domain_assignment_rules

    @domain_assignment_rules.setter
    def domain_assignment_rules(self, domain_assignment_rules):
        """Sets the domain_assignment_rules of this WorkflowDefinitionImpl.

        The list of domain assignment rules.  # noqa: E501

        :param domain_assignment_rules: The domain_assignment_rules of this WorkflowDefinitionImpl.  # noqa: E501
        :type: list[AssetAssignmentRuleImpl]
        """

        self._domain_assignment_rules = domain_assignment_rules

    @property
    def asset_assignment_rules(self):
        """Gets the asset_assignment_rules of this WorkflowDefinitionImpl.  # noqa: E501

        The list of asset assignment rules.  # noqa: E501

        :return: The asset_assignment_rules of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: list[AssetAssignmentRuleImpl]
        """
        return self._asset_assignment_rules

    @asset_assignment_rules.setter
    def asset_assignment_rules(self, asset_assignment_rules):
        """Sets the asset_assignment_rules of this WorkflowDefinitionImpl.

        The list of asset assignment rules.  # noqa: E501

        :param asset_assignment_rules: The asset_assignment_rules of this WorkflowDefinitionImpl.  # noqa: E501
        :type: list[AssetAssignmentRuleImpl]
        """

        self._asset_assignment_rules = asset_assignment_rules

    @property
    def business_item_resource_type(self):
        """Gets the business_item_resource_type of this WorkflowDefinitionImpl.  # noqa: E501

        The type of business item that the workflow can refer to. This could be either Community, Domain, Asset, or global.  # noqa: E501

        :return: The business_item_resource_type of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: str
        """
        return self._business_item_resource_type

    @business_item_resource_type.setter
    def business_item_resource_type(self, business_item_resource_type):
        """Sets the business_item_resource_type of this WorkflowDefinitionImpl.

        The type of business item that the workflow can refer to. This could be either Community, Domain, Asset, or global.  # noqa: E501

        :param business_item_resource_type: The business_item_resource_type of this WorkflowDefinitionImpl.  # noqa: E501
        :type: str
        """
        allowed_values = ["ASSET", "DOMAIN", "COMMUNITY", "GLOBAL"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and business_item_resource_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `business_item_resource_type` ({0}), must be one of {1}"  # noqa: E501
                .format(business_item_resource_type, allowed_values)
            )

        self._business_item_resource_type = business_item_resource_type

    @property
    def exclusivity(self):
        """Gets the exclusivity of this WorkflowDefinitionImpl.  # noqa: E501

        The exclusivity of this workflow. This determines how many times a workflow can be started for a specific resource.  # noqa: E501

        :return: The exclusivity of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: str
        """
        return self._exclusivity

    @exclusivity.setter
    def exclusivity(self, exclusivity):
        """Sets the exclusivity of this WorkflowDefinitionImpl.

        The exclusivity of this workflow. This determines how many times a workflow can be started for a specific resource.  # noqa: E501

        :param exclusivity: The exclusivity of this WorkflowDefinitionImpl.  # noqa: E501
        :type: str
        """
        allowed_values = ["RESOURCE_EXCLUSIVITY", "DEFINITION_EXCLUSIVITY", "UNCONSTRAINED"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and exclusivity not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `exclusivity` ({0}), must be one of {1}"  # noqa: E501
                .format(exclusivity, allowed_values)
            )

        self._exclusivity = exclusivity

    @property
    def guest_user_accessible(self):
        """Gets the guest_user_accessible of this WorkflowDefinitionImpl.  # noqa: E501

        Whether this workflow definition is guest user accessible.  # noqa: E501

        :return: The guest_user_accessible of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: bool
        """
        return self._guest_user_accessible

    @guest_user_accessible.setter
    def guest_user_accessible(self, guest_user_accessible):
        """Sets the guest_user_accessible of this WorkflowDefinitionImpl.

        Whether this workflow definition is guest user accessible.  # noqa: E501

        :param guest_user_accessible: The guest_user_accessible of this WorkflowDefinitionImpl.  # noqa: E501
        :type: bool
        """

        self._guest_user_accessible = guest_user_accessible

    @property
    def registered_user_accessible(self):
        """Gets the registered_user_accessible of this WorkflowDefinitionImpl.  # noqa: E501

        Whether the workflow definition is accessible by any registered user.  # noqa: E501

        :return: The registered_user_accessible of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: bool
        """
        return self._registered_user_accessible

    @registered_user_accessible.setter
    def registered_user_accessible(self, registered_user_accessible):
        """Sets the registered_user_accessible of this WorkflowDefinitionImpl.

        Whether the workflow definition is accessible by any registered user.  # noqa: E501

        :param registered_user_accessible: The registered_user_accessible of this WorkflowDefinitionImpl.  # noqa: E501
        :type: bool
        """

        self._registered_user_accessible = registered_user_accessible

    @property
    def candidate_user_check_enabled(self):
        """Gets the candidate_user_check_enabled of this WorkflowDefinitionImpl.  # noqa: E501

        Whether the candidate user check for this workflow is enabled.  # noqa: E501

        :return: The candidate_user_check_enabled of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: bool
        """
        return self._candidate_user_check_enabled

    @candidate_user_check_enabled.setter
    def candidate_user_check_enabled(self, candidate_user_check_enabled):
        """Sets the candidate_user_check_enabled of this WorkflowDefinitionImpl.

        Whether the candidate user check for this workflow is enabled.  # noqa: E501

        :param candidate_user_check_enabled: The candidate_user_check_enabled of this WorkflowDefinitionImpl.  # noqa: E501
        :type: bool
        """

        self._candidate_user_check_enabled = candidate_user_check_enabled

    @property
    def global_create(self):
        """Gets the global_create of this WorkflowDefinitionImpl.  # noqa: E501

        Whether the workflow is accessible from the global create menu.  # noqa: E501

        :return: The global_create of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: bool
        """
        return self._global_create

    @global_create.setter
    def global_create(self, global_create):
        """Sets the global_create of this WorkflowDefinitionImpl.

        Whether the workflow is accessible from the global create menu.  # noqa: E501

        :param global_create: The global_create of this WorkflowDefinitionImpl.  # noqa: E501
        :type: bool
        """

        self._global_create = global_create

    @property
    def start_events(self):
        """Gets the start_events of this WorkflowDefinitionImpl.  # noqa: E501

        The start events in a list of WorkflowStartEventType enums.  # noqa: E501

        :return: The start_events of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: list[str]
        """
        return self._start_events

    @start_events.setter
    def start_events(self, start_events):
        """Sets the start_events of this WorkflowDefinitionImpl.

        The start events in a list of WorkflowStartEventType enums.  # noqa: E501

        :param start_events: The start_events of this WorkflowDefinitionImpl.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["ASSET_ADDED", "ASSET_REMOVED", "ASSET_STATUS_CHANGED", "ASSET_DOMAIN_CHANGED", "ASSET_TYPE_CHANGED", "ASSET_ATTRIBUTE_CHANGED", "ASSET_NAME_CHANGED", "ASSET_DISPLAY_NAME_CHANGED", "ASSET_ATTRIBUTE_ADDED", "ASSET_ATTRIBUTE_REMOVED", "DOMAIN_ADDED", "DOMAIN_REMOVED", "ROLE_GRANTED", "ROLE_REVOKED", "WORKFLOW_STARTED", "WORKFLOW_CANCELED", "WORKLFLOW_ESCALATION", "WORKFLOW_TASK_COMPLETED", "USER_ADDED", "USER_REMOVED", "USER_DISABLED", "COMMENT_ADDED", "COMMENT_REMOVED", "COMMENT_CHANGED", "RELATION_ADDED_AND_ASSET_IS_SOURCE", "RELATION_REMOVED_AND_ASSET_WAS_SOURCE", "RELATION_ADDED_AND_ASSET_IS_TARGET", "RELATION_REMOVED_AND_ASSET_WAS_TARGET", "TAG_ASSIGN_CHANGED", "CLASSIFICATION_MATCH_ACCEPTED", "CLASSIFICATION_MATCH_REJECTED", "CLASSIFICATION_MATCH_ADDED", "CLASSIFICATION_MATCH_REMOVED", "CLASSIFICATION_MATCH_UPDATED", "DATABASE_REGISTRATION_COMPLETED", "DATABASE_REGISTRATION_FAILED"]  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                not set(start_events).issubset(set(allowed_values))):  # noqa: E501
            raise ValueError(
                "Invalid values for `start_events` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(start_events) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._start_events = start_events

    @property
    def configuration_variables(self):
        """Gets the configuration_variables of this WorkflowDefinitionImpl.  # noqa: E501

        The map of configuration variable key-value pairs.  # noqa: E501

        :return: The configuration_variables of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._configuration_variables

    @configuration_variables.setter
    def configuration_variables(self, configuration_variables):
        """Sets the configuration_variables of this WorkflowDefinitionImpl.

        The map of configuration variable key-value pairs.  # noqa: E501

        :param configuration_variables: The configuration_variables of this WorkflowDefinitionImpl.  # noqa: E501
        :type: dict(str, str)
        """

        self._configuration_variables = configuration_variables

    @property
    def start_roles(self):
        """Gets the start_roles of this WorkflowDefinitionImpl.  # noqa: E501

        The roles allowed to start the process.  # noqa: E501

        :return: The start_roles of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: list[RoleImpl]
        """
        return self._start_roles

    @start_roles.setter
    def start_roles(self, start_roles):
        """Sets the start_roles of this WorkflowDefinitionImpl.

        The roles allowed to start the process.  # noqa: E501

        :param start_roles: The start_roles of this WorkflowDefinitionImpl.  # noqa: E501
        :type: list[RoleImpl]
        """

        self._start_roles = start_roles

    @property
    def stop_roles(self):
        """Gets the stop_roles of this WorkflowDefinitionImpl.  # noqa: E501

        The roles allowed to stop processes/tasks.  # noqa: E501

        :return: The stop_roles of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: list[RoleImpl]
        """
        return self._stop_roles

    @stop_roles.setter
    def stop_roles(self, stop_roles):
        """Sets the stop_roles of this WorkflowDefinitionImpl.

        The roles allowed to stop processes/tasks.  # noqa: E501

        :param stop_roles: The stop_roles of this WorkflowDefinitionImpl.  # noqa: E501
        :type: list[RoleImpl]
        """

        self._stop_roles = stop_roles

    @property
    def reassign_roles(self):
        """Gets the reassign_roles of this WorkflowDefinitionImpl.  # noqa: E501

        The roles allowed to reassign tasks.  # noqa: E501

        :return: The reassign_roles of this WorkflowDefinitionImpl.  # noqa: E501
        :rtype: list[RoleImpl]
        """
        return self._reassign_roles

    @reassign_roles.setter
    def reassign_roles(self, reassign_roles):
        """Sets the reassign_roles of this WorkflowDefinitionImpl.

        The roles allowed to reassign tasks.  # noqa: E501

        :param reassign_roles: The reassign_roles of this WorkflowDefinitionImpl.  # noqa: E501
        :type: list[RoleImpl]
        """

        self._reassign_roles = reassign_roles

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WorkflowDefinitionImpl):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, WorkflowDefinitionImpl):
            return True

        return self.to_dict() != other.to_dict()
