# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class StartFormDataImpl(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'form_key': 'str',
        'form_properties': 'list[FormProperty]',
        'process_id': 'str'
    }

    attribute_map = {
        'form_key': 'formKey',
        'form_properties': 'formProperties',
        'process_id': 'processId'
    }

    def __init__(self, form_key=None, form_properties=None, process_id=None, local_vars_configuration=None):  # noqa: E501
        """StartFormDataImpl - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._form_key = None
        self._form_properties = None
        self._process_id = None
        self.discriminator = None

        if form_key is not None:
            self.form_key = form_key
        if form_properties is not None:
            self.form_properties = form_properties
        if process_id is not None:
            self.process_id = process_id

    @property
    def form_key(self):
        """Gets the form_key of this StartFormDataImpl.  # noqa: E501

        The form key.  # noqa: E501

        :return: The form_key of this StartFormDataImpl.  # noqa: E501
        :rtype: str
        """
        return self._form_key

    @form_key.setter
    def form_key(self, form_key):
        """Sets the form_key of this StartFormDataImpl.

        The form key.  # noqa: E501

        :param form_key: The form_key of this StartFormDataImpl.  # noqa: E501
        :type: str
        """

        self._form_key = form_key

    @property
    def form_properties(self):
        """Gets the form_properties of this StartFormDataImpl.  # noqa: E501

        The list of form properties.  # noqa: E501

        :return: The form_properties of this StartFormDataImpl.  # noqa: E501
        :rtype: list[FormProperty]
        """
        return self._form_properties

    @form_properties.setter
    def form_properties(self, form_properties):
        """Sets the form_properties of this StartFormDataImpl.

        The list of form properties.  # noqa: E501

        :param form_properties: The form_properties of this StartFormDataImpl.  # noqa: E501
        :type: list[FormProperty]
        """

        self._form_properties = form_properties

    @property
    def process_id(self):
        """Gets the process_id of this StartFormDataImpl.  # noqa: E501


        :return: The process_id of this StartFormDataImpl.  # noqa: E501
        :rtype: str
        """
        return self._process_id

    @process_id.setter
    def process_id(self, process_id):
        """Sets the process_id of this StartFormDataImpl.


        :param process_id: The process_id of this StartFormDataImpl.  # noqa: E501
        :type: str
        """

        self._process_id = process_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StartFormDataImpl):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, StartFormDataImpl):
            return True

        return self.to_dict() != other.to_dict()
