# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class RemoveUsersFromUserGroupRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'user_group_id': 'str',
        'user_ids': 'list[str]'
    }

    attribute_map = {
        'user_group_id': 'userGroupId',
        'user_ids': 'userIds'
    }

    def __init__(self, user_group_id=None, user_ids=None, local_vars_configuration=None):  # noqa: E501
        """RemoveUsersFromUserGroupRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._user_group_id = None
        self._user_ids = None
        self.discriminator = None

        self.user_group_id = user_group_id
        self.user_ids = user_ids

    @property
    def user_group_id(self):
        """Gets the user_group_id of this RemoveUsersFromUserGroupRequest.  # noqa: E501

        The ID of the user groups from which the users should be removed.<br/>Silently ignored if the ID is provided as path parameter of the request.  # noqa: E501

        :return: The user_group_id of this RemoveUsersFromUserGroupRequest.  # noqa: E501
        :rtype: str
        """
        return self._user_group_id

    @user_group_id.setter
    def user_group_id(self, user_group_id):
        """Sets the user_group_id of this RemoveUsersFromUserGroupRequest.

        The ID of the user groups from which the users should be removed.<br/>Silently ignored if the ID is provided as path parameter of the request.  # noqa: E501

        :param user_group_id: The user_group_id of this RemoveUsersFromUserGroupRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and user_group_id is None:  # noqa: E501
            raise ValueError("Invalid value for `user_group_id`, must not be `None`")  # noqa: E501

        self._user_group_id = user_group_id

    @property
    def user_ids(self):
        """Gets the user_ids of this RemoveUsersFromUserGroupRequest.  # noqa: E501

        The list of IDs of the users which should be removed from the user group.  # noqa: E501

        :return: The user_ids of this RemoveUsersFromUserGroupRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._user_ids

    @user_ids.setter
    def user_ids(self, user_ids):
        """Sets the user_ids of this RemoveUsersFromUserGroupRequest.

        The list of IDs of the users which should be removed from the user group.  # noqa: E501

        :param user_ids: The user_ids of this RemoveUsersFromUserGroupRequest.  # noqa: E501
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and user_ids is None:  # noqa: E501
            raise ValueError("Invalid value for `user_ids`, must not be `None`")  # noqa: E501

        self._user_ids = user_ids

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RemoveUsersFromUserGroupRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RemoveUsersFromUserGroupRequest):
            return True

        return self.to_dict() != other.to_dict()
