# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class RelatedAssetReference(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'asset_id': 'str',
        'relation_type_id': 'str',
        'direction': 'bool'
    }

    attribute_map = {
        'asset_id': 'assetId',
        'relation_type_id': 'relationTypeId',
        'direction': 'direction'
    }

    def __init__(self, asset_id=None, relation_type_id=None, direction=None, local_vars_configuration=None):  # noqa: E501
        """RelatedAssetReference - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._asset_id = None
        self._relation_type_id = None
        self._direction = None
        self.discriminator = None

        if asset_id is not None:
            self.asset_id = asset_id
        if relation_type_id is not None:
            self.relation_type_id = relation_type_id
        if direction is not None:
            self.direction = direction

    @property
    def asset_id(self):
        """Gets the asset_id of this RelatedAssetReference.  # noqa: E501

        The ID of the asset which the issue is related to.  # noqa: E501

        :return: The asset_id of this RelatedAssetReference.  # noqa: E501
        :rtype: str
        """
        return self._asset_id

    @asset_id.setter
    def asset_id(self, asset_id):
        """Sets the asset_id of this RelatedAssetReference.

        The ID of the asset which the issue is related to.  # noqa: E501

        :param asset_id: The asset_id of this RelatedAssetReference.  # noqa: E501
        :type: str
        """

        self._asset_id = asset_id

    @property
    def relation_type_id(self):
        """Gets the relation_type_id of this RelatedAssetReference.  # noqa: E501

        The ID of relation type for related asset.  # noqa: E501

        :return: The relation_type_id of this RelatedAssetReference.  # noqa: E501
        :rtype: str
        """
        return self._relation_type_id

    @relation_type_id.setter
    def relation_type_id(self, relation_type_id):
        """Sets the relation_type_id of this RelatedAssetReference.

        The ID of relation type for related asset.  # noqa: E501

        :param relation_type_id: The relation_type_id of this RelatedAssetReference.  # noqa: E501
        :type: str
        """

        self._relation_type_id = relation_type_id

    @property
    def direction(self):
        """Gets the direction of this RelatedAssetReference.  # noqa: E501

        The direction of the relation where true means the issue is the source and false means the issue is the target.  # noqa: E501

        :return: The direction of this RelatedAssetReference.  # noqa: E501
        :rtype: bool
        """
        return self._direction

    @direction.setter
    def direction(self, direction):
        """Sets the direction of this RelatedAssetReference.

        The direction of the relation where true means the issue is the source and false means the issue is the target.  # noqa: E501

        :param direction: The direction of this RelatedAssetReference.  # noqa: E501
        :type: bool
        """

        self._direction = direction

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RelatedAssetReference):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RelatedAssetReference):
            return True

        return self.to_dict() != other.to_dict()
