# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class NamedDescribedWorkflowStartEventType(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'event_type': 'str',
        'name': 'str',
        'description': 'str'
    }

    attribute_map = {
        'event_type': 'eventType',
        'name': 'name',
        'description': 'description'
    }

    def __init__(self, event_type=None, name=None, description=None, local_vars_configuration=None):  # noqa: E501
        """NamedDescribedWorkflowStartEventType - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._event_type = None
        self._name = None
        self._description = None
        self.discriminator = None

        if event_type is not None:
            self.event_type = event_type
        if name is not None:
            self.name = name
        if description is not None:
            self.description = description

    @property
    def event_type(self):
        """Gets the event_type of this NamedDescribedWorkflowStartEventType.  # noqa: E501

        The event type identifier  # noqa: E501

        :return: The event_type of this NamedDescribedWorkflowStartEventType.  # noqa: E501
        :rtype: str
        """
        return self._event_type

    @event_type.setter
    def event_type(self, event_type):
        """Sets the event_type of this NamedDescribedWorkflowStartEventType.

        The event type identifier  # noqa: E501

        :param event_type: The event_type of this NamedDescribedWorkflowStartEventType.  # noqa: E501
        :type: str
        """
        allowed_values = ["ASSET_ADDED", "ASSET_REMOVED", "ASSET_STATUS_CHANGED", "ASSET_DOMAIN_CHANGED", "ASSET_TYPE_CHANGED", "ASSET_ATTRIBUTE_CHANGED", "ASSET_NAME_CHANGED", "ASSET_DISPLAY_NAME_CHANGED", "ASSET_ATTRIBUTE_ADDED", "ASSET_ATTRIBUTE_REMOVED", "DOMAIN_ADDED", "DOMAIN_REMOVED", "ROLE_GRANTED", "ROLE_REVOKED", "WORKFLOW_STARTED", "WORKFLOW_CANCELED", "WORKLFLOW_ESCALATION", "WORKFLOW_TASK_COMPLETED", "USER_ADDED", "USER_REMOVED", "USER_DISABLED", "COMMENT_ADDED", "COMMENT_REMOVED", "COMMENT_CHANGED", "RELATION_ADDED_AND_ASSET_IS_SOURCE", "RELATION_REMOVED_AND_ASSET_WAS_SOURCE", "RELATION_ADDED_AND_ASSET_IS_TARGET", "RELATION_REMOVED_AND_ASSET_WAS_TARGET", "TAG_ASSIGN_CHANGED", "CLASSIFICATION_MATCH_ACCEPTED", "CLASSIFICATION_MATCH_REJECTED", "CLASSIFICATION_MATCH_ADDED", "CLASSIFICATION_MATCH_REMOVED", "CLASSIFICATION_MATCH_UPDATED", "DATABASE_REGISTRATION_COMPLETED", "DATABASE_REGISTRATION_FAILED"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and event_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `event_type` ({0}), must be one of {1}"  # noqa: E501
                .format(event_type, allowed_values)
            )

        self._event_type = event_type

    @property
    def name(self):
        """Gets the name of this NamedDescribedWorkflowStartEventType.  # noqa: E501

        The event type name  # noqa: E501

        :return: The name of this NamedDescribedWorkflowStartEventType.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this NamedDescribedWorkflowStartEventType.

        The event type name  # noqa: E501

        :param name: The name of this NamedDescribedWorkflowStartEventType.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """Gets the description of this NamedDescribedWorkflowStartEventType.  # noqa: E501

        The event type description  # noqa: E501

        :return: The description of this NamedDescribedWorkflowStartEventType.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this NamedDescribedWorkflowStartEventType.

        The event type description  # noqa: E501

        :param description: The description of this NamedDescribedWorkflowStartEventType.  # noqa: E501
        :type: str
        """

        self._description = description

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NamedDescribedWorkflowStartEventType):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NamedDescribedWorkflowStartEventType):
            return True

        return self.to_dict() != other.to_dict()
