# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class ArticulationRuleRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'operation': 'str',
        'score': 'float',
        'status_id': 'str',
        'attribute_type_id': 'str'
    }

    attribute_map = {
        'id': 'id',
        'operation': 'operation',
        'score': 'score',
        'status_id': 'statusId',
        'attribute_type_id': 'attributeTypeId'
    }

    def __init__(self, id=None, operation=None, score=None, status_id=None, attribute_type_id=None, local_vars_configuration=None):  # noqa: E501
        """ArticulationRuleRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._operation = None
        self._score = None
        self._status_id = None
        self._attribute_type_id = None
        self.discriminator = None

        if id is not None:
            self.id = id
        self.operation = operation
        self.score = score
        if status_id is not None:
            self.status_id = status_id
        if attribute_type_id is not None:
            self.attribute_type_id = attribute_type_id

    @property
    def id(self):
        """Gets the id of this ArticulationRuleRequest.  # noqa: E501

        The ID of the articulation rule.  # noqa: E501

        :return: The id of this ArticulationRuleRequest.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ArticulationRuleRequest.

        The ID of the articulation rule.  # noqa: E501

        :param id: The id of this ArticulationRuleRequest.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def operation(self):
        """Gets the operation of this ArticulationRuleRequest.  # noqa: E501

        The <code>operation</code> ADD or SET.  # noqa: E501

        :return: The operation of this ArticulationRuleRequest.  # noqa: E501
        :rtype: str
        """
        return self._operation

    @operation.setter
    def operation(self, operation):
        """Sets the operation of this ArticulationRuleRequest.

        The <code>operation</code> ADD or SET.  # noqa: E501

        :param operation: The operation of this ArticulationRuleRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and operation is None:  # noqa: E501
            raise ValueError("Invalid value for `operation`, must not be `None`")  # noqa: E501
        allowed_values = ["ADD", "SET"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and operation not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `operation` ({0}), must be one of {1}"  # noqa: E501
                .format(operation, allowed_values)
            )

        self._operation = operation

    @property
    def score(self):
        """Gets the score of this ArticulationRuleRequest.  # noqa: E501

        The articulation score (between 0 and 100).  # noqa: E501

        :return: The score of this ArticulationRuleRequest.  # noqa: E501
        :rtype: float
        """
        return self._score

    @score.setter
    def score(self, score):
        """Sets the score of this ArticulationRuleRequest.

        The articulation score (between 0 and 100).  # noqa: E501

        :param score: The score of this ArticulationRuleRequest.  # noqa: E501
        :type: float
        """
        if self.local_vars_configuration.client_side_validation and score is None:  # noqa: E501
            raise ValueError("Invalid value for `score`, must not be `None`")  # noqa: E501

        self._score = score

    @property
    def status_id(self):
        """Gets the status_id of this ArticulationRuleRequest.  # noqa: E501

        The ID of the status.  # noqa: E501

        :return: The status_id of this ArticulationRuleRequest.  # noqa: E501
        :rtype: str
        """
        return self._status_id

    @status_id.setter
    def status_id(self, status_id):
        """Sets the status_id of this ArticulationRuleRequest.

        The ID of the status.  # noqa: E501

        :param status_id: The status_id of this ArticulationRuleRequest.  # noqa: E501
        :type: str
        """

        self._status_id = status_id

    @property
    def attribute_type_id(self):
        """Gets the attribute_type_id of this ArticulationRuleRequest.  # noqa: E501

        The ID of the attribute type.  # noqa: E501

        :return: The attribute_type_id of this ArticulationRuleRequest.  # noqa: E501
        :rtype: str
        """
        return self._attribute_type_id

    @attribute_type_id.setter
    def attribute_type_id(self, attribute_type_id):
        """Sets the attribute_type_id of this ArticulationRuleRequest.

        The ID of the attribute type.  # noqa: E501

        :param attribute_type_id: The attribute_type_id of this ArticulationRuleRequest.  # noqa: E501
        :type: str
        """

        self._attribute_type_id = attribute_type_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ArticulationRuleRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ArticulationRuleRequest):
            return True

        return self.to_dict() != other.to_dict()
