# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class ActivityImpl(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'user': 'UserReferenceImpl',
        'timestamp': 'int',
        'cause': 'str',
        'call_id': 'str',
        'call_count': 'int',
        'activity_type': 'str',
        'description': 'str'
    }

    attribute_map = {
        'id': 'id',
        'user': 'user',
        'timestamp': 'timestamp',
        'cause': 'cause',
        'call_id': 'callId',
        'call_count': 'callCount',
        'activity_type': 'activityType',
        'description': 'description'
    }

    def __init__(self, id=None, user=None, timestamp=None, cause=None, call_id=None, call_count=None, activity_type=None, description=None, local_vars_configuration=None):  # noqa: E501
        """ActivityImpl - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._user = None
        self._timestamp = None
        self._cause = None
        self._call_id = None
        self._call_count = None
        self._activity_type = None
        self._description = None
        self.discriminator = None

        self.id = id
        self.user = user
        self.timestamp = timestamp
        self.cause = cause
        self.call_id = call_id
        self.call_count = call_count
        self.activity_type = activity_type
        self.description = description

    @property
    def id(self):
        """Gets the id of this ActivityImpl.  # noqa: E501

        The id of the represented object (entity).  # noqa: E501

        :return: The id of this ActivityImpl.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ActivityImpl.

        The id of the represented object (entity).  # noqa: E501

        :param id: The id of this ActivityImpl.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def user(self):
        """Gets the user of this ActivityImpl.  # noqa: E501


        :return: The user of this ActivityImpl.  # noqa: E501
        :rtype: UserReferenceImpl
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this ActivityImpl.


        :param user: The user of this ActivityImpl.  # noqa: E501
        :type: UserReferenceImpl
        """
        if self.local_vars_configuration.client_side_validation and user is None:  # noqa: E501
            raise ValueError("Invalid value for `user`, must not be `None`")  # noqa: E501

        self._user = user

    @property
    def timestamp(self):
        """Gets the timestamp of this ActivityImpl.  # noqa: E501

        The time when the activity happened. It is the timestamp (in UTC time standard).  # noqa: E501

        :return: The timestamp of this ActivityImpl.  # noqa: E501
        :rtype: int
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """Sets the timestamp of this ActivityImpl.

        The time when the activity happened. It is the timestamp (in UTC time standard).  # noqa: E501

        :param timestamp: The timestamp of this ActivityImpl.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and timestamp is None:  # noqa: E501
            raise ValueError("Invalid value for `timestamp`, must not be `None`")  # noqa: E501

        self._timestamp = timestamp

    @property
    def cause(self):
        """Gets the cause of this ActivityImpl.  # noqa: E501

        The cause of the activity.  # noqa: E501

        :return: The cause of this ActivityImpl.  # noqa: E501
        :rtype: str
        """
        return self._cause

    @cause.setter
    def cause(self, cause):
        """Sets the cause of this ActivityImpl.

        The cause of the activity.  # noqa: E501

        :param cause: The cause of this ActivityImpl.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and cause is None:  # noqa: E501
            raise ValueError("Invalid value for `cause`, must not be `None`")  # noqa: E501
        allowed_values = ["MANUAL", "IMPORT", "BULK_DELETE", "BULK_MOVE", "BULK_EDIT", "BULK_INSERT", "WORKFLOW"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and cause not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `cause` ({0}), must be one of {1}"  # noqa: E501
                .format(cause, allowed_values)
            )

        self._cause = cause

    @property
    def call_id(self):
        """Gets the call_id of this ActivityImpl.  # noqa: E501

        The ID of the call that resulted in an activity.  # noqa: E501

        :return: The call_id of this ActivityImpl.  # noqa: E501
        :rtype: str
        """
        return self._call_id

    @call_id.setter
    def call_id(self, call_id):
        """Sets the call_id of this ActivityImpl.

        The ID of the call that resulted in an activity.  # noqa: E501

        :param call_id: The call_id of this ActivityImpl.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and call_id is None:  # noqa: E501
            raise ValueError("Invalid value for `call_id`, must not be `None`")  # noqa: E501

        self._call_id = call_id

    @property
    def call_count(self):
        """Gets the call_count of this ActivityImpl.  # noqa: E501

        The number of calls standing behind the activity.  # noqa: E501

        :return: The call_count of this ActivityImpl.  # noqa: E501
        :rtype: int
        """
        return self._call_count

    @call_count.setter
    def call_count(self, call_count):
        """Sets the call_count of this ActivityImpl.

        The number of calls standing behind the activity.  # noqa: E501

        :param call_count: The call_count of this ActivityImpl.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and call_count is None:  # noqa: E501
            raise ValueError("Invalid value for `call_count`, must not be `None`")  # noqa: E501

        self._call_count = call_count

    @property
    def activity_type(self):
        """Gets the activity_type of this ActivityImpl.  # noqa: E501

        The type of the activity, which could be ADD, UPDATE or DELETE.  # noqa: E501

        :return: The activity_type of this ActivityImpl.  # noqa: E501
        :rtype: str
        """
        return self._activity_type

    @activity_type.setter
    def activity_type(self, activity_type):
        """Sets the activity_type of this ActivityImpl.

        The type of the activity, which could be ADD, UPDATE or DELETE.  # noqa: E501

        :param activity_type: The activity_type of this ActivityImpl.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and activity_type is None:  # noqa: E501
            raise ValueError("Invalid value for `activity_type`, must not be `None`")  # noqa: E501
        allowed_values = ["ADD", "UPDATE", "DELETE"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and activity_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `activity_type` ({0}), must be one of {1}"  # noqa: E501
                .format(activity_type, allowed_values)
            )

        self._activity_type = activity_type

    @property
    def description(self):
        """Gets the description of this ActivityImpl.  # noqa: E501

        The description of the activity. It's the string in json format. It's exact content depends on activityType and on the type of the resource that was affected by the change. Possible fields are: <ul> <li> affected - always there, consists of id, type and name, it's the reference to the resource that was added, deleted or updated with the activity. </li> <li> new, old - for all activities of ActivityType.UPDATE, respectively new and old value of the field. It can be either the reference to another object (same as affected) or just a string (eg. name change). </li> <li> field - for ActivityType.UPDATE the name of the field that was changed, eg. status, name, target etc. </li> <li> role, people, resource - only for the responsibility activities, people means owner (user or group). </li> <li> source, target, role, coRole - only for relations (including complex relation legs). </li> <li> complexRelation, legs - only for complex relations, legs here stands for all the legs that the complex relation consists of. </li> <li> kind - only for attributes, it's attribute kind, eg. boolean, string, numeric etc. </li> <li> businessItem - only for workflows, reference to an object that is the business item for non-global workflows. </li> <li> attachmentFile - only for attachments, it's the name of the file that was attached. </li> <li> rating - only for ratings and reviews, contains a double representing the current rating </li> </ul>  # noqa: E501

        :return: The description of this ActivityImpl.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ActivityImpl.

        The description of the activity. It's the string in json format. It's exact content depends on activityType and on the type of the resource that was affected by the change. Possible fields are: <ul> <li> affected - always there, consists of id, type and name, it's the reference to the resource that was added, deleted or updated with the activity. </li> <li> new, old - for all activities of ActivityType.UPDATE, respectively new and old value of the field. It can be either the reference to another object (same as affected) or just a string (eg. name change). </li> <li> field - for ActivityType.UPDATE the name of the field that was changed, eg. status, name, target etc. </li> <li> role, people, resource - only for the responsibility activities, people means owner (user or group). </li> <li> source, target, role, coRole - only for relations (including complex relation legs). </li> <li> complexRelation, legs - only for complex relations, legs here stands for all the legs that the complex relation consists of. </li> <li> kind - only for attributes, it's attribute kind, eg. boolean, string, numeric etc. </li> <li> businessItem - only for workflows, reference to an object that is the business item for non-global workflows. </li> <li> attachmentFile - only for attachments, it's the name of the file that was attached. </li> <li> rating - only for ratings and reviews, contains a double representing the current rating </li> </ul>  # noqa: E501

        :param description: The description of this ActivityImpl.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and description is None:  # noqa: E501
            raise ValueError("Invalid value for `description`, must not be `None`")  # noqa: E501

        self._description = description

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ActivityImpl):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ActivityImpl):
            return True

        return self.to_dict() != other.to_dict()
