# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from collibra_core.api_client import ApiClient
from collibra_core.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ReportingApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_insights_zip(self, **kwargs):  # noqa: E501
        """Reporting insights download  # noqa: E501

        Returns a Reporting Data archive (zip) file that contains Apache Parquet files with table content for each of the six concepts (community, domain, asset, attribute, relation and responsibility) for one day (=snapshot date). Please refer to the Reporting Data Layer product documentation for more information at [Working with your reporting data](https://productresources.collibra.com/docs/collibra/latest/Content/Reporting/co_working-with-data.htm).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_insights_zip(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str snapshot_date: Snapshot date for reporting insights data in ISO8601 format (e.g.: 2019-05-14)
        :param str format: Archive format. Currently only ZIP format is accepted
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_insights_zip_with_http_info(**kwargs)  # noqa: E501

    def get_insights_zip_with_http_info(self, **kwargs):  # noqa: E501
        """Reporting insights download  # noqa: E501

        Returns a Reporting Data archive (zip) file that contains Apache Parquet files with table content for each of the six concepts (community, domain, asset, attribute, relation and responsibility) for one day (=snapshot date). Please refer to the Reporting Data Layer product documentation for more information at [Working with your reporting data](https://productresources.collibra.com/docs/collibra/latest/Content/Reporting/co_working-with-data.htm).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_insights_zip_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str snapshot_date: Snapshot date for reporting insights data in ISO8601 format (e.g.: 2019-05-14)
        :param str format: Archive format. Currently only ZIP format is accepted
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'snapshot_date',
            'format'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_insights_zip" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'snapshot_date' in local_var_params and local_var_params['snapshot_date'] is not None:  # noqa: E501
            query_params.append(('snapshotDate', local_var_params['snapshot_date']))  # noqa: E501
        if 'format' in local_var_params and local_var_params['format'] is not None:  # noqa: E501
            query_params.append(('format', local_var_params['format']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/reporting/insights/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
