# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from collibra_core.api_client import ApiClient
from collibra_core.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class OutputModuleApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def export_csv(self, **kwargs):  # noqa: E501
        """Exports results in CSV format, returns the results immediately.  # noqa: E501

        <p>Performs an Output Module query and exports the results immediately in CSV format.</p><p>Please note that the TableViewConfig’s syntax validation is not executed by default, see <code>validationEnabled</code></p><p>DGC admin console settings may impact the execution of the query (especially in terms of timeout and a limit on the number of results). For details please consult output module documentation.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_csv(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param bool validation_enabled: Determines if the TableViewConfig’s syntax should be validated (<code>true</code>) or not (<code>false</code>). Default value is <code>false</code> for backward compatibility reasons but it is strongly advised to always enable this validation.
        :param str separator: The delimiter character used to separate entries. Default value is <code>';'</code>.
        :param str quote: The delimiter character used for quoted entries. Default value  is <code>'\"'</code>.
        :param str escape: The delimiter character used to escape separator or quote character. Default value is <code>'\\\\'</code>.
        :param bool header_row: Whether a response should include a header (<code>true</code>) or not (<code>false</code>). Default value is <code>true</code>.
        :param str body: The JSON representation of TableViewConfig that describes the query to be performed.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.export_csv_with_http_info(**kwargs)  # noqa: E501

    def export_csv_with_http_info(self, **kwargs):  # noqa: E501
        """Exports results in CSV format, returns the results immediately.  # noqa: E501

        <p>Performs an Output Module query and exports the results immediately in CSV format.</p><p>Please note that the TableViewConfig’s syntax validation is not executed by default, see <code>validationEnabled</code></p><p>DGC admin console settings may impact the execution of the query (especially in terms of timeout and a limit on the number of results). For details please consult output module documentation.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_csv_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param bool validation_enabled: Determines if the TableViewConfig’s syntax should be validated (<code>true</code>) or not (<code>false</code>). Default value is <code>false</code> for backward compatibility reasons but it is strongly advised to always enable this validation.
        :param str separator: The delimiter character used to separate entries. Default value is <code>';'</code>.
        :param str quote: The delimiter character used for quoted entries. Default value  is <code>'\"'</code>.
        :param str escape: The delimiter character used to escape separator or quote character. Default value is <code>'\\\\'</code>.
        :param bool header_row: Whether a response should include a header (<code>true</code>) or not (<code>false</code>). Default value is <code>true</code>.
        :param str body: The JSON representation of TableViewConfig that describes the query to be performed.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'validation_enabled',
            'separator',
            'quote',
            'escape',
            'header_row',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_csv" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'validation_enabled' in local_var_params and local_var_params['validation_enabled'] is not None:  # noqa: E501
            query_params.append(('validationEnabled', local_var_params['validation_enabled']))  # noqa: E501
        if 'separator' in local_var_params and local_var_params['separator'] is not None:  # noqa: E501
            query_params.append(('separator', local_var_params['separator']))  # noqa: E501
        if 'quote' in local_var_params and local_var_params['quote'] is not None:  # noqa: E501
            query_params.append(('quote', local_var_params['quote']))  # noqa: E501
        if 'escape' in local_var_params and local_var_params['escape'] is not None:  # noqa: E501
            query_params.append(('escape', local_var_params['escape']))  # noqa: E501
        if 'header_row' in local_var_params and local_var_params['header_row'] is not None:  # noqa: E501
            query_params.append(('headerRow', local_var_params['header_row']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-yaml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/outputModule/export/csv', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_csv_in_job(self, **kwargs):  # noqa: E501
        """Exports results in CSV format, returns JSON representation of the async Job.  # noqa: E501

        <p>Starts a job that performs an Output Module query and stores the results in a file in CSV format. Id of the file can be retrieved from the <code>message.id</code> property of the job once the job is finished.</p><p>Please note that the TableViewConfig’s syntax validation is not executed by default, see <code>validationEnabled</code></p><p>DGC admin console settings may impact the execution of the query (especially in terms of timeout and a limit on the number of results). For details please consult output module documentation.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_csv_in_job(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param bool validation_enabled: Determines if the TableViewConfig’s syntax should be validated (<code>true</code>) or not (<code>false</code>). Validation is then performed immediately instead of only when the job is started. Please note that the validation will always take place during the Job execution, regardless of this parameter. Default value is false.
        :param str file_name: The name of the file. By default the file name will be generated
        :param str separator: The delimiter character used to separate entries. Default value is <code>';'</code>.
        :param str quote: The delimiter character used for quoted entries. Default value  is <code>'\"'</code>.
        :param str escape: The delimiter character used to escape separator or quote character. Default value is <code>'\\\\'</code>.
        :param bool header_row: Whether a response should include a header (<code>true</code>) or not (<code>false</code>). Default value is <code>true</code>.
        :param bool send_notification: Whether an e-mail must be sent on completion of the job.
        :param str body: The JSON representation of TableViewConfig that describes the query to be performed.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.export_csv_in_job_with_http_info(**kwargs)  # noqa: E501

    def export_csv_in_job_with_http_info(self, **kwargs):  # noqa: E501
        """Exports results in CSV format, returns JSON representation of the async Job.  # noqa: E501

        <p>Starts a job that performs an Output Module query and stores the results in a file in CSV format. Id of the file can be retrieved from the <code>message.id</code> property of the job once the job is finished.</p><p>Please note that the TableViewConfig’s syntax validation is not executed by default, see <code>validationEnabled</code></p><p>DGC admin console settings may impact the execution of the query (especially in terms of timeout and a limit on the number of results). For details please consult output module documentation.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_csv_in_job_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param bool validation_enabled: Determines if the TableViewConfig’s syntax should be validated (<code>true</code>) or not (<code>false</code>). Validation is then performed immediately instead of only when the job is started. Please note that the validation will always take place during the Job execution, regardless of this parameter. Default value is false.
        :param str file_name: The name of the file. By default the file name will be generated
        :param str separator: The delimiter character used to separate entries. Default value is <code>';'</code>.
        :param str quote: The delimiter character used for quoted entries. Default value  is <code>'\"'</code>.
        :param str escape: The delimiter character used to escape separator or quote character. Default value is <code>'\\\\'</code>.
        :param bool header_row: Whether a response should include a header (<code>true</code>) or not (<code>false</code>). Default value is <code>true</code>.
        :param bool send_notification: Whether an e-mail must be sent on completion of the job.
        :param str body: The JSON representation of TableViewConfig that describes the query to be performed.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Job, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'validation_enabled',
            'file_name',
            'separator',
            'quote',
            'escape',
            'header_row',
            'send_notification',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_csv_in_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'validation_enabled' in local_var_params and local_var_params['validation_enabled'] is not None:  # noqa: E501
            query_params.append(('validationEnabled', local_var_params['validation_enabled']))  # noqa: E501
        if 'file_name' in local_var_params and local_var_params['file_name'] is not None:  # noqa: E501
            query_params.append(('fileName', local_var_params['file_name']))  # noqa: E501
        if 'separator' in local_var_params and local_var_params['separator'] is not None:  # noqa: E501
            query_params.append(('separator', local_var_params['separator']))  # noqa: E501
        if 'quote' in local_var_params and local_var_params['quote'] is not None:  # noqa: E501
            query_params.append(('quote', local_var_params['quote']))  # noqa: E501
        if 'escape' in local_var_params and local_var_params['escape'] is not None:  # noqa: E501
            query_params.append(('escape', local_var_params['escape']))  # noqa: E501
        if 'header_row' in local_var_params and local_var_params['header_row'] is not None:  # noqa: E501
            query_params.append(('headerRow', local_var_params['header_row']))  # noqa: E501
        if 'send_notification' in local_var_params and local_var_params['send_notification'] is not None:  # noqa: E501
            query_params.append(('sendNotification', local_var_params['send_notification']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-yaml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/outputModule/export/csv-job', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Job',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_csv_to_file(self, **kwargs):  # noqa: E501
        """Exports results in CSV format, returns information about created file.  # noqa: E501

        <p>Performs an Output Module query and stores the query results in a file in CSV format. The id of the file is returned in the response.</p><p>Please note that the TableViewConfig’s syntax validation is not executed by default, see <code>validationEnabled</code></p><p>DGC admin console settings may impact the execution of the query (especially in terms of timeout and a limit on the number of results). For details please consult output module documentation.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_csv_to_file(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param bool validation_enabled: Determines if the TableViewConfig’s syntax should be validated (<code>true</code>) or not (<code>false</code>). Default value is false for backward compatibility reasons but it is strongly advised to always enable this validation.
        :param str file_name: The name of the file. By default the file name will be generated
        :param str separator: The delimiter character used to separate entries. Default value is <code>';'</code>
        :param str quote: The delimiter character used for quoted entries. Default value  is <code>'\"'</code>
        :param str escape: The delimiter character used to escape separator or quote character. Default value is <code>'\\\\'</code>
        :param bool header_row: Whether a response should include a header (<code>true</code>) or not (<code>false</code>). Default value is <code>true</code>
        :param str body: The JSON representation of TableViewConfig that describes the query to be performed.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileInfoImpl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.export_csv_to_file_with_http_info(**kwargs)  # noqa: E501

    def export_csv_to_file_with_http_info(self, **kwargs):  # noqa: E501
        """Exports results in CSV format, returns information about created file.  # noqa: E501

        <p>Performs an Output Module query and stores the query results in a file in CSV format. The id of the file is returned in the response.</p><p>Please note that the TableViewConfig’s syntax validation is not executed by default, see <code>validationEnabled</code></p><p>DGC admin console settings may impact the execution of the query (especially in terms of timeout and a limit on the number of results). For details please consult output module documentation.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_csv_to_file_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param bool validation_enabled: Determines if the TableViewConfig’s syntax should be validated (<code>true</code>) or not (<code>false</code>). Default value is false for backward compatibility reasons but it is strongly advised to always enable this validation.
        :param str file_name: The name of the file. By default the file name will be generated
        :param str separator: The delimiter character used to separate entries. Default value is <code>';'</code>
        :param str quote: The delimiter character used for quoted entries. Default value  is <code>'\"'</code>
        :param str escape: The delimiter character used to escape separator or quote character. Default value is <code>'\\\\'</code>
        :param bool header_row: Whether a response should include a header (<code>true</code>) or not (<code>false</code>). Default value is <code>true</code>
        :param str body: The JSON representation of TableViewConfig that describes the query to be performed.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileInfoImpl, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'validation_enabled',
            'file_name',
            'separator',
            'quote',
            'escape',
            'header_row',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_csv_to_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'validation_enabled' in local_var_params and local_var_params['validation_enabled'] is not None:  # noqa: E501
            query_params.append(('validationEnabled', local_var_params['validation_enabled']))  # noqa: E501
        if 'file_name' in local_var_params and local_var_params['file_name'] is not None:  # noqa: E501
            query_params.append(('fileName', local_var_params['file_name']))  # noqa: E501
        if 'separator' in local_var_params and local_var_params['separator'] is not None:  # noqa: E501
            query_params.append(('separator', local_var_params['separator']))  # noqa: E501
        if 'quote' in local_var_params and local_var_params['quote'] is not None:  # noqa: E501
            query_params.append(('quote', local_var_params['quote']))  # noqa: E501
        if 'escape' in local_var_params and local_var_params['escape'] is not None:  # noqa: E501
            query_params.append(('escape', local_var_params['escape']))  # noqa: E501
        if 'header_row' in local_var_params and local_var_params['header_row'] is not None:  # noqa: E501
            query_params.append(('headerRow', local_var_params['header_row']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-yaml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/outputModule/export/csv-file', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileInfoImpl',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_excel_in_job(self, **kwargs):  # noqa: E501
        """Exports results in Excel format, returns JSON representation of the async Job.  # noqa: E501

        <p>Starts a job that performs an Output Module query and stores the results in a file in Excel format. Id of the file can be retrieved from the <code>message.id</code> property of the job once the job is finished.</p></p>Please note that the TableViewConfig’s syntax validation is not executed by default, see <code>validationEnabled</code></p><p>DGC admin console settings may impact the execution of the query (especially in terms of timeout and a limit on the number of results). For details please consult output module documentation.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_excel_in_job(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param bool send_notification: Whether an e-mail must be sent on completion of the job.
        :param bool validation_enabled: Determines if the TableViewConfig’s syntax should be validated (<code>true</code>) or not (<code>false</code>). Validation is then performed immediately instead of only when the job is started. Please note that the validation will always take place during the Job execution, regardless of this parameter. Default value is false.
        :param str file_name: The name of the file. By default the file name will be generated.
        :param str sheet_name: The name of the sheet. By default no sheet name is set.
        :param bool use_xlsx: Whether the Excel file to export will be '.xlsx' file (<code>true</code>) or a '.xls' file (<code>false</code>. Default value is true.<br/>The parameter will be removed. In the future only XLSX files will be supported..
        :param bool header_row: Whether a response should include a header (<code>true</code>) or not (<code>false</code>). Default value is <code>true</code>.
        :param str body: The JSON/YAML representation of TableViewConfig that describes the query to be performed.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.export_excel_in_job_with_http_info(**kwargs)  # noqa: E501

    def export_excel_in_job_with_http_info(self, **kwargs):  # noqa: E501
        """Exports results in Excel format, returns JSON representation of the async Job.  # noqa: E501

        <p>Starts a job that performs an Output Module query and stores the results in a file in Excel format. Id of the file can be retrieved from the <code>message.id</code> property of the job once the job is finished.</p></p>Please note that the TableViewConfig’s syntax validation is not executed by default, see <code>validationEnabled</code></p><p>DGC admin console settings may impact the execution of the query (especially in terms of timeout and a limit on the number of results). For details please consult output module documentation.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_excel_in_job_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param bool send_notification: Whether an e-mail must be sent on completion of the job.
        :param bool validation_enabled: Determines if the TableViewConfig’s syntax should be validated (<code>true</code>) or not (<code>false</code>). Validation is then performed immediately instead of only when the job is started. Please note that the validation will always take place during the Job execution, regardless of this parameter. Default value is false.
        :param str file_name: The name of the file. By default the file name will be generated.
        :param str sheet_name: The name of the sheet. By default no sheet name is set.
        :param bool use_xlsx: Whether the Excel file to export will be '.xlsx' file (<code>true</code>) or a '.xls' file (<code>false</code>. Default value is true.<br/>The parameter will be removed. In the future only XLSX files will be supported..
        :param bool header_row: Whether a response should include a header (<code>true</code>) or not (<code>false</code>). Default value is <code>true</code>.
        :param str body: The JSON/YAML representation of TableViewConfig that describes the query to be performed.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Job, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'send_notification',
            'validation_enabled',
            'file_name',
            'sheet_name',
            'use_xlsx',
            'header_row',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_excel_in_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'send_notification' in local_var_params and local_var_params['send_notification'] is not None:  # noqa: E501
            query_params.append(('sendNotification', local_var_params['send_notification']))  # noqa: E501
        if 'validation_enabled' in local_var_params and local_var_params['validation_enabled'] is not None:  # noqa: E501
            query_params.append(('validationEnabled', local_var_params['validation_enabled']))  # noqa: E501
        if 'file_name' in local_var_params and local_var_params['file_name'] is not None:  # noqa: E501
            query_params.append(('fileName', local_var_params['file_name']))  # noqa: E501
        if 'sheet_name' in local_var_params and local_var_params['sheet_name'] is not None:  # noqa: E501
            query_params.append(('sheetName', local_var_params['sheet_name']))  # noqa: E501
        if 'use_xlsx' in local_var_params and local_var_params['use_xlsx'] is not None:  # noqa: E501
            query_params.append(('useXLSX', local_var_params['use_xlsx']))  # noqa: E501
        if 'header_row' in local_var_params and local_var_params['header_row'] is not None:  # noqa: E501
            query_params.append(('headerRow', local_var_params['header_row']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-yaml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/outputModule/export/excel-job', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Job',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_excel_to_file(self, **kwargs):  # noqa: E501
        """Exports results in Excel format, returns information about created file.  # noqa: E501

        <p>Performs an Output Module query and stores the query results in a file in Excel format. The id of the file is returned in the response.</p><p>Please note that the TableViewConfig’s syntax validation is not executed by default, see <code>validationEnabled</code></p><p>DGC admin console settings may impact the execution of the query (especially in terms of timeout and a limit on the number of results). For details please consult output module documentation.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_excel_to_file(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param bool validation_enabled: Determines if the TableViewConfig’s syntax should be validated (<code>true</code>) or not (<code>false</code>). Default value is false for backward compatibility reasons but it is strongly advised to always enable this validation.
        :param str file_name: The name of the file. By default the file name will be generated.
        :param str sheet_name: The name of the sheet. By default no sheet name is set.
        :param bool use_xlsx: Whether the Excel file to export will be '.xlsx' file (<code>true</code>) or a '.xls' file (<code>false</code>. Default value is true.<br/>The parameter will be removed. In the future only XLSX files will be supported.
        :param bool header_row: Whether a response should include a header (<code>true</code>) or not (<code>false</code>). Default value is <code>true</code>.
        :param str body: The JSON/YAML representation of TableViewConfig that describes the query to be performed.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileInfoImpl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.export_excel_to_file_with_http_info(**kwargs)  # noqa: E501

    def export_excel_to_file_with_http_info(self, **kwargs):  # noqa: E501
        """Exports results in Excel format, returns information about created file.  # noqa: E501

        <p>Performs an Output Module query and stores the query results in a file in Excel format. The id of the file is returned in the response.</p><p>Please note that the TableViewConfig’s syntax validation is not executed by default, see <code>validationEnabled</code></p><p>DGC admin console settings may impact the execution of the query (especially in terms of timeout and a limit on the number of results). For details please consult output module documentation.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_excel_to_file_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param bool validation_enabled: Determines if the TableViewConfig’s syntax should be validated (<code>true</code>) or not (<code>false</code>). Default value is false for backward compatibility reasons but it is strongly advised to always enable this validation.
        :param str file_name: The name of the file. By default the file name will be generated.
        :param str sheet_name: The name of the sheet. By default no sheet name is set.
        :param bool use_xlsx: Whether the Excel file to export will be '.xlsx' file (<code>true</code>) or a '.xls' file (<code>false</code>. Default value is true.<br/>The parameter will be removed. In the future only XLSX files will be supported.
        :param bool header_row: Whether a response should include a header (<code>true</code>) or not (<code>false</code>). Default value is <code>true</code>.
        :param str body: The JSON/YAML representation of TableViewConfig that describes the query to be performed.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileInfoImpl, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'validation_enabled',
            'file_name',
            'sheet_name',
            'use_xlsx',
            'header_row',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_excel_to_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'validation_enabled' in local_var_params and local_var_params['validation_enabled'] is not None:  # noqa: E501
            query_params.append(('validationEnabled', local_var_params['validation_enabled']))  # noqa: E501
        if 'file_name' in local_var_params and local_var_params['file_name'] is not None:  # noqa: E501
            query_params.append(('fileName', local_var_params['file_name']))  # noqa: E501
        if 'sheet_name' in local_var_params and local_var_params['sheet_name'] is not None:  # noqa: E501
            query_params.append(('sheetName', local_var_params['sheet_name']))  # noqa: E501
        if 'use_xlsx' in local_var_params and local_var_params['use_xlsx'] is not None:  # noqa: E501
            query_params.append(('useXLSX', local_var_params['use_xlsx']))  # noqa: E501
        if 'header_row' in local_var_params and local_var_params['header_row'] is not None:  # noqa: E501
            query_params.append(('headerRow', local_var_params['header_row']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-yaml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/outputModule/export/excel-file', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileInfoImpl',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_json(self, **kwargs):  # noqa: E501
        """Exports results in JSON format, returns the results immediately.  # noqa: E501

        <p>Performs an Output Module query and exports the returns results immediately in JSON format.</p><p>Please note that the ViewConfig/TableViewConfig’s syntax validation is not executed by default, see <code>validationEnabled</code></p><p>DGC admin console settings may impact the execution of the query (especially in terms of timeout and a limit on the number of results). For details please consult output module documentation.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_json(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param bool validation_enabled: Determines if the ViewConfig’s syntax should be validated (<code>true</code>) or not (<code>false</code>). Default value is false for backward compatibility reasons but it is strongly advised to always enable this validation.
        :param str body: The JSON/YAML representation of ViewConfig/TableViewConfig that describes the query to be performed.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        kwargs['response_type'] = 'str' # ROR TODO Set because it was returning None
        return self.export_json_with_http_info(**kwargs)  # noqa: E501

    def export_json_with_http_info(self, **kwargs):  # noqa: E501
        """Exports results in JSON format, returns the results immediately.  # noqa: E501

        <p>Performs an Output Module query and exports the returns results immediately in JSON format.</p><p>Please note that the ViewConfig/TableViewConfig’s syntax validation is not executed by default, see <code>validationEnabled</code></p><p>DGC admin console settings may impact the execution of the query (especially in terms of timeout and a limit on the number of results). For details please consult output module documentation.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_json_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param bool validation_enabled: Determines if the ViewConfig’s syntax should be validated (<code>true</code>) or not (<code>false</code>). Default value is false for backward compatibility reasons but it is strongly advised to always enable this validation.
        :param str body: The JSON/YAML representation of ViewConfig/TableViewConfig that describes the query to be performed.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'validation_enabled',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_json" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'validation_enabled' in local_var_params and local_var_params['validation_enabled'] is not None:  # noqa: E501
            query_params.append(('validationEnabled', local_var_params['validation_enabled']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            #['text/plain', 'application/json'])  # noqa: E501
            ['text/plain'])  # noqa: E501 # ROR TODO Updated

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            #['application/json', 'application/x-yaml'])  # noqa: E501
            ['application/json'])  # noqa: E501 # ROR TODO Updated

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/outputModule/export/json', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_json_in_job(self, **kwargs):  # noqa: E501
        """Exports results in JSON format, returns JSON representation of the async Job.  # noqa: E501

        <p>Starts a job that performs an Output Module query and stores the results in a file in JSON format. Id of the file can be retrieved from the <code>message.id</code> property of the job once the job is finished.</p><p>Please note that the ViewConfig/TableViewConfig’s syntax validation is not executed by default, see <code>validationEnabled</code></p><p>DGC admin console settings may impact the execution of the query (especially in terms of timeout and a limit on the number of results). For details please consult output module documentation.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_json_in_job(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param bool send_notification: Whether an e-mail must be sent on completion of the job.
        :param bool validation_enabled: Determines if the ViewConfig’s syntax should be validated (<code>true</code>) or not (<code>false</code>). Validation is then performed immediately instead of only when the job is started. Please note that the validation will always take place during the Job execution, regardless of this parameter. Default value is false.
        :param str file_name: The name of the file. By default the file name will be generated.
        :param str body: The JSON/YAML representation of ViewConfig/TableViewConfig that describes the query to be performed.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.export_json_in_job_with_http_info(**kwargs)  # noqa: E501

    def export_json_in_job_with_http_info(self, **kwargs):  # noqa: E501
        """Exports results in JSON format, returns JSON representation of the async Job.  # noqa: E501

        <p>Starts a job that performs an Output Module query and stores the results in a file in JSON format. Id of the file can be retrieved from the <code>message.id</code> property of the job once the job is finished.</p><p>Please note that the ViewConfig/TableViewConfig’s syntax validation is not executed by default, see <code>validationEnabled</code></p><p>DGC admin console settings may impact the execution of the query (especially in terms of timeout and a limit on the number of results). For details please consult output module documentation.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_json_in_job_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param bool send_notification: Whether an e-mail must be sent on completion of the job.
        :param bool validation_enabled: Determines if the ViewConfig’s syntax should be validated (<code>true</code>) or not (<code>false</code>). Validation is then performed immediately instead of only when the job is started. Please note that the validation will always take place during the Job execution, regardless of this parameter. Default value is false.
        :param str file_name: The name of the file. By default the file name will be generated.
        :param str body: The JSON/YAML representation of ViewConfig/TableViewConfig that describes the query to be performed.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Job, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'send_notification',
            'validation_enabled',
            'file_name',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_json_in_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'send_notification' in local_var_params and local_var_params['send_notification'] is not None:  # noqa: E501
            query_params.append(('sendNotification', local_var_params['send_notification']))  # noqa: E501
        if 'validation_enabled' in local_var_params and local_var_params['validation_enabled'] is not None:  # noqa: E501
            query_params.append(('validationEnabled', local_var_params['validation_enabled']))  # noqa: E501
        if 'file_name' in local_var_params and local_var_params['file_name'] is not None:  # noqa: E501
            query_params.append(('fileName', local_var_params['file_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-yaml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/outputModule/export/json-job', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Job',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_json_to_file(self, **kwargs):  # noqa: E501
        """Exports results in JSON format, returns information about created file.  # noqa: E501

        <p>Performs an Output Module query and stores the query results in a file in JSON format. The id of the file is returned in the response.</p><p>Please note that the ViewConfig/TableViewConfig’s syntax validation is not executed by default, see <code>validationEnabled</code></p><p>DGC admin console settings may impact the execution of the query (especially in terms of timeout and a limit on the number of results). For details please consult output module documentation.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_json_to_file(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param bool validation_enabled: Determines if the ViewConfig’s syntax should be validated (<code>true</code>) or not (<code>false</code>). Default value is false for backward compatibility reasons but it is strongly advised to always enable this validation.
        :param str file_name: The name of the file. By default the file name will be generated.
        :param str body: The JSON/YAML representation of ViewConfig/TableViewConfig that describes the query to be performed.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileInfoImpl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.export_json_to_file_with_http_info(**kwargs)  # noqa: E501

    def export_json_to_file_with_http_info(self, **kwargs):  # noqa: E501
        """Exports results in JSON format, returns information about created file.  # noqa: E501

        <p>Performs an Output Module query and stores the query results in a file in JSON format. The id of the file is returned in the response.</p><p>Please note that the ViewConfig/TableViewConfig’s syntax validation is not executed by default, see <code>validationEnabled</code></p><p>DGC admin console settings may impact the execution of the query (especially in terms of timeout and a limit on the number of results). For details please consult output module documentation.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_json_to_file_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param bool validation_enabled: Determines if the ViewConfig’s syntax should be validated (<code>true</code>) or not (<code>false</code>). Default value is false for backward compatibility reasons but it is strongly advised to always enable this validation.
        :param str file_name: The name of the file. By default the file name will be generated.
        :param str body: The JSON/YAML representation of ViewConfig/TableViewConfig that describes the query to be performed.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileInfoImpl, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'validation_enabled',
            'file_name',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_json_to_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'validation_enabled' in local_var_params and local_var_params['validation_enabled'] is not None:  # noqa: E501
            query_params.append(('validationEnabled', local_var_params['validation_enabled']))  # noqa: E501
        if 'file_name' in local_var_params and local_var_params['file_name'] is not None:  # noqa: E501
            query_params.append(('fileName', local_var_params['file_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-yaml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/outputModule/export/json-file', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileInfoImpl',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_xml(self, **kwargs):  # noqa: E501
        """Exports results in XML format, returns the results immediately.  # noqa: E501

        <p>Performs an Output Module query and exports the returns results immediately in XML format.</p><p>Please note that the ViewConfig’s syntax validation is not executed by default, see <code>validationEnabled</code></p><p>DGC admin console settings may impact the execution of the query (especially in terms of timeout and a limit on the number of results).For details please consult output module documentation.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_xml(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param bool validation_enabled: Determines if the ViewConfig’s syntax should be validated (<code>true</code>) or not (<code>false</code>). Default value is false for backward compatibility reasons but it is strongly advised to always enable this validation.
        :param str body: The JSON/YAML representation of ViewConfig that describes the query to be performed.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.export_xml_with_http_info(**kwargs)  # noqa: E501

    def export_xml_with_http_info(self, **kwargs):  # noqa: E501
        """Exports results in XML format, returns the results immediately.  # noqa: E501

        <p>Performs an Output Module query and exports the returns results immediately in XML format.</p><p>Please note that the ViewConfig’s syntax validation is not executed by default, see <code>validationEnabled</code></p><p>DGC admin console settings may impact the execution of the query (especially in terms of timeout and a limit on the number of results).For details please consult output module documentation.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_xml_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param bool validation_enabled: Determines if the ViewConfig’s syntax should be validated (<code>true</code>) or not (<code>false</code>). Default value is false for backward compatibility reasons but it is strongly advised to always enable this validation.
        :param str body: The JSON/YAML representation of ViewConfig that describes the query to be performed.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'validation_enabled',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_xml" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'validation_enabled' in local_var_params and local_var_params['validation_enabled'] is not None:  # noqa: E501
            query_params.append(('validationEnabled', local_var_params['validation_enabled']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-yaml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/outputModule/export/xml', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_xml_in_job(self, **kwargs):  # noqa: E501
        """Exports results in XML format, returns JSON representation of the async Job.  # noqa: E501

        <p>Starts a job that performs an Output Module query and stores the results in a file in XML format. Id of the file can be retrieved from the <code>message.id</code> property of the job once the job is finished.</p><p>Please note that the ViewConfig's syntax validation is not executed by default, see <code>validationEnabled</code></p><p>DGC admin console settings may impact the execution of the query (especially in terms of timeout and a limit on the number of results). For details please consult output module documentation.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_xml_in_job(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param bool validation_enabled: Determines if the ViewConfig’s syntax should be validated (<code>true</code>) or not (<code>false</code>). Validation is then performed immediately instead of only when the job is started. Please note that the validation will always take place during the Job execution, regardless of this parameter. Default value is false.
        :param str file_name: The name of the file. By default the file name will be generated.
        :param str body: The JSON/YAML representation of ViewConfig that describes the query to be performed.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.export_xml_in_job_with_http_info(**kwargs)  # noqa: E501

    def export_xml_in_job_with_http_info(self, **kwargs):  # noqa: E501
        """Exports results in XML format, returns JSON representation of the async Job.  # noqa: E501

        <p>Starts a job that performs an Output Module query and stores the results in a file in XML format. Id of the file can be retrieved from the <code>message.id</code> property of the job once the job is finished.</p><p>Please note that the ViewConfig's syntax validation is not executed by default, see <code>validationEnabled</code></p><p>DGC admin console settings may impact the execution of the query (especially in terms of timeout and a limit on the number of results). For details please consult output module documentation.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_xml_in_job_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param bool validation_enabled: Determines if the ViewConfig’s syntax should be validated (<code>true</code>) or not (<code>false</code>). Validation is then performed immediately instead of only when the job is started. Please note that the validation will always take place during the Job execution, regardless of this parameter. Default value is false.
        :param str file_name: The name of the file. By default the file name will be generated.
        :param str body: The JSON/YAML representation of ViewConfig that describes the query to be performed.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Job, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'validation_enabled',
            'file_name',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_xml_in_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'validation_enabled' in local_var_params and local_var_params['validation_enabled'] is not None:  # noqa: E501
            query_params.append(('validationEnabled', local_var_params['validation_enabled']))  # noqa: E501
        if 'file_name' in local_var_params and local_var_params['file_name'] is not None:  # noqa: E501
            query_params.append(('fileName', local_var_params['file_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-yaml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/outputModule/export/xml-job', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Job',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_xml_to_file(self, **kwargs):  # noqa: E501
        """Exports results in XML format, returns information about created file.  # noqa: E501

        <p>Performs an Output Module query and stores the query results in a file in XML format. The id of the file is returned in the response.</p><p>Please note that the ViewConfig's syntax validation is not executed by default, see <code>validationEnabled</code></p><p>DGC admin console settings may impact the execution of the query (especially in terms of timeout and a limit on the number of results). For details please consult output module documentation.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_xml_to_file(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param bool validation_enabled: Determines if the ViewConfig’s syntax should be validated (<code>true</code>) or not (<code>false</code>). Default value is false for backward compatibility reasons but it is strongly advised to always enable this validation.
        :param str file_name: The name of the file. By default the file name will be generated.
        :param str body: The JSON/YAML representation of ViewConfig that describes the query to be performed.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileInfoImpl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.export_xml_to_file_with_http_info(**kwargs)  # noqa: E501

    def export_xml_to_file_with_http_info(self, **kwargs):  # noqa: E501
        """Exports results in XML format, returns information about created file.  # noqa: E501

        <p>Performs an Output Module query and stores the query results in a file in XML format. The id of the file is returned in the response.</p><p>Please note that the ViewConfig's syntax validation is not executed by default, see <code>validationEnabled</code></p><p>DGC admin console settings may impact the execution of the query (especially in terms of timeout and a limit on the number of results). For details please consult output module documentation.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_xml_to_file_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param bool validation_enabled: Determines if the ViewConfig’s syntax should be validated (<code>true</code>) or not (<code>false</code>). Default value is false for backward compatibility reasons but it is strongly advised to always enable this validation.
        :param str file_name: The name of the file. By default the file name will be generated.
        :param str body: The JSON/YAML representation of ViewConfig that describes the query to be performed.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileInfoImpl, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'validation_enabled',
            'file_name',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_xml_to_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'validation_enabled' in local_var_params and local_var_params['validation_enabled'] is not None:  # noqa: E501
            query_params.append(('validationEnabled', local_var_params['validation_enabled']))  # noqa: E501
        if 'file_name' in local_var_params and local_var_params['file_name'] is not None:  # noqa: E501
            query_params.append(('fileName', local_var_params['file_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-yaml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/outputModule/export/xml-file', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileInfoImpl',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_table_view_config_by_view_id(self, view_id, **kwargs):  # noqa: E501
        """Returns TableViewConfig based on id of given View and its Location.  # noqa: E501

        <b>EXPERIMENTAL</b> Returns Table View Config based on id of given View and its Location. This Table View Config can be used by Output Module to export data as visible in Collibra Data Governance Center User Interface.<p>This endpoint does not guarantee a one-to-one relation between what is visible in the User Interface and what will be exported by using the provided Table View Config. Due to the possibility of adding additional filters through User Interface the result can contain more rows then are visible in the User Interface. In such case the Table View Config produced by this endpoint should be manually adjusted. <p><b>Because obtaining the correct results needs a human intervention, this endpoint should not be used in any kind of automatic processing.</b><p>Example: given page under url https://dgc.collibra.com/glossary?view=133f7f30-033c-4e38-acc2-2c1ac599d19e the view <code>id</code> is <code>133f7f30-033c-4e38-acc2-2c1ac599d19e</code>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_table_view_config_by_view_id(view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str view_id: The <code>id</code> of given View. Can be obtained from Collibra Data Governance Center User Interface (required)
        :param str view_location: The Location for which the view shall be generated.Views in Collibra Data Governance Center are available under specific locations.Each location is associated with set of filters that are automatically applied to given view.Setting appropriate View Location will produce Table View Config that describes the data seen under desired location and given View in the best way possible.If this field is not provided then the returned Table View Config is going to have additional filters applied based on viewLocation extracted from database.`  <table><tr><th>viewLocation value </th><th> Corresponding view in Collibra Data Governance Center User Interface</th></tr><tr><td>BUSINESS_GLOSSARY_BUSINESS_ASSETS </td><td> Business Glossary Subpages: Business Assets (/glossary)Glossaries (/glossary/glossaries)</td></tr><tr><td>REFERENCE_DATA_CODEVALUES_AND_SETS </td><td> Reference Data > Code Values/Sets (/reference-data)</td></tr><tr><td>CATALOG_DATA_SETS </td><td> Catalog > Data Sets (/catalog/data-sets)</td><td><tr><td>CATALOG_DATA_DICTIONARY </td><td> Catalog > Data Dictionary (/catalog/data-dictionary)</td></tr><tr><td>CATALOG_TECHNOLOGY_ASSETS </td><td> Catalog > Technology Assets (/catalog/technology-assets)</td></tr><tr><td>DATA_HELPDESK_ISSUES </td><td> Data Helpdesk Subpages: Issues(/data-helpdesk)>Data Quality (/data-helpdesk/data-quality)</td></tr><tr><td>STEWARDSHIP_BUSINESS_DIMENSIONS </td><td> Stewardship > Business Dimensions (/stewardship/business-dimensions)</td></tr><tr><td>POLICY_MANAGER_GOVERNANCE_ASSETS </td><td> Policy Manager > Governance Assets (/policy-manager)</td></tr></table>
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_table_view_config_by_view_id_with_http_info(view_id, **kwargs)  # noqa: E501

    def get_table_view_config_by_view_id_with_http_info(self, view_id, **kwargs):  # noqa: E501
        """Returns TableViewConfig based on id of given View and its Location.  # noqa: E501

        <b>EXPERIMENTAL</b> Returns Table View Config based on id of given View and its Location. This Table View Config can be used by Output Module to export data as visible in Collibra Data Governance Center User Interface.<p>This endpoint does not guarantee a one-to-one relation between what is visible in the User Interface and what will be exported by using the provided Table View Config. Due to the possibility of adding additional filters through User Interface the result can contain more rows then are visible in the User Interface. In such case the Table View Config produced by this endpoint should be manually adjusted. <p><b>Because obtaining the correct results needs a human intervention, this endpoint should not be used in any kind of automatic processing.</b><p>Example: given page under url https://dgc.collibra.com/glossary?view=133f7f30-033c-4e38-acc2-2c1ac599d19e the view <code>id</code> is <code>133f7f30-033c-4e38-acc2-2c1ac599d19e</code>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_table_view_config_by_view_id_with_http_info(view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str view_id: The <code>id</code> of given View. Can be obtained from Collibra Data Governance Center User Interface (required)
        :param str view_location: The Location for which the view shall be generated.Views in Collibra Data Governance Center are available under specific locations.Each location is associated with set of filters that are automatically applied to given view.Setting appropriate View Location will produce Table View Config that describes the data seen under desired location and given View in the best way possible.If this field is not provided then the returned Table View Config is going to have additional filters applied based on viewLocation extracted from database.`  <table><tr><th>viewLocation value </th><th> Corresponding view in Collibra Data Governance Center User Interface</th></tr><tr><td>BUSINESS_GLOSSARY_BUSINESS_ASSETS </td><td> Business Glossary Subpages: Business Assets (/glossary)Glossaries (/glossary/glossaries)</td></tr><tr><td>REFERENCE_DATA_CODEVALUES_AND_SETS </td><td> Reference Data > Code Values/Sets (/reference-data)</td></tr><tr><td>CATALOG_DATA_SETS </td><td> Catalog > Data Sets (/catalog/data-sets)</td><td><tr><td>CATALOG_DATA_DICTIONARY </td><td> Catalog > Data Dictionary (/catalog/data-dictionary)</td></tr><tr><td>CATALOG_TECHNOLOGY_ASSETS </td><td> Catalog > Technology Assets (/catalog/technology-assets)</td></tr><tr><td>DATA_HELPDESK_ISSUES </td><td> Data Helpdesk Subpages: Issues(/data-helpdesk)>Data Quality (/data-helpdesk/data-quality)</td></tr><tr><td>STEWARDSHIP_BUSINESS_DIMENSIONS </td><td> Stewardship > Business Dimensions (/stewardship/business-dimensions)</td></tr><tr><td>POLICY_MANAGER_GOVERNANCE_ASSETS </td><td> Policy Manager > Governance Assets (/policy-manager)</td></tr></table>
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'view_id',
            'view_location'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_table_view_config_by_view_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['view_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `view_id` when calling `get_table_view_config_by_view_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'view_id' in local_var_params:
            path_params['viewId'] = local_var_params['view_id']  # noqa: E501

        query_params = []
        if 'view_location' in local_var_params and local_var_params['view_location'] is not None:  # noqa: E501
            query_params.append(('viewLocation', local_var_params['view_location']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/outputModule/tableViewConfigs/viewId/{viewId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
