# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from collibra_core.api_client import ApiClient
from collibra_core.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class MappingsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_mapping(self, **kwargs):  # noqa: E501
        """Adds a new mapping.  # noqa: E501

        Adds a new mapping.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_mapping(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param AddMappingRequest add_mapping_request: The properties of the mapping to be added.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Mapping
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.add_mapping_with_http_info(**kwargs)  # noqa: E501

    def add_mapping_with_http_info(self, **kwargs):  # noqa: E501
        """Adds a new mapping.  # noqa: E501

        Adds a new mapping.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_mapping_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param AddMappingRequest add_mapping_request: The properties of the mapping to be added.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Mapping, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'add_mapping_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_mapping" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_mapping_request' in local_var_params:
            body_params = local_var_params['add_mapping_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mappings', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Mapping',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_mappings(self, **kwargs):  # noqa: E501
        """Adds new mappings.  # noqa: E501

        Adds new mappings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_mappings(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[AddMappingRequest] add_mapping_request: The properties of the mappings to be added.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Mapping]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.add_mappings_with_http_info(**kwargs)  # noqa: E501

    def add_mappings_with_http_info(self, **kwargs):  # noqa: E501
        """Adds new mappings.  # noqa: E501

        Adds new mappings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_mappings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[AddMappingRequest] add_mapping_request: The properties of the mappings to be added.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Mapping], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'add_mapping_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_mappings" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_mapping_request' in local_var_params:
            body_params = local_var_params['add_mapping_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mappings/bulk', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Mapping]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def change_mapping(self, mapping_id, **kwargs):  # noqa: E501
        """Changes the mapping identified by its id.  # noqa: E501

        Changes the mapping identified by its <code>id</code>.<p>Change the mapping identified by its <code>id</code> with the information that is present in the request. Only properties that are specified in this request and have not <code>null</code> values are updated. All other properties are ignored.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_mapping(mapping_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str mapping_id: The ID of the mapping to be changed. (required)
        :param ChangeMappingRequest change_mapping_request: The properties of the mapping to be changed.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Mapping
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.change_mapping_with_http_info(mapping_id, **kwargs)  # noqa: E501

    def change_mapping_with_http_info(self, mapping_id, **kwargs):  # noqa: E501
        """Changes the mapping identified by its id.  # noqa: E501

        Changes the mapping identified by its <code>id</code>.<p>Change the mapping identified by its <code>id</code> with the information that is present in the request. Only properties that are specified in this request and have not <code>null</code> values are updated. All other properties are ignored.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_mapping_with_http_info(mapping_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str mapping_id: The ID of the mapping to be changed. (required)
        :param ChangeMappingRequest change_mapping_request: The properties of the mapping to be changed.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Mapping, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'mapping_id',
            'change_mapping_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method change_mapping" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'mapping_id' is set
        if self.api_client.client_side_validation and ('mapping_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['mapping_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `mapping_id` when calling `change_mapping`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mapping_id' in local_var_params:
            path_params['mappingId'] = local_var_params['mapping_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'change_mapping_request' in local_var_params:
            body_params = local_var_params['change_mapping_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mappings/{mappingId}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Mapping',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def change_mapping_by_external_entity(self, external_system_id, external_entity_id, **kwargs):  # noqa: E501
        """Changes the mapping identified by its external ids.  # noqa: E501

        Changes the mapping identified by its external <code>id</code>s.<p>Changes the mapping identified by its external <code>id</code>s with the information that is present in the request. Only properties that are specified in this request and have not <code>null</code> values are updated. All other properties are ignored.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_mapping_by_external_entity(external_system_id, external_entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_system_id: The external system ID of the mapping to be changed. (required)
        :param str external_entity_id: The external entity ID of the mapping to be changed. (required)
        :param ChangeMappingByExternalEntityRequest change_mapping_by_external_entity_request: The properties of the mapping to be changed.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Mapping
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.change_mapping_by_external_entity_with_http_info(external_system_id, external_entity_id, **kwargs)  # noqa: E501

    def change_mapping_by_external_entity_with_http_info(self, external_system_id, external_entity_id, **kwargs):  # noqa: E501
        """Changes the mapping identified by its external ids.  # noqa: E501

        Changes the mapping identified by its external <code>id</code>s.<p>Changes the mapping identified by its external <code>id</code>s with the information that is present in the request. Only properties that are specified in this request and have not <code>null</code> values are updated. All other properties are ignored.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_mapping_by_external_entity_with_http_info(external_system_id, external_entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_system_id: The external system ID of the mapping to be changed. (required)
        :param str external_entity_id: The external entity ID of the mapping to be changed. (required)
        :param ChangeMappingByExternalEntityRequest change_mapping_by_external_entity_request: The properties of the mapping to be changed.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Mapping, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'external_system_id',
            'external_entity_id',
            'change_mapping_by_external_entity_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method change_mapping_by_external_entity" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'external_system_id' is set
        if self.api_client.client_side_validation and ('external_system_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['external_system_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_system_id` when calling `change_mapping_by_external_entity`")  # noqa: E501
        # verify the required parameter 'external_entity_id' is set
        if self.api_client.client_side_validation and ('external_entity_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['external_entity_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_entity_id` when calling `change_mapping_by_external_entity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'external_system_id' in local_var_params:
            path_params['externalSystemId'] = local_var_params['external_system_id']  # noqa: E501
        if 'external_entity_id' in local_var_params:
            path_params['externalEntityId'] = local_var_params['external_entity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'change_mapping_by_external_entity_request' in local_var_params:
            body_params = local_var_params['change_mapping_by_external_entity_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mappings/externalSystem/{externalSystemId}/externalEntity/{externalEntityId}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Mapping',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def change_mapping_by_mapped_resource(self, external_system_id, mapped_resource_id, **kwargs):  # noqa: E501
        """Changes the mapping identified by its external system id and mapped resource id.  # noqa: E501

        Changes the mapping identified by its external system <code>id</code> and mapped resource <code>id</code>.<p>Changes the mapping identified by its external system <code>id</code> and mapped resource <code>id</code> with the information that is present in the requests. Only properties that are specified in this request and have not <code>null</code> values are updated. All other properties are ignored.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_mapping_by_mapped_resource(external_system_id, mapped_resource_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_system_id: The external system id of the mapping to be changed. (required)
        :param str mapped_resource_id: The mapped resource id of the mapping to be changed. (required)
        :param ChangeMappingByMappedResourceRequest change_mapping_by_mapped_resource_request: The properties of the mapping to be changed.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Mapping
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.change_mapping_by_mapped_resource_with_http_info(external_system_id, mapped_resource_id, **kwargs)  # noqa: E501

    def change_mapping_by_mapped_resource_with_http_info(self, external_system_id, mapped_resource_id, **kwargs):  # noqa: E501
        """Changes the mapping identified by its external system id and mapped resource id.  # noqa: E501

        Changes the mapping identified by its external system <code>id</code> and mapped resource <code>id</code>.<p>Changes the mapping identified by its external system <code>id</code> and mapped resource <code>id</code> with the information that is present in the requests. Only properties that are specified in this request and have not <code>null</code> values are updated. All other properties are ignored.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_mapping_by_mapped_resource_with_http_info(external_system_id, mapped_resource_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_system_id: The external system id of the mapping to be changed. (required)
        :param str mapped_resource_id: The mapped resource id of the mapping to be changed. (required)
        :param ChangeMappingByMappedResourceRequest change_mapping_by_mapped_resource_request: The properties of the mapping to be changed.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Mapping, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'external_system_id',
            'mapped_resource_id',
            'change_mapping_by_mapped_resource_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method change_mapping_by_mapped_resource" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'external_system_id' is set
        if self.api_client.client_side_validation and ('external_system_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['external_system_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_system_id` when calling `change_mapping_by_mapped_resource`")  # noqa: E501
        # verify the required parameter 'mapped_resource_id' is set
        if self.api_client.client_side_validation and ('mapped_resource_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['mapped_resource_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `mapped_resource_id` when calling `change_mapping_by_mapped_resource`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'external_system_id' in local_var_params:
            path_params['externalSystemId'] = local_var_params['external_system_id']  # noqa: E501
        if 'mapped_resource_id' in local_var_params:
            path_params['mappedResourceId'] = local_var_params['mapped_resource_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'change_mapping_by_mapped_resource_request' in local_var_params:
            body_params = local_var_params['change_mapping_by_mapped_resource_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mappings/externalSystem/{externalSystemId}/mappedResource/{mappedResourceId}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Mapping',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def change_mappings(self, **kwargs):  # noqa: E501
        """Changes multiple mappings identified by their ids.  # noqa: E501

        Changes multiple mappings identified by their <code>id</code>s.<p>Change the mappings identified by its <code>id</code>s with the information that is present in the requests. Only properties that are specified in these requests and have not <code>null</code> values are updated. All other properties are ignored.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_mappings(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[ChangeMappingRequest] change_mapping_request: The properties of the mappings to be changed.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Mapping]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.change_mappings_with_http_info(**kwargs)  # noqa: E501

    def change_mappings_with_http_info(self, **kwargs):  # noqa: E501
        """Changes multiple mappings identified by their ids.  # noqa: E501

        Changes multiple mappings identified by their <code>id</code>s.<p>Change the mappings identified by its <code>id</code>s with the information that is present in the requests. Only properties that are specified in these requests and have not <code>null</code> values are updated. All other properties are ignored.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_mappings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[ChangeMappingRequest] change_mapping_request: The properties of the mappings to be changed.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Mapping], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'change_mapping_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method change_mappings" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'change_mapping_request' in local_var_params:
            body_params = local_var_params['change_mapping_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mappings/bulk', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Mapping]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def change_mappings_by_external_entities(self, **kwargs):  # noqa: E501
        """Changes the mappings identified by their external ids.  # noqa: E501

        Changes the mappings identified by their external <code>id</code>s.<p>Changes the mappings identified by their external <code>id</code>s with the information that is present in the requests. Only properties that are specified in these requests and have not <code>null</code> values are updated. All other properties are ignored.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_mappings_by_external_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[ChangeMappingByExternalEntityRequest] change_mapping_by_external_entity_request: The properties of the mappings to be changed.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Mapping]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.change_mappings_by_external_entities_with_http_info(**kwargs)  # noqa: E501

    def change_mappings_by_external_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Changes the mappings identified by their external ids.  # noqa: E501

        Changes the mappings identified by their external <code>id</code>s.<p>Changes the mappings identified by their external <code>id</code>s with the information that is present in the requests. Only properties that are specified in these requests and have not <code>null</code> values are updated. All other properties are ignored.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_mappings_by_external_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[ChangeMappingByExternalEntityRequest] change_mapping_by_external_entity_request: The properties of the mappings to be changed.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Mapping], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'change_mapping_by_external_entity_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method change_mappings_by_external_entities" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'change_mapping_by_external_entity_request' in local_var_params:
            body_params = local_var_params['change_mapping_by_external_entity_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mappings/externalSystem/externalEntity/bulk', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Mapping]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def change_mappings_by_mapped_resources(self, **kwargs):  # noqa: E501
        """Changes the mapping identified by their external system ids and mapped resource ids.  # noqa: E501

        Changes the mapping identified by their external system <code>id</code>s and mapped resource <code>id</code>s.<p>Changes the mapping identified by their external system <code>id</code>s and mapped resource <code>id</code>s with the information that is present in the requests. Only properties that are specified in these requests and have not <code>null</code> values are updated. All other properties are ignored.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_mappings_by_mapped_resources(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[ChangeMappingByMappedResourceRequest] change_mapping_by_mapped_resource_request: The properties of the mappings to be changed.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Mapping]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.change_mappings_by_mapped_resources_with_http_info(**kwargs)  # noqa: E501

    def change_mappings_by_mapped_resources_with_http_info(self, **kwargs):  # noqa: E501
        """Changes the mapping identified by their external system ids and mapped resource ids.  # noqa: E501

        Changes the mapping identified by their external system <code>id</code>s and mapped resource <code>id</code>s.<p>Changes the mapping identified by their external system <code>id</code>s and mapped resource <code>id</code>s with the information that is present in the requests. Only properties that are specified in these requests and have not <code>null</code> values are updated. All other properties are ignored.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_mappings_by_mapped_resources_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[ChangeMappingByMappedResourceRequest] change_mapping_by_mapped_resource_request: The properties of the mappings to be changed.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Mapping], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'change_mapping_by_mapped_resource_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method change_mappings_by_mapped_resources" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'change_mapping_by_mapped_resource_request' in local_var_params:
            body_params = local_var_params['change_mapping_by_mapped_resource_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mappings/externalSystem/mappedResource/bulk', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Mapping]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_mappings(self, **kwargs):  # noqa: E501
        """Returns mappings matching the given search criteria.  # noqa: E501

        Returns mappings matching the given search criteria.<p>Only parameters that are specified in this request and have not <code>null</code> values are used for filtering. All other parameters are ignored.</p>The returned synchronization information satisfies all constraints that are specified in this search criteria. By default a result containing 1000 mappings is returned.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_mappings(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int offset: The first result to retrieve. If not set (offset = <code>0</code>), results will be retrieved starting from row <code>0</code>.
        :param int limit: The maximum number of results to retrieve. If not set (limit = <code>0</code>), the default limit will be used.
        :param int count_limit: Allows to limit the number of elements that will be counted. -1 will count everything and 0 will cause the count to be skipped
        :param str external_system_id: The ID of the external system that the mapped resource belongs to.
        :param str mapped_resource_type: The type of the mapped resource.
        :param str sync_action: The type of the action performed during last successful synchronization.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: MappingPagedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.find_mappings_with_http_info(**kwargs)  # noqa: E501

    def find_mappings_with_http_info(self, **kwargs):  # noqa: E501
        """Returns mappings matching the given search criteria.  # noqa: E501

        Returns mappings matching the given search criteria.<p>Only parameters that are specified in this request and have not <code>null</code> values are used for filtering. All other parameters are ignored.</p>The returned synchronization information satisfies all constraints that are specified in this search criteria. By default a result containing 1000 mappings is returned.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_mappings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int offset: The first result to retrieve. If not set (offset = <code>0</code>), results will be retrieved starting from row <code>0</code>.
        :param int limit: The maximum number of results to retrieve. If not set (limit = <code>0</code>), the default limit will be used.
        :param int count_limit: Allows to limit the number of elements that will be counted. -1 will count everything and 0 will cause the count to be skipped
        :param str external_system_id: The ID of the external system that the mapped resource belongs to.
        :param str mapped_resource_type: The type of the mapped resource.
        :param str sync_action: The type of the action performed during last successful synchronization.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(MappingPagedResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'offset',
            'limit',
            'count_limit',
            'external_system_id',
            'mapped_resource_type',
            'sync_action'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_mappings" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and ('external_system_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['external_system_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `external_system_id` when calling `find_mappings`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('external_system_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['external_system_id']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `external_system_id` when calling `find_mappings`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'count_limit' in local_var_params and local_var_params['count_limit'] is not None:  # noqa: E501
            query_params.append(('countLimit', local_var_params['count_limit']))  # noqa: E501
        if 'external_system_id' in local_var_params and local_var_params['external_system_id'] is not None:  # noqa: E501
            query_params.append(('externalSystemId', local_var_params['external_system_id']))  # noqa: E501
        if 'mapped_resource_type' in local_var_params and local_var_params['mapped_resource_type'] is not None:  # noqa: E501
            query_params.append(('mappedResourceType', local_var_params['mapped_resource_type']))  # noqa: E501
        if 'sync_action' in local_var_params and local_var_params['sync_action'] is not None:  # noqa: E501
            query_params.append(('syncAction', local_var_params['sync_action']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mappings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MappingPagedResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_mapping(self, mapping_id, **kwargs):  # noqa: E501
        """Returns a mapping identified by given id.  # noqa: E501

        Returns a mapping identified by given <code>id</code>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mapping(mapping_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str mapping_id: The id of the mapping. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Mapping
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_mapping_with_http_info(mapping_id, **kwargs)  # noqa: E501

    def get_mapping_with_http_info(self, mapping_id, **kwargs):  # noqa: E501
        """Returns a mapping identified by given id.  # noqa: E501

        Returns a mapping identified by given <code>id</code>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mapping_with_http_info(mapping_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str mapping_id: The id of the mapping. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Mapping, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'mapping_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mapping" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'mapping_id' is set
        if self.api_client.client_side_validation and ('mapping_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['mapping_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `mapping_id` when calling `get_mapping`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mapping_id' in local_var_params:
            path_params['mappingId'] = local_var_params['mapping_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mappings/{mappingId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Mapping',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_mapping_by_external_entity(self, external_system_id, external_entity_id, **kwargs):  # noqa: E501
        """Returns a mapping identified by its external ids.  # noqa: E501

        Returns a mapping identified by its external <code>id</code>s.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mapping_by_external_entity(external_system_id, external_entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_system_id: (required)
        :param str external_entity_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Mapping
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_mapping_by_external_entity_with_http_info(external_system_id, external_entity_id, **kwargs)  # noqa: E501

    def get_mapping_by_external_entity_with_http_info(self, external_system_id, external_entity_id, **kwargs):  # noqa: E501
        """Returns a mapping identified by its external ids.  # noqa: E501

        Returns a mapping identified by its external <code>id</code>s.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mapping_by_external_entity_with_http_info(external_system_id, external_entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_system_id: (required)
        :param str external_entity_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Mapping, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'external_system_id',
            'external_entity_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mapping_by_external_entity" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'external_system_id' is set
        if self.api_client.client_side_validation and ('external_system_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['external_system_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_system_id` when calling `get_mapping_by_external_entity`")  # noqa: E501
        # verify the required parameter 'external_entity_id' is set
        if self.api_client.client_side_validation and ('external_entity_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['external_entity_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_entity_id` when calling `get_mapping_by_external_entity`")  # noqa: E501

        if self.api_client.client_side_validation and ('external_system_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['external_system_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `external_system_id` when calling `get_mapping_by_external_entity`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('external_system_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['external_system_id']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `external_system_id` when calling `get_mapping_by_external_entity`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('external_entity_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['external_entity_id']) > 255):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `external_entity_id` when calling `get_mapping_by_external_entity`, length must be less than or equal to `255`")  # noqa: E501
        if self.api_client.client_side_validation and ('external_entity_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['external_entity_id']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `external_entity_id` when calling `get_mapping_by_external_entity`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'external_system_id' in local_var_params:
            path_params['externalSystemId'] = local_var_params['external_system_id']  # noqa: E501
        if 'external_entity_id' in local_var_params:
            path_params['externalEntityId'] = local_var_params['external_entity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mappings/externalSystem/{externalSystemId}/externalEntity/{externalEntityId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Mapping',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_mapping_by_mapped_resource(self, external_system_id, mapped_resource_id, **kwargs):  # noqa: E501
        """Returns a mapping identified by its external system id and mapped resource id.  # noqa: E501

        Returns a mapping identified by its external system <code>id</code> and mapped resource <code>id</code>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mapping_by_mapped_resource(external_system_id, mapped_resource_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_system_id: (required)
        :param str mapped_resource_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Mapping
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_mapping_by_mapped_resource_with_http_info(external_system_id, mapped_resource_id, **kwargs)  # noqa: E501

    def get_mapping_by_mapped_resource_with_http_info(self, external_system_id, mapped_resource_id, **kwargs):  # noqa: E501
        """Returns a mapping identified by its external system id and mapped resource id.  # noqa: E501

        Returns a mapping identified by its external system <code>id</code> and mapped resource <code>id</code>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mapping_by_mapped_resource_with_http_info(external_system_id, mapped_resource_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_system_id: (required)
        :param str mapped_resource_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Mapping, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'external_system_id',
            'mapped_resource_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mapping_by_mapped_resource" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'external_system_id' is set
        if self.api_client.client_side_validation and ('external_system_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['external_system_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_system_id` when calling `get_mapping_by_mapped_resource`")  # noqa: E501
        # verify the required parameter 'mapped_resource_id' is set
        if self.api_client.client_side_validation and ('mapped_resource_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['mapped_resource_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `mapped_resource_id` when calling `get_mapping_by_mapped_resource`")  # noqa: E501

        if self.api_client.client_side_validation and ('external_system_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['external_system_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `external_system_id` when calling `get_mapping_by_mapped_resource`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('external_system_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['external_system_id']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `external_system_id` when calling `get_mapping_by_mapped_resource`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'external_system_id' in local_var_params:
            path_params['externalSystemId'] = local_var_params['external_system_id']  # noqa: E501
        if 'mapped_resource_id' in local_var_params:
            path_params['mappedResourceId'] = local_var_params['mapped_resource_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mappings/externalSystem/{externalSystemId}/mappedResource/{mappedResourceId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Mapping',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_mapping(self, mapping_id, **kwargs):  # noqa: E501
        """Removes the mapping identified by its id.  # noqa: E501

        Removes the mapping identified by its <code>id</code>.<p>If the mapping does not exist, an exception is NOT thrown.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_mapping(mapping_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str mapping_id: The id of the mapping. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_mapping_with_http_info(mapping_id, **kwargs)  # noqa: E501

    def remove_mapping_with_http_info(self, mapping_id, **kwargs):  # noqa: E501
        """Removes the mapping identified by its id.  # noqa: E501

        Removes the mapping identified by its <code>id</code>.<p>If the mapping does not exist, an exception is NOT thrown.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_mapping_with_http_info(mapping_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str mapping_id: The id of the mapping. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'mapping_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_mapping" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'mapping_id' is set
        if self.api_client.client_side_validation and ('mapping_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['mapping_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `mapping_id` when calling `remove_mapping`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mapping_id' in local_var_params:
            path_params['mappingId'] = local_var_params['mapping_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mappings/{mappingId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_mapping_by_external_entity(self, external_system_id, external_entity_id, **kwargs):  # noqa: E501
        """Removes the mapping identified by its external ids.  # noqa: E501

        Removes the mapping identified by its external <code>id</code>s.<p>If the mapping does not exist, an exception is NOT thrown.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_mapping_by_external_entity(external_system_id, external_entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_system_id: The external system id of the mapping to be removed. (required)
        :param str external_entity_id: The external entity id of the mapping to be removed. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_mapping_by_external_entity_with_http_info(external_system_id, external_entity_id, **kwargs)  # noqa: E501

    def remove_mapping_by_external_entity_with_http_info(self, external_system_id, external_entity_id, **kwargs):  # noqa: E501
        """Removes the mapping identified by its external ids.  # noqa: E501

        Removes the mapping identified by its external <code>id</code>s.<p>If the mapping does not exist, an exception is NOT thrown.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_mapping_by_external_entity_with_http_info(external_system_id, external_entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_system_id: The external system id of the mapping to be removed. (required)
        :param str external_entity_id: The external entity id of the mapping to be removed. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'external_system_id',
            'external_entity_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_mapping_by_external_entity" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'external_system_id' is set
        if self.api_client.client_side_validation and ('external_system_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['external_system_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_system_id` when calling `remove_mapping_by_external_entity`")  # noqa: E501
        # verify the required parameter 'external_entity_id' is set
        if self.api_client.client_side_validation and ('external_entity_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['external_entity_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_entity_id` when calling `remove_mapping_by_external_entity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'external_system_id' in local_var_params:
            path_params['externalSystemId'] = local_var_params['external_system_id']  # noqa: E501
        if 'external_entity_id' in local_var_params:
            path_params['externalEntityId'] = local_var_params['external_entity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mappings/externalSystem/{externalSystemId}/externalEntity/{externalEntityId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_mapping_by_mapped_resource(self, external_system_id, mapped_resource_id, **kwargs):  # noqa: E501
        """Removes the mapping identified by its external system id and mapped resource id.  # noqa: E501

        Removes the mapping identified by its external system <code>id</code> and mapped resource <code>id</code>.<p>If the mapping does not exist, an exception is NOT thrown.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_mapping_by_mapped_resource(external_system_id, mapped_resource_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_system_id: The external system id of the mapping to be changed. (required)
        :param str mapped_resource_id: The mapped resource id of the mapping to be changed. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_mapping_by_mapped_resource_with_http_info(external_system_id, mapped_resource_id, **kwargs)  # noqa: E501

    def remove_mapping_by_mapped_resource_with_http_info(self, external_system_id, mapped_resource_id, **kwargs):  # noqa: E501
        """Removes the mapping identified by its external system id and mapped resource id.  # noqa: E501

        Removes the mapping identified by its external system <code>id</code> and mapped resource <code>id</code>.<p>If the mapping does not exist, an exception is NOT thrown.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_mapping_by_mapped_resource_with_http_info(external_system_id, mapped_resource_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_system_id: The external system id of the mapping to be changed. (required)
        :param str mapped_resource_id: The mapped resource id of the mapping to be changed. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'external_system_id',
            'mapped_resource_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_mapping_by_mapped_resource" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'external_system_id' is set
        if self.api_client.client_side_validation and ('external_system_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['external_system_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_system_id` when calling `remove_mapping_by_mapped_resource`")  # noqa: E501
        # verify the required parameter 'mapped_resource_id' is set
        if self.api_client.client_side_validation and ('mapped_resource_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['mapped_resource_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `mapped_resource_id` when calling `remove_mapping_by_mapped_resource`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'external_system_id' in local_var_params:
            path_params['externalSystemId'] = local_var_params['external_system_id']  # noqa: E501
        if 'mapped_resource_id' in local_var_params:
            path_params['mappedResourceId'] = local_var_params['mapped_resource_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mappings/externalSystem/{externalSystemId}/mappedResource/{mappedResourceId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_mappings_by_external_system_in_job(self, external_system_id, **kwargs):  # noqa: E501
        """Removes all the mappings identified by given external system id.  # noqa: E501

        Removes all the mappings identified by given external system <code>id</code>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_mappings_by_external_system_in_job(external_system_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_system_id: The id of the external system of the mappings that will be removed. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_mappings_by_external_system_in_job_with_http_info(external_system_id, **kwargs)  # noqa: E501

    def remove_mappings_by_external_system_in_job_with_http_info(self, external_system_id, **kwargs):  # noqa: E501
        """Removes all the mappings identified by given external system id.  # noqa: E501

        Removes all the mappings identified by given external system <code>id</code>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_mappings_by_external_system_in_job_with_http_info(external_system_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_system_id: The id of the external system of the mappings that will be removed. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Job, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'external_system_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_mappings_by_external_system_in_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'external_system_id' is set
        if self.api_client.client_side_validation and ('external_system_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['external_system_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_system_id` when calling `remove_mappings_by_external_system_in_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'external_system_id' in local_var_params:
            path_params['externalSystemId'] = local_var_params['external_system_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mappings/externalSystem/{externalSystemId}/removalJobs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Job',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_mappings_in_job(self, **kwargs):  # noqa: E501
        """Removes multiple mappings in job.  # noqa: E501

        Removes multiple mappings in job.<p>If any mapping does not exist, an exception is NOT thrown.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_mappings_in_job(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] request_body: The ids of the mappings to be removed.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_mappings_in_job_with_http_info(**kwargs)  # noqa: E501

    def remove_mappings_in_job_with_http_info(self, **kwargs):  # noqa: E501
        """Removes multiple mappings in job.  # noqa: E501

        Removes multiple mappings in job.<p>If any mapping does not exist, an exception is NOT thrown.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_mappings_in_job_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] request_body: The ids of the mappings to be removed.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Job, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'request_body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_mappings_in_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request_body' in local_var_params:
            body_params = local_var_params['request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mappings/removalJobs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Job',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
