# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from collibra_core.api_client import ApiClient
from collibra_core.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ActivitiesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_activities(self, **kwargs):  # noqa: E501
        """Returns activities matching the given search criteria.  # noqa: E501

        Returns activities matching the given search criteria.Only parameters that are specified in this request and have not <code>null</code> values are used for filtering.All other parameters are ignored.The returned activities satisfy all constraints that are specified in this search criteria.By default a result containing 100 activities is returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activities(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int offset: The first result to retrieve. If not set (offset = <code>0</code>), results will be retrieved starting from row <code>0</code>.
        :param int limit: The maximum number of results to retrieve. If not set (limit = <code>0</code>), the default limit will be used.
        :param int count_limit: Allows to limit the number of elements that will be counted. -1 will count everything and 0 will cause the count to be skipped
        :param str task_id: The ID of the task which contains the basic find activities request.
        :param str context_id: The ID of the context which the activities should be searched for.
        :param list[str] involved_people_ids: The list of IDs of the people that should be involved in searched activities.
        :param list[str] involved_role_ids: The list of IDs of the roles that should be involved in searched activities.
        :param str performed_by_user_id: The ID of the user who performed searched activities.
        :param list[str] performed_by_role_ids: The list of IDs of the roles assigned to users who performed searched activities.
        :param str activity_type: The type of the activity.
        :param str call_id: The ID of the call.
        :param list[str] categories: The set of the categories of activities that should be searched. One of [ATTRIBUTE, ATTACHMENT, RELATION, COMMENT,<br/>STATUS, WORKFLOW, RESPONSIBILITY, USER, USER_GROUP, ROLE, TAGS, OTHERS].
        :param list[str] resource_types: The set of the resource types that searched activities refer to, i.e. [Community, Asset, Domain, Attribute,<br/>Relation, WorkflowInstance].
        :param int start_date: TThe start date of the searched activities. It is the timestamp (in UTC time standard).
        :param int end_date: The end date of the searched activities. It is the timestamp (in UTC time standard).
        :param bool call_count_enabled: Flag to indicate if the number of calls standing behind the activity should be returned or not.<br/>Note that by default that count will be not calculated as it brings an important performance penalty.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ActivityPagedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_activities_with_http_info(**kwargs)  # noqa: E501

    def get_activities_with_http_info(self, **kwargs):  # noqa: E501
        """Returns activities matching the given search criteria.  # noqa: E501

        Returns activities matching the given search criteria.Only parameters that are specified in this request and have not <code>null</code> values are used for filtering.All other parameters are ignored.The returned activities satisfy all constraints that are specified in this search criteria.By default a result containing 100 activities is returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int offset: The first result to retrieve. If not set (offset = <code>0</code>), results will be retrieved starting from row <code>0</code>.
        :param int limit: The maximum number of results to retrieve. If not set (limit = <code>0</code>), the default limit will be used.
        :param int count_limit: Allows to limit the number of elements that will be counted. -1 will count everything and 0 will cause the count to be skipped
        :param str task_id: The ID of the task which contains the basic find activities request.
        :param str context_id: The ID of the context which the activities should be searched for.
        :param list[str] involved_people_ids: The list of IDs of the people that should be involved in searched activities.
        :param list[str] involved_role_ids: The list of IDs of the roles that should be involved in searched activities.
        :param str performed_by_user_id: The ID of the user who performed searched activities.
        :param list[str] performed_by_role_ids: The list of IDs of the roles assigned to users who performed searched activities.
        :param str activity_type: The type of the activity.
        :param str call_id: The ID of the call.
        :param list[str] categories: The set of the categories of activities that should be searched. One of [ATTRIBUTE, ATTACHMENT, RELATION, COMMENT,<br/>STATUS, WORKFLOW, RESPONSIBILITY, USER, USER_GROUP, ROLE, TAGS, OTHERS].
        :param list[str] resource_types: The set of the resource types that searched activities refer to, i.e. [Community, Asset, Domain, Attribute,<br/>Relation, WorkflowInstance].
        :param int start_date: TThe start date of the searched activities. It is the timestamp (in UTC time standard).
        :param int end_date: The end date of the searched activities. It is the timestamp (in UTC time standard).
        :param bool call_count_enabled: Flag to indicate if the number of calls standing behind the activity should be returned or not.<br/>Note that by default that count will be not calculated as it brings an important performance penalty.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ActivityPagedResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'offset',
            'limit',
            'count_limit',
            'task_id',
            'context_id',
            'involved_people_ids',
            'involved_role_ids',
            'performed_by_user_id',
            'performed_by_role_ids',
            'activity_type',
            'call_id',
            'categories',
            'resource_types',
            'start_date',
            'end_date',
            'call_count_enabled'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activities" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'count_limit' in local_var_params and local_var_params['count_limit'] is not None:  # noqa: E501
            query_params.append(('countLimit', local_var_params['count_limit']))  # noqa: E501
        if 'task_id' in local_var_params and local_var_params['task_id'] is not None:  # noqa: E501
            query_params.append(('taskId', local_var_params['task_id']))  # noqa: E501
        if 'context_id' in local_var_params and local_var_params['context_id'] is not None:  # noqa: E501
            query_params.append(('contextId', local_var_params['context_id']))  # noqa: E501
        if 'involved_people_ids' in local_var_params and local_var_params['involved_people_ids'] is not None:  # noqa: E501
            query_params.append(('involvedPeopleIds', local_var_params['involved_people_ids']))  # noqa: E501
            collection_formats['involvedPeopleIds'] = 'multi'  # noqa: E501
        if 'involved_role_ids' in local_var_params and local_var_params['involved_role_ids'] is not None:  # noqa: E501
            query_params.append(('involvedRoleIds', local_var_params['involved_role_ids']))  # noqa: E501
            collection_formats['involvedRoleIds'] = 'multi'  # noqa: E501
        if 'performed_by_user_id' in local_var_params and local_var_params['performed_by_user_id'] is not None:  # noqa: E501
            query_params.append(('performedByUserId', local_var_params['performed_by_user_id']))  # noqa: E501
        if 'performed_by_role_ids' in local_var_params and local_var_params['performed_by_role_ids'] is not None:  # noqa: E501
            query_params.append(('performedByRoleIds', local_var_params['performed_by_role_ids']))  # noqa: E501
            collection_formats['performedByRoleIds'] = 'multi'  # noqa: E501
        if 'activity_type' in local_var_params and local_var_params['activity_type'] is not None:  # noqa: E501
            query_params.append(('activityType', local_var_params['activity_type']))  # noqa: E501
        if 'call_id' in local_var_params and local_var_params['call_id'] is not None:  # noqa: E501
            query_params.append(('callId', local_var_params['call_id']))  # noqa: E501
        if 'categories' in local_var_params and local_var_params['categories'] is not None:  # noqa: E501
            query_params.append(('categories', local_var_params['categories']))  # noqa: E501
            collection_formats['categories'] = 'multi'  # noqa: E501
        if 'resource_types' in local_var_params and local_var_params['resource_types'] is not None:  # noqa: E501
            query_params.append(('resourceTypes', local_var_params['resource_types']))  # noqa: E501
            collection_formats['resourceTypes'] = 'multi'  # noqa: E501
        if 'start_date' in local_var_params and local_var_params['start_date'] is not None:  # noqa: E501
            query_params.append(('startDate', local_var_params['start_date']))  # noqa: E501
        if 'end_date' in local_var_params and local_var_params['end_date'] is not None:  # noqa: E501
            query_params.append(('endDate', local_var_params['end_date']))  # noqa: E501
        if 'call_count_enabled' in local_var_params and local_var_params['call_count_enabled'] is not None:  # noqa: E501
            query_params.append(('callCountEnabled', local_var_params['call_count_enabled']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/activities', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ActivityPagedResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
