# collibra-core
<p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import collibra_core
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import collibra_core
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import collibra_core
from collibra_core.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rest/2.0
# See configuration.py for a list of all supported configuration parameters.
configuration = collibra_core.Configuration(
    host = "http://localhost/rest/2.0"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: basicAuth
configuration = collibra_core.Configuration(
    username = 'YOUR_USERNAME',
    password = 'YOUR_PASSWORD'
)

# Configure Bearer authorization (JWT): bearerAuth
configuration = collibra_core.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with collibra_core.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = collibra_core.ActivitiesApi(api_client)
    offset = 0 # int | The first result to retrieve. If not set (offset = <code>0</code>), results will be retrieved starting from row <code>0</code>. (optional) (default to 0)
limit = 0 # int | The maximum number of results to retrieve. If not set (limit = <code>0</code>), the default limit will be used. (optional) (default to 0)
count_limit = -1 # int | Allows to limit the number of elements that will be counted. -1 will count everything and 0 will cause the count to be skipped (optional) (default to -1)
task_id = 'task_id_example' # str | The ID of the task which contains the basic find activities request. (optional)
context_id = 'context_id_example' # str | The ID of the context which the activities should be searched for. (optional)
involved_people_ids = ['involved_people_ids_example'] # list[str] | The list of IDs of the people that should be involved in searched activities. (optional)
involved_role_ids = ['involved_role_ids_example'] # list[str] | The list of IDs of the roles that should be involved in searched activities. (optional)
performed_by_user_id = 'performed_by_user_id_example' # str | The ID of the user who performed searched activities. (optional)
performed_by_role_ids = ['performed_by_role_ids_example'] # list[str] | The list of IDs of the roles assigned to users who performed searched activities. (optional)
activity_type = 'activity_type_example' # str | The type of the activity. (optional)
call_id = 'call_id_example' # str | The ID of the call. (optional)
categories = ['categories_example'] # list[str] | The set of the categories of activities that should be searched. One of [ATTRIBUTE, ATTACHMENT, RELATION, COMMENT,<br/>STATUS, WORKFLOW, RESPONSIBILITY, USER, USER_GROUP, ROLE, TAGS, OTHERS]. (optional)
resource_types = ['resource_types_example'] # list[str] | The set of the resource types that searched activities refer to, i.e. [Community, Asset, Domain, Attribute,<br/>Relation, WorkflowInstance]. (optional)
start_date = 56 # int | TThe start date of the searched activities. It is the timestamp (in UTC time standard). (optional)
end_date = 56 # int | The end date of the searched activities. It is the timestamp (in UTC time standard). (optional)
call_count_enabled = False # bool | Flag to indicate if the number of calls standing behind the activity should be returned or not.<br/>Note that by default that count will be not calculated as it brings an important performance penalty. (optional) (default to False)

    try:
        # Returns activities matching the given search criteria.
        api_response = api_instance.get_activities(offset=offset, limit=limit, count_limit=count_limit, task_id=task_id, context_id=context_id, involved_people_ids=involved_people_ids, involved_role_ids=involved_role_ids, performed_by_user_id=performed_by_user_id, performed_by_role_ids=performed_by_role_ids, activity_type=activity_type, call_id=call_id, categories=categories, resource_types=resource_types, start_date=start_date, end_date=end_date, call_count_enabled=call_count_enabled)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ActivitiesApi->get_activities: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/rest/2.0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ActivitiesApi* | [**get_activities**](docs/ActivitiesApi.md#get_activities) | **GET** /activities | Returns activities matching the given search criteria.
*ApplicationApi* | [**get_info**](docs/ApplicationApi.md#get_info) | **GET** /application/info | Returns the basic information about the application.
*AssetTypesApi* | [**add_asset_type**](docs/AssetTypesApi.md#add_asset_type) | **POST** /assetTypes | Add asset type
*AssetTypesApi* | [**add_asset_types**](docs/AssetTypesApi.md#add_asset_types) | **POST** /assetTypes/bulk | Add multiple asset types
*AssetTypesApi* | [**change_asset_type**](docs/AssetTypesApi.md#change_asset_type) | **PATCH** /assetTypes/{assetTypeId} | Change asset type
*AssetTypesApi* | [**change_asset_types**](docs/AssetTypesApi.md#change_asset_types) | **PATCH** /assetTypes/bulk | Change multiple asset types
*AssetTypesApi* | [**find_asset_types**](docs/AssetTypesApi.md#find_asset_types) | **GET** /assetTypes | Find asset types matching criteria
*AssetTypesApi* | [**find_parent_types**](docs/AssetTypesApi.md#find_parent_types) | **GET** /assetTypes/{assetTypeId}/parents | Find parent types
*AssetTypesApi* | [**find_sub_asset_types**](docs/AssetTypesApi.md#find_sub_asset_types) | **GET** /assetTypes/{assetTypeId}/subTypes | Find asset subtypes
*AssetTypesApi* | [**get_asset_type**](docs/AssetTypesApi.md#get_asset_type) | **GET** /assetTypes/{assetTypeId} | Get asset type by ID
*AssetTypesApi* | [**remove_asset_type**](docs/AssetTypesApi.md#remove_asset_type) | **DELETE** /assetTypes/{assetTypeId} | Remove asset type by ID
*AssetTypesApi* | [**remove_asset_types**](docs/AssetTypesApi.md#remove_asset_types) | **DELETE** /assetTypes/bulk | Remove multiple asset types
*AssetsApi* | [**add_asset**](docs/AssetsApi.md#add_asset) | **POST** /assets | Add asset
*AssetsApi* | [**add_assets**](docs/AssetsApi.md#add_assets) | **POST** /assets/bulk | Add multiple assets
*AssetsApi* | [**add_tags_to_asset**](docs/AssetsApi.md#add_tags_to_asset) | **POST** /assets/{assetId}/tags | Add tags
*AssetsApi* | [**change_asset**](docs/AssetsApi.md#change_asset) | **PATCH** /assets/{assetId} | Change asset
*AssetsApi* | [**change_assets**](docs/AssetsApi.md#change_assets) | **PATCH** /assets/bulk | Change multiple assets
*AssetsApi* | [**find_assets**](docs/AssetsApi.md#find_assets) | **GET** /assets | Find assets
*AssetsApi* | [**get_asset**](docs/AssetsApi.md#get_asset) | **GET** /assets/{assetId} | Get asset
*AssetsApi* | [**get_asset_breadcrumb**](docs/AssetsApi.md#get_asset_breadcrumb) | **GET** /assets/{assetId}/breadcrumb | Get asset breadcrumb
*AssetsApi* | [**get_asset_tags**](docs/AssetsApi.md#get_asset_tags) | **GET** /assets/{assetId}/tags | Get asset tags
*AssetsApi* | [**remove_asset**](docs/AssetsApi.md#remove_asset) | **DELETE** /assets/{assetId} | Remove asset
*AssetsApi* | [**remove_assets**](docs/AssetsApi.md#remove_assets) | **DELETE** /assets/bulk | Remove assets
*AssetsApi* | [**remove_tags_from_asset**](docs/AssetsApi.md#remove_tags_from_asset) | **DELETE** /assets/{assetId}/tags | Remove tags
*AssetsApi* | [**set_asset_attributes**](docs/AssetsApi.md#set_asset_attributes) | **PUT** /assets/{assetId}/attributes | Set asset attributes
*AssetsApi* | [**set_asset_relations**](docs/AssetsApi.md#set_asset_relations) | **PUT** /assets/{assetId}/relations | Set asset relations
*AssetsApi* | [**set_asset_responsibilities**](docs/AssetsApi.md#set_asset_responsibilities) | **PUT** /assets/{assetId}/responsibilities | Set asset responsibilities
*AssetsApi* | [**set_tags_for_asset**](docs/AssetsApi.md#set_tags_for_asset) | **PUT** /assets/{assetId}/tags | Set asset tags
*AssignmentsApi* | [**add_assignment**](docs/AssignmentsApi.md#add_assignment) | **POST** /assignments | Adds a new Assignment.
*AssignmentsApi* | [**change_assignment**](docs/AssignmentsApi.md#change_assignment) | **PATCH** /assignments/{assignmentId} | Changes the assignment with the information that is provided in the request.
*AssignmentsApi* | [**find_assignments_for_resource**](docs/AssignmentsApi.md#find_assignments_for_resource) | **GET** /assignments/forResource | Find the assignments where a given resource is assigned.
*AssignmentsApi* | [**get_assignments_for_asset**](docs/AssignmentsApi.md#get_assignments_for_asset) | **GET** /assignments/asset/{assetId} | Returns the Assignment identified by the given Asset.
*AssignmentsApi* | [**get_assignments_for_asset_type**](docs/AssignmentsApi.md#get_assignments_for_asset_type) | **GET** /assignments/assetType/{assetTypeId} | Returns Assignments for given asset type id.
*AssignmentsApi* | [**get_available_asset_types_for_domain**](docs/AssignmentsApi.md#get_available_asset_types_for_domain) | **GET** /assignments/domain/{domainId}/assetTypes | Returns available asset types for domain identified by given id.
*AssignmentsApi* | [**get_available_attribute_types_for_asset**](docs/AssignmentsApi.md#get_available_attribute_types_for_asset) | **GET** /assignments/asset/{assetId}/attributeTypes | Returns available attribute types for asset identified by given id.
*AssignmentsApi* | [**get_available_complex_relation_types_for_asset**](docs/AssignmentsApi.md#get_available_complex_relation_types_for_asset) | **GET** /assignments/asset/{assetId}/complexRelationTypes | Returns the available ComplexRelationTypes for the Asset identified by the given id.
*AssignmentsApi* | [**get_available_relation_types_for_asset**](docs/AssignmentsApi.md#get_available_relation_types_for_asset) | **GET** /assignments/asset/{assetId}/relationTypes | Returns the available RelationTypes for the Asset identified by the given id.
*AssignmentsApi* | [**remove_assignment**](docs/AssignmentsApi.md#remove_assignment) | **DELETE** /assignments/{assignmentId} | Removes the Assignment identified by the given id.
*AttachmentsApi* | [**add_attachment**](docs/AttachmentsApi.md#add_attachment) | **POST** /attachments | Add attachment
*AttachmentsApi* | [**find_attachments**](docs/AttachmentsApi.md#find_attachments) | **GET** /attachments | Find attachments
*AttachmentsApi* | [**get_attachment**](docs/AttachmentsApi.md#get_attachment) | **GET** /attachments/{attachmentId} | Get attachment
*AttachmentsApi* | [**get_attachment_content**](docs/AttachmentsApi.md#get_attachment_content) | **GET** /attachments/{attachmentId}/file | Get attachment content
*AttachmentsApi* | [**remove_attachment**](docs/AttachmentsApi.md#remove_attachment) | **DELETE** /attachments/{attachmentId} | Remove attachment
*AttributeTypesApi* | [**add_attribute_type**](docs/AttributeTypesApi.md#add_attribute_type) | **POST** /attributeTypes | Adds a new Attribute Type.
*AttributeTypesApi* | [**add_attribute_types**](docs/AttributeTypesApi.md#add_attribute_types) | **POST** /attributeTypes/bulk | Adds multiple Attribute Types.
*AttributeTypesApi* | [**change_attribute_type**](docs/AttributeTypesApi.md#change_attribute_type) | **PATCH** /attributeTypes/{attributeTypeId} | Changes the attribute types.
*AttributeTypesApi* | [**change_attribute_types**](docs/AttributeTypesApi.md#change_attribute_types) | **PATCH** /attributeTypes/bulk | Changes multiple attribute types.
*AttributeTypesApi* | [**find_attribute_types**](docs/AttributeTypesApi.md#find_attribute_types) | **GET** /attributeTypes | Returns attribute types matching the given search criteria.
*AttributeTypesApi* | [**get_attribute_type**](docs/AttributeTypesApi.md#get_attribute_type) | **GET** /attributeTypes/{attributeTypeId} | Returns the attribute type identified by given UUID.
*AttributeTypesApi* | [**get_attribute_type_by_name**](docs/AttributeTypesApi.md#get_attribute_type_by_name) | **GET** /attributeTypes/name/{attributeTypeName} | Returns the attribute type identified by given name.
*AttributeTypesApi* | [**remove_attribute_type**](docs/AttributeTypesApi.md#remove_attribute_type) | **DELETE** /attributeTypes/{attributeTypeId} | Removes attribute type identified by given UUID.
*AttributeTypesApi* | [**remove_attribute_types**](docs/AttributeTypesApi.md#remove_attribute_types) | **DELETE** /attributeTypes/bulk | Removes multiple attribute types.
*AttributesApi* | [**add_attribute**](docs/AttributesApi.md#add_attribute) | **POST** /attributes | Add attribute
*AttributesApi* | [**add_attributes**](docs/AttributesApi.md#add_attributes) | **POST** /attributes/bulk | Add attributes
*AttributesApi* | [**change_attribute**](docs/AttributesApi.md#change_attribute) | **PATCH** /attributes/{attributeId} | Change attribute
*AttributesApi* | [**change_attributes**](docs/AttributesApi.md#change_attributes) | **PATCH** /attributes/bulk | Change attributes
*AttributesApi* | [**find_attributes**](docs/AttributesApi.md#find_attributes) | **GET** /attributes | Find attributes
*AttributesApi* | [**get_attribute**](docs/AttributesApi.md#get_attribute) | **GET** /attributes/{attributeId} | Get attribute
*AttributesApi* | [**remove_attribute**](docs/AttributesApi.md#remove_attribute) | **DELETE** /attributes/{attributeId} | Remove attribute
*AttributesApi* | [**remove_attributes**](docs/AttributesApi.md#remove_attributes) | **DELETE** /attributes/bulk | Remove attributes
*AuthenticationSessionsApi* | [**current_session**](docs/AuthenticationSessionsApi.md#current_session) | **GET** /auth/sessions/current | Get session
*AuthenticationSessionsApi* | [**heartbeat**](docs/AuthenticationSessionsApi.md#heartbeat) | **GET** /auth/sessions/heartbeat | Checks if the user session is active
*AuthenticationSessionsApi* | [**login**](docs/AuthenticationSessionsApi.md#login) | **POST** /auth/sessions | Login
*AuthenticationSessionsApi* | [**logout**](docs/AuthenticationSessionsApi.md#logout) | **DELETE** /auth/sessions/current | Logout
*CommentsApi* | [**add_comment**](docs/CommentsApi.md#add_comment) | **POST** /comments | Add comment.
*CommentsApi* | [**change_comment**](docs/CommentsApi.md#change_comment) | **PATCH** /comments/{commentId} | Change comment.
*CommentsApi* | [**find_comments**](docs/CommentsApi.md#find_comments) | **GET** /comments | Find comments.
*CommentsApi* | [**get_comment**](docs/CommentsApi.md#get_comment) | **GET** /comments/{commentId} | Get comment.
*CommentsApi* | [**remove_comment**](docs/CommentsApi.md#remove_comment) | **DELETE** /comments/{commentId} | Remove comment.
*CommunitiesApi* | [**add_communities**](docs/CommunitiesApi.md#add_communities) | **POST** /communities/bulk | Add multiple communities
*CommunitiesApi* | [**add_community**](docs/CommunitiesApi.md#add_community) | **POST** /communities | Add community
*CommunitiesApi* | [**change_communities**](docs/CommunitiesApi.md#change_communities) | **PATCH** /communities/bulk | Change multiple communities
*CommunitiesApi* | [**change_community**](docs/CommunitiesApi.md#change_community) | **PATCH** /communities/{communityId} | Change community
*CommunitiesApi* | [**change_to_root_community**](docs/CommunitiesApi.md#change_to_root_community) | **POST** /communities/{communityId}/root | Change to root community
*CommunitiesApi* | [**find_communities**](docs/CommunitiesApi.md#find_communities) | **GET** /communities | Find communities
*CommunitiesApi* | [**get_community**](docs/CommunitiesApi.md#get_community) | **GET** /communities/{communityId} | Get community
*CommunitiesApi* | [**get_community_breadcrumb**](docs/CommunitiesApi.md#get_community_breadcrumb) | **GET** /communities/{communityId}/breadcrumb | Get community breadcrumb
*CommunitiesApi* | [**remove_communities**](docs/CommunitiesApi.md#remove_communities) | **DELETE** /communities/bulk | Remove multiple communities
*CommunitiesApi* | [**remove_communities_in_job**](docs/CommunitiesApi.md#remove_communities_in_job) | **POST** /communities/removalJobs | Remove multiple communities asynchronously
*CommunitiesApi* | [**remove_community**](docs/CommunitiesApi.md#remove_community) | **DELETE** /communities/{communityId} | Remove community
*ComplexRelationTypesApi* | [**add_complex_relation_type**](docs/ComplexRelationTypesApi.md#add_complex_relation_type) | **POST** /complexRelationTypes | Adds a new complex relation type.
*ComplexRelationTypesApi* | [**change_complex_relation_type**](docs/ComplexRelationTypesApi.md#change_complex_relation_type) | **PATCH** /complexRelationTypes/{complexRelationTypeId} | Changes the complex relation type.
*ComplexRelationTypesApi* | [**find_complex_relation_types**](docs/ComplexRelationTypesApi.md#find_complex_relation_types) | **GET** /complexRelationTypes | Returns complex relation types matching the given search criteria.
*ComplexRelationTypesApi* | [**get_complex_relation_type**](docs/ComplexRelationTypesApi.md#get_complex_relation_type) | **GET** /complexRelationTypes/{complexRelationTypeId} | Returns complex relation type identified by given UUID.
*ComplexRelationTypesApi* | [**remove_complex_relation_type**](docs/ComplexRelationTypesApi.md#remove_complex_relation_type) | **DELETE** /complexRelationTypes/{complexRelationTypeId} | Removes complex relation type identified by given UUID.
*ComplexRelationsApi* | [**add_complex_relation**](docs/ComplexRelationsApi.md#add_complex_relation) | **POST** /complexRelations | Adds new complex relation.
*ComplexRelationsApi* | [**change_complex_relation**](docs/ComplexRelationsApi.md#change_complex_relation) | **PATCH** /complexRelations/{complexRelationId} | Change the complex relation with the information that is present in the request.
*ComplexRelationsApi* | [**export_to_csv**](docs/ComplexRelationsApi.md#export_to_csv) | **POST** /complexRelations/export/csv-job | Export complex relations of the given type to CSV.
*ComplexRelationsApi* | [**export_to_csv_as_string**](docs/ComplexRelationsApi.md#export_to_csv_as_string) | **POST** /complexRelations/export/csv | Export all complex relations of the given type to CSV as a String.
*ComplexRelationsApi* | [**export_to_csv_without_job**](docs/ComplexRelationsApi.md#export_to_csv_without_job) | **POST** /complexRelations/export/csv-file | Export all complex relations of the given type to a CSV file.
*ComplexRelationsApi* | [**export_to_excel**](docs/ComplexRelationsApi.md#export_to_excel) | **POST** /complexRelations/export/excel-job | Export complex relations of the given type to Excel.
*ComplexRelationsApi* | [**export_to_excel_without_job**](docs/ComplexRelationsApi.md#export_to_excel_without_job) | **POST** /complexRelations/export/excel-file | Export all complex relations of the given type to an Excel file.
*ComplexRelationsApi* | [**find_complex_relations**](docs/ComplexRelationsApi.md#find_complex_relations) | **GET** /complexRelations | Returns complex relations matching the given search criteria.
*ComplexRelationsApi* | [**get_complex_relation**](docs/ComplexRelationsApi.md#get_complex_relation) | **GET** /complexRelations/{complexRelationId} | Returns a ComplexRelation identified by given id.
*ComplexRelationsApi* | [**remove_complex_relation**](docs/ComplexRelationsApi.md#remove_complex_relation) | **DELETE** /complexRelations/{complexRelationId} | Removes complex relation identified by given id.
*DataQualityRulesApi* | [**add_data_quality_rule**](docs/DataQualityRulesApi.md#add_data_quality_rule) | **POST** /dataQualityRules | Adds a new data quality rule.
*DataQualityRulesApi* | [**change_data_quality_rule**](docs/DataQualityRulesApi.md#change_data_quality_rule) | **PATCH** /dataQualityRules/{dataQualityRuleId} | Changes the data quality rule with the information that is present in the request.
*DataQualityRulesApi* | [**find_data_quality_rules**](docs/DataQualityRulesApi.md#find_data_quality_rules) | **GET** /dataQualityRules | Returns data quality rules matching the given search criteria.
*DataQualityRulesApi* | [**get_data_quality_rule**](docs/DataQualityRulesApi.md#get_data_quality_rule) | **GET** /dataQualityRules/{dataQualityRuleId} | Returns the DataQualityRule identified by given id.
*DataQualityRulesApi* | [**remove_data_quality_rule**](docs/DataQualityRulesApi.md#remove_data_quality_rule) | **DELETE** /dataQualityRules/{dataQualityRuleId} | Removes the DataQualityRule identified by the given id.
*DiagramPicturesApi* | [**add_diagram_picture**](docs/DiagramPicturesApi.md#add_diagram_picture) | **POST** /diagramPictures | Adds a diagram picture.
*DomainTypesApi* | [**add_domain_type**](docs/DomainTypesApi.md#add_domain_type) | **POST** /domainTypes | Adds a new domain type.
*DomainTypesApi* | [**add_domain_types**](docs/DomainTypesApi.md#add_domain_types) | **POST** /domainTypes/bulk | Adds multiple new domain types.
*DomainTypesApi* | [**change_domain_type**](docs/DomainTypesApi.md#change_domain_type) | **PATCH** /domainTypes/{domainTypeId} | Changes the domain type.
*DomainTypesApi* | [**change_domain_types**](docs/DomainTypesApi.md#change_domain_types) | **PATCH** /domainTypes/bulk | Changes the domain types.
*DomainTypesApi* | [**find_domain_types**](docs/DomainTypesApi.md#find_domain_types) | **GET** /domainTypes | Returns domain types matching the given search criteria.
*DomainTypesApi* | [**find_sub_domain_types**](docs/DomainTypesApi.md#find_sub_domain_types) | **GET** /domainTypes/{domainTypeId}/subTypes | Returns sub domain types matching the given search criteria.
*DomainTypesApi* | [**get_domain_type**](docs/DomainTypesApi.md#get_domain_type) | **GET** /domainTypes/{domainTypeId} | Returns domain type identified by given UUID.
*DomainTypesApi* | [**remove_domain_type**](docs/DomainTypesApi.md#remove_domain_type) | **DELETE** /domainTypes/{domainTypeId} | Removes domain type identified by given UUID.
*DomainTypesApi* | [**remove_domain_types**](docs/DomainTypesApi.md#remove_domain_types) | **DELETE** /domainTypes/bulk | Removes multiple domain types.
*DomainsApi* | [**add_domain**](docs/DomainsApi.md#add_domain) | **POST** /domains | Add domain
*DomainsApi* | [**add_domains**](docs/DomainsApi.md#add_domains) | **POST** /domains/bulk | Add multpile domains
*DomainsApi* | [**change_domain**](docs/DomainsApi.md#change_domain) | **PATCH** /domains/{domainId} | Change domain
*DomainsApi* | [**change_domains**](docs/DomainsApi.md#change_domains) | **PATCH** /domains/bulk | Change multiple domains
*DomainsApi* | [**find_domains**](docs/DomainsApi.md#find_domains) | **GET** /domains | Search domains
*DomainsApi* | [**get_domain**](docs/DomainsApi.md#get_domain) | **GET** /domains/{domainId} | Get domain
*DomainsApi* | [**get_domain_breadcrumb**](docs/DomainsApi.md#get_domain_breadcrumb) | **GET** /domains/{domainId}/breadcrumb | Get domain breadcrumb
*DomainsApi* | [**remove_domain**](docs/DomainsApi.md#remove_domain) | **DELETE** /domains/{domainId} | Remove domain
*DomainsApi* | [**remove_domains**](docs/DomainsApi.md#remove_domains) | **DELETE** /domains/bulk | Remove multiple domains
*DomainsApi* | [**remove_domains_in_job**](docs/DomainsApi.md#remove_domains_in_job) | **POST** /domains/removalJobs | Remove multiple domains asynchronously
*FilesApi* | [**add_files**](docs/FilesApi.md#add_files) | **POST** /files | Upload files
*FilesApi* | [**delete_file**](docs/FilesApi.md#delete_file) | **DELETE** /files/{fileId} | 
*FilesApi* | [**get_file**](docs/FilesApi.md#get_file) | **GET** /files/{fileId} | Download file
*FilesApi* | [**get_file_info**](docs/FilesApi.md#get_file_info) | **GET** /files/{fileId}/info | Get file information
*IssuesApi* | [**add_issue**](docs/IssuesApi.md#add_issue) | **POST** /issues | Adds a new issue.
*IssuesApi* | [**find_issues**](docs/IssuesApi.md#find_issues) | **GET** /issues | Returns issues matching the given search criteria.
*IssuesApi* | [**move_issue**](docs/IssuesApi.md#move_issue) | **PATCH** /issues/{issueId}/community/{communityId} | Moves an issue to another community.
*JDBCDriverApi* | [**find_jdbc_drivers**](docs/JDBCDriverApi.md#find_jdbc_drivers) | **GET** /jdbc | Find JDBC Drivers
*JobsApi* | [**cancel_job**](docs/JobsApi.md#cancel_job) | **POST** /jobs/{jobId}/canceled | Cancels given Job.
*JobsApi* | [**find_jobs**](docs/JobsApi.md#find_jobs) | **GET** /jobs | Find jobs
*JobsApi* | [**get_job**](docs/JobsApi.md#get_job) | **GET** /jobs/{jobId} | Returns the Job identified by the given UUID.
*MappingsApi* | [**add_mapping**](docs/MappingsApi.md#add_mapping) | **POST** /mappings | Adds a new mapping.
*MappingsApi* | [**add_mappings**](docs/MappingsApi.md#add_mappings) | **POST** /mappings/bulk | Adds new mappings.
*MappingsApi* | [**change_mapping**](docs/MappingsApi.md#change_mapping) | **PATCH** /mappings/{mappingId} | Changes the mapping identified by its id.
*MappingsApi* | [**change_mapping_by_external_entity**](docs/MappingsApi.md#change_mapping_by_external_entity) | **PATCH** /mappings/externalSystem/{externalSystemId}/externalEntity/{externalEntityId} | Changes the mapping identified by its external ids.
*MappingsApi* | [**change_mapping_by_mapped_resource**](docs/MappingsApi.md#change_mapping_by_mapped_resource) | **PATCH** /mappings/externalSystem/{externalSystemId}/mappedResource/{mappedResourceId} | Changes the mapping identified by its external system id and mapped resource id.
*MappingsApi* | [**change_mappings**](docs/MappingsApi.md#change_mappings) | **PATCH** /mappings/bulk | Changes multiple mappings identified by their ids.
*MappingsApi* | [**change_mappings_by_external_entities**](docs/MappingsApi.md#change_mappings_by_external_entities) | **PATCH** /mappings/externalSystem/externalEntity/bulk | Changes the mappings identified by their external ids.
*MappingsApi* | [**change_mappings_by_mapped_resources**](docs/MappingsApi.md#change_mappings_by_mapped_resources) | **PATCH** /mappings/externalSystem/mappedResource/bulk | Changes the mapping identified by their external system ids and mapped resource ids.
*MappingsApi* | [**find_mappings**](docs/MappingsApi.md#find_mappings) | **GET** /mappings | Returns mappings matching the given search criteria.
*MappingsApi* | [**get_mapping**](docs/MappingsApi.md#get_mapping) | **GET** /mappings/{mappingId} | Returns a mapping identified by given id.
*MappingsApi* | [**get_mapping_by_external_entity**](docs/MappingsApi.md#get_mapping_by_external_entity) | **GET** /mappings/externalSystem/{externalSystemId}/externalEntity/{externalEntityId} | Returns a mapping identified by its external ids.
*MappingsApi* | [**get_mapping_by_mapped_resource**](docs/MappingsApi.md#get_mapping_by_mapped_resource) | **GET** /mappings/externalSystem/{externalSystemId}/mappedResource/{mappedResourceId} | Returns a mapping identified by its external system id and mapped resource id.
*MappingsApi* | [**remove_mapping**](docs/MappingsApi.md#remove_mapping) | **DELETE** /mappings/{mappingId} | Removes the mapping identified by its id.
*MappingsApi* | [**remove_mapping_by_external_entity**](docs/MappingsApi.md#remove_mapping_by_external_entity) | **DELETE** /mappings/externalSystem/{externalSystemId}/externalEntity/{externalEntityId} | Removes the mapping identified by its external ids.
*MappingsApi* | [**remove_mapping_by_mapped_resource**](docs/MappingsApi.md#remove_mapping_by_mapped_resource) | **DELETE** /mappings/externalSystem/{externalSystemId}/mappedResource/{mappedResourceId} | Removes the mapping identified by its external system id and mapped resource id.
*MappingsApi* | [**remove_mappings_by_external_system_in_job**](docs/MappingsApi.md#remove_mappings_by_external_system_in_job) | **POST** /mappings/externalSystem/{externalSystemId}/removalJobs | Removes all the mappings identified by given external system id.
*MappingsApi* | [**remove_mappings_in_job**](docs/MappingsApi.md#remove_mappings_in_job) | **POST** /mappings/removalJobs | Removes multiple mappings in job.
*NavigationStatisticsApi* | [**find_most_viewed_assets**](docs/NavigationStatisticsApi.md#find_most_viewed_assets) | **GET** /navigation/most_viewed | Find most viewed assets.
*NavigationStatisticsApi* | [**find_recently_viewed_assets**](docs/NavigationStatisticsApi.md#find_recently_viewed_assets) | **GET** /navigation/recently_viewed | Find recently viewed assets.
*OutputModuleApi* | [**export_csv**](docs/OutputModuleApi.md#export_csv) | **POST** /outputModule/export/csv | Exports results in CSV format, returns the results immediately.
*OutputModuleApi* | [**export_csv_in_job**](docs/OutputModuleApi.md#export_csv_in_job) | **POST** /outputModule/export/csv-job | Exports results in CSV format, returns JSON representation of the async Job.
*OutputModuleApi* | [**export_csv_to_file**](docs/OutputModuleApi.md#export_csv_to_file) | **POST** /outputModule/export/csv-file | Exports results in CSV format, returns information about created file.
*OutputModuleApi* | [**export_excel_in_job**](docs/OutputModuleApi.md#export_excel_in_job) | **POST** /outputModule/export/excel-job | Exports results in Excel format, returns JSON representation of the async Job.
*OutputModuleApi* | [**export_excel_to_file**](docs/OutputModuleApi.md#export_excel_to_file) | **POST** /outputModule/export/excel-file | Exports results in Excel format, returns information about created file.
*OutputModuleApi* | [**export_json**](docs/OutputModuleApi.md#export_json) | **POST** /outputModule/export/json | Exports results in JSON format, returns the results immediately.
*OutputModuleApi* | [**export_json_in_job**](docs/OutputModuleApi.md#export_json_in_job) | **POST** /outputModule/export/json-job | Exports results in JSON format, returns JSON representation of the async Job.
*OutputModuleApi* | [**export_json_to_file**](docs/OutputModuleApi.md#export_json_to_file) | **POST** /outputModule/export/json-file | Exports results in JSON format, returns information about created file.
*OutputModuleApi* | [**export_xml**](docs/OutputModuleApi.md#export_xml) | **POST** /outputModule/export/xml | Exports results in XML format, returns the results immediately.
*OutputModuleApi* | [**export_xml_in_job**](docs/OutputModuleApi.md#export_xml_in_job) | **POST** /outputModule/export/xml-job | Exports results in XML format, returns JSON representation of the async Job.
*OutputModuleApi* | [**export_xml_to_file**](docs/OutputModuleApi.md#export_xml_to_file) | **POST** /outputModule/export/xml-file | Exports results in XML format, returns information about created file.
*OutputModuleApi* | [**get_table_view_config_by_view_id**](docs/OutputModuleApi.md#get_table_view_config_by_view_id) | **GET** /outputModule/tableViewConfigs/viewId/{viewId} | Returns TableViewConfig based on id of given View and its Location.
*RatingsApi* | [**add_rating**](docs/RatingsApi.md#add_rating) | **POST** /ratings | Add rating.
*RatingsApi* | [**change_rating**](docs/RatingsApi.md#change_rating) | **PATCH** /ratings/{ratingId} | Change rating.
*RatingsApi* | [**find_ratings**](docs/RatingsApi.md#find_ratings) | **GET** /ratings | Find ratings.
*RatingsApi* | [**get_rating**](docs/RatingsApi.md#get_rating) | **GET** /ratings/{ratingId} | Get rating.
*RatingsApi* | [**remove_rating**](docs/RatingsApi.md#remove_rating) | **DELETE** /ratings/{ratingId} | Remove rating.
*RelationTypesApi* | [**add_relation_type**](docs/RelationTypesApi.md#add_relation_type) | **POST** /relationTypes | Adds a new relation type.
*RelationTypesApi* | [**add_relation_types**](docs/RelationTypesApi.md#add_relation_types) | **POST** /relationTypes/bulk | Adds multiple new relation type.
*RelationTypesApi* | [**change_relation_type**](docs/RelationTypesApi.md#change_relation_type) | **PATCH** /relationTypes/{relationTypeId} | Changes the relation type.
*RelationTypesApi* | [**change_relation_types**](docs/RelationTypesApi.md#change_relation_types) | **PATCH** /relationTypes/bulk | Changes the relation types.
*RelationTypesApi* | [**find_relation_types**](docs/RelationTypesApi.md#find_relation_types) | **GET** /relationTypes | Finds all the relation types matching the given criteria.
*RelationTypesApi* | [**get_relation_type**](docs/RelationTypesApi.md#get_relation_type) | **GET** /relationTypes/{relationTypeId} | Returns relation type identified by given UUID.
*RelationTypesApi* | [**remove_relation_type**](docs/RelationTypesApi.md#remove_relation_type) | **DELETE** /relationTypes/{relationTypeId} | Removes relation type identified by given UUID.
*RelationTypesApi* | [**remove_relation_types**](docs/RelationTypesApi.md#remove_relation_types) | **DELETE** /relationTypes/bulk | Removes multiple relation types.
*RelationsApi* | [**add_relation**](docs/RelationsApi.md#add_relation) | **POST** /relations | Adds a new relation.
*RelationsApi* | [**add_relations**](docs/RelationsApi.md#add_relations) | **POST** /relations/bulk | Adds multiple relations in one go.
*RelationsApi* | [**change_relation**](docs/RelationsApi.md#change_relation) | **PATCH** /relations/{relationId} | Changes the relation with the information that is present in the request.
*RelationsApi* | [**change_relations**](docs/RelationsApi.md#change_relations) | **PATCH** /relations/bulk | Changes multiple relations.
*RelationsApi* | [**find_relations**](docs/RelationsApi.md#find_relations) | **GET** /relations | Returns relations matching the given search criteria.
*RelationsApi* | [**get_relation**](docs/RelationsApi.md#get_relation) | **GET** /relations/{relationId} | Returns a relation identified by given id.
*RelationsApi* | [**remove_relation**](docs/RelationsApi.md#remove_relation) | **DELETE** /relations/{relationId} | Removes a relation identified by given id.
*RelationsApi* | [**remove_relations**](docs/RelationsApi.md#remove_relations) | **DELETE** /relations/bulk | Removes multiple relations.
*ReportingApi* | [**get_insights_zip**](docs/ReportingApi.md#get_insights_zip) | **GET** /reporting/insights/download | Reporting insights download
*ResponsibilitiesApi* | [**add_responsibilities**](docs/ResponsibilitiesApi.md#add_responsibilities) | **POST** /responsibilities/bulk | Adds multiple responsibilities in one go.
*ResponsibilitiesApi* | [**add_responsibility**](docs/ResponsibilitiesApi.md#add_responsibility) | **POST** /responsibilities | Adds a new responsibility.
*ResponsibilitiesApi* | [**find_responsibilities**](docs/ResponsibilitiesApi.md#find_responsibilities) | **GET** /responsibilities | Finds responsibilities.
*ResponsibilitiesApi* | [**get_responsibility**](docs/ResponsibilitiesApi.md#get_responsibility) | **GET** /responsibilities/{responsibilityId} | Returns the responsibility identified by the given id.
*ResponsibilitiesApi* | [**remove_responsibilities**](docs/ResponsibilitiesApi.md#remove_responsibilities) | **DELETE** /responsibilities/bulk | Removes multiple responsibilities in one go.
*ResponsibilitiesApi* | [**remove_responsibility**](docs/ResponsibilitiesApi.md#remove_responsibility) | **DELETE** /responsibilities/{responsibilityId} | Removes the responsibility identified by the given id.
*RolesApi* | [**add_role**](docs/RolesApi.md#add_role) | **POST** /roles | Adds a new role.
*RolesApi* | [**change_role**](docs/RolesApi.md#change_role) | **PATCH** /roles/{roleId} | Change the role with the given id.
*RolesApi* | [**find_roles**](docs/RolesApi.md#find_roles) | **GET** /roles | Returns roles matching the given search criteria.
*RolesApi* | [**get_role**](docs/RolesApi.md#get_role) | **GET** /roles/{roleId} | Returns the role identified by the given id.
*RolesApi* | [**remove_role**](docs/RolesApi.md#remove_role) | **DELETE** /roles/{roleId} | Removes the role identified by the given id.
*SAMLApi* | [**change_certificate**](docs/SAMLApi.md#change_certificate) | **POST** /security/saml/certificate/{type} | Changes the certificate to be used with SAML
*SAMLApi* | [**delete_customizations**](docs/SAMLApi.md#delete_customizations) | **DELETE** /security/saml/certificate/{type} | Delete the specified SAML certificate from the SAML keystore.
*SAMLApi* | [**get_sp_metadata_as_string**](docs/SAMLApi.md#get_sp_metadata_as_string) | **GET** /security/saml | Returns the SAML Service Provider metadata for this instance.
*ScopesApi* | [**add_scope**](docs/ScopesApi.md#add_scope) | **POST** /scopes | Add scope
*ScopesApi* | [**change_scope**](docs/ScopesApi.md#change_scope) | **PATCH** /scopes/{scopeId} | Change scope
*ScopesApi* | [**get_all_scopes**](docs/ScopesApi.md#get_all_scopes) | **GET** /scopes | Find scopes
*ScopesApi* | [**get_scope**](docs/ScopesApi.md#get_scope) | **GET** /scopes/{scopeId} | Get scope
*ScopesApi* | [**remove_scope**](docs/ScopesApi.md#remove_scope) | **DELETE** /scopes/{scopeId} | Remove scope
*StatusesApi* | [**add_status**](docs/StatusesApi.md#add_status) | **POST** /statuses | Adds a new Status.
*StatusesApi* | [**add_statuses**](docs/StatusesApi.md#add_statuses) | **POST** /statuses/bulk | Adds multiple statuses in one go.
*StatusesApi* | [**change_status**](docs/StatusesApi.md#change_status) | **PATCH** /statuses/{statusId} | Changes the status with the information that is present in the request.
*StatusesApi* | [**change_statuses**](docs/StatusesApi.md#change_statuses) | **PATCH** /statuses/bulk | Changes multiple statuses in one go.
*StatusesApi* | [**find_statuses**](docs/StatusesApi.md#find_statuses) | **GET** /statuses | Returns statuses matching the given search criteria.
*StatusesApi* | [**get_status**](docs/StatusesApi.md#get_status) | **GET** /statuses/{statusId} | Returns the Status identified by the given id.
*StatusesApi* | [**get_status_by_name**](docs/StatusesApi.md#get_status_by_name) | **GET** /statuses/name/{statusName} | Returns the Status identified by the given name.
*StatusesApi* | [**remove_status**](docs/StatusesApi.md#remove_status) | **DELETE** /statuses/{statusId} | Removes the Status identified by the given id.
*StatusesApi* | [**remove_statuses**](docs/StatusesApi.md#remove_statuses) | **DELETE** /statuses/bulk | Removes multiple statuses.
*TagsApi* | [**change_tag**](docs/TagsApi.md#change_tag) | **PATCH** /tags/{tagId} | Change tag.
*TagsApi* | [**exists**](docs/TagsApi.md#exists) | **GET** /tags/exists/{tagName} | Check tag name.
*TagsApi* | [**find_tags**](docs/TagsApi.md#find_tags) | **GET** /tags | Find tags.
*TagsApi* | [**get_tag**](docs/TagsApi.md#get_tag) | **GET** /tags/{tagId} | Get tag.
*TagsApi* | [**get_tags_by_asset_id**](docs/TagsApi.md#get_tags_by_asset_id) | **GET** /tags/asset/{assetId} | Get asset tags.
*TagsApi* | [**merge_tags**](docs/TagsApi.md#merge_tags) | **POST** /tags/merge | Merge tags.
*TagsApi* | [**remove_tag**](docs/TagsApi.md#remove_tag) | **DELETE** /tags/{tagId} | Remove tag.
*TagsApi* | [**remove_tags**](docs/TagsApi.md#remove_tags) | **DELETE** /tags/bulk | Remove tags.
*UserGroupsApi* | [**add_user_group**](docs/UserGroupsApi.md#add_user_group) | **POST** /userGroups | Add new user group
*UserGroupsApi* | [**add_users_to_user_group**](docs/UserGroupsApi.md#add_users_to_user_group) | **POST** /userGroups/{userGroupId}/users | Add users to user group
*UserGroupsApi* | [**change_user_group**](docs/UserGroupsApi.md#change_user_group) | **PATCH** /userGroups/{userGroupId} | Change user group
*UserGroupsApi* | [**find_user_groups**](docs/UserGroupsApi.md#find_user_groups) | **GET** /userGroups | Find user groups
*UserGroupsApi* | [**get_user_group**](docs/UserGroupsApi.md#get_user_group) | **GET** /userGroups/{userGroupId} | Get user group
*UserGroupsApi* | [**remove_user_group**](docs/UserGroupsApi.md#remove_user_group) | **DELETE** /userGroups/{userGroupId} | Remove user group
*UserGroupsApi* | [**remove_users_from_user_group**](docs/UserGroupsApi.md#remove_users_from_user_group) | **DELETE** /userGroups/{userGroupId}/users | Remove users from user group
*UsersApi* | [**add_user**](docs/UsersApi.md#add_user) | **POST** /users | Adds a new user
*UsersApi* | [**add_user_groups_for_user**](docs/UsersApi.md#add_user_groups_for_user) | **POST** /users/{userId}/userGroups | Add a user to multiple user groups
*UsersApi* | [**add_users**](docs/UsersApi.md#add_users) | **POST** /users/bulk | Adds multiple new users
*UsersApi* | [**change_user**](docs/UsersApi.md#change_user) | **PATCH** /users/{userId} | Changes the user with the information that is present in the request
*UsersApi* | [**change_user_avatar**](docs/UsersApi.md#change_user_avatar) | **PATCH** /users/{userId}/avatar | Changes the avatar for the user identified by the given ID
*UsersApi* | [**delete_user**](docs/UsersApi.md#delete_user) | **DELETE** /users/{userId} | Deletes the user with the given ID
*UsersApi* | [**delete_user_avatar**](docs/UsersApi.md#delete_user_avatar) | **DELETE** /users/{userId}/avatar | Deletes the avatar for the user identified by the given ID
*UsersApi* | [**find_users**](docs/UsersApi.md#find_users) | **GET** /users | Returns users matching the given search criteria
*UsersApi* | [**get_avatar_file**](docs/UsersApi.md#get_avatar_file) | **GET** /users/{userId}/avatar | Get the avatar image for the user with the given ID
*UsersApi* | [**get_current_user**](docs/UsersApi.md#get_current_user) | **GET** /users/current | Returns the current user, if logged in
*UsersApi* | [**get_current_user_permissions**](docs/UsersApi.md#get_current_user_permissions) | **GET** /users/current/permissions | Returns the current user global permissions, if logged in
*UsersApi* | [**get_user**](docs/UsersApi.md#get_user) | **GET** /users/{userId} | Gets the user with the given ID
*UsersApi* | [**get_user_by_email_address**](docs/UsersApi.md#get_user_by_email_address) | **GET** /users/email/{emailAddress} | Gets the user identified by given e-mail address
*UsersApi* | [**get_user_required_license_type**](docs/UsersApi.md#get_user_required_license_type) | **GET** /users/{userId}/licenseType | Gets the required LicenseType for the given user
*UsersApi* | [**remove_user_from_user_groups**](docs/UsersApi.md#remove_user_from_user_groups) | **DELETE** /users/{userId}/userGroups | Removes user from multiple user groups
*UsersApi* | [**set_user_groups_for_user**](docs/UsersApi.md#set_user_groups_for_user) | **PUT** /users/{userId}/userGroups | Sets user groups for the indicated user
*ValidationApi* | [**find_validation_results**](docs/ValidationApi.md#find_validation_results) | **GET** /validation | Returns the validation results matching the given search criteria.
*ValidationApi* | [**validate**](docs/ValidationApi.md#validate) | **POST** /validation/{assetId} | Validates a single asset.
*ValidationApi* | [**validate_in_job**](docs/ValidationApi.md#validate_in_job) | **POST** /validation/bulk | Validates multiple assets.
*ViewPermissionsApi* | [**add_view_permission**](docs/ViewPermissionsApi.md#add_view_permission) | **POST** /viewPermissions | Adds a view permission. It can be applied only to &#39;Community&#39; and &#39;Domain&#39; resource types.
*ViewPermissionsApi* | [**find_view_permissions**](docs/ViewPermissionsApi.md#find_view_permissions) | **GET** /viewPermissions | Finds view permissions with given criteria.
*ViewPermissionsApi* | [**get_view_permission**](docs/ViewPermissionsApi.md#get_view_permission) | **GET** /viewPermissions/{viewPermissionId} | Retrieves a view permission.
*ViewPermissionsApi* | [**remove_view_permission**](docs/ViewPermissionsApi.md#remove_view_permission) | **DELETE** /viewPermissions/{viewPermissionId} | Removes a view permission.
*WorkflowDefinitionsApi* | [**add_asset_type_assignment_rule**](docs/WorkflowDefinitionsApi.md#add_asset_type_assignment_rule) | **POST** /workflowDefinitions/{workflowDefinitionId}/assetTypeAssignmentRules | Add asset type assignment rule.
*WorkflowDefinitionsApi* | [**add_domain_type_assignment_rule**](docs/WorkflowDefinitionsApi.md#add_domain_type_assignment_rule) | **POST** /workflowDefinitions/{workflowDefinitionId}/domainTypeAssignmentRules | Add domain type assignment rule.
*WorkflowDefinitionsApi* | [**change_asset_type_assignment_rule**](docs/WorkflowDefinitionsApi.md#change_asset_type_assignment_rule) | **PATCH** /workflowDefinitions/{workflowDefinitionId}/assetTypeAssignmentRules/{ruleId} | Change asset type assignment rule.
*WorkflowDefinitionsApi* | [**change_domain_type_assignment_rule**](docs/WorkflowDefinitionsApi.md#change_domain_type_assignment_rule) | **PATCH** /workflowDefinitions/{workflowDefinitionId}/domainTypeAssignmentRules/{ruleId} | Change domain type assignment rule.
*WorkflowDefinitionsApi* | [**change_workflow_definition**](docs/WorkflowDefinitionsApi.md#change_workflow_definition) | **PATCH** /workflowDefinitions/{workflowDefinitionId} | Change workflow definition.
*WorkflowDefinitionsApi* | [**deploy_workflow_definition**](docs/WorkflowDefinitionsApi.md#deploy_workflow_definition) | **POST** /workflowDefinitions | Deploy workflow definition.
*WorkflowDefinitionsApi* | [**find_workflow_definitions**](docs/WorkflowDefinitionsApi.md#find_workflow_definitions) | **GET** /workflowDefinitions | Find workflow definitions.
*WorkflowDefinitionsApi* | [**get_configuration_start_form_data**](docs/WorkflowDefinitionsApi.md#get_configuration_start_form_data) | **GET** /workflowDefinitions/workflowDefinition/{workflowDefinitionId}/configurationStartFormData | Get configuration start form data.
*WorkflowDefinitionsApi* | [**get_possible_start_events**](docs/WorkflowDefinitionsApi.md#get_possible_start_events) | **GET** /workflowDefinitions/startEvents | Get all possible workflow start events
*WorkflowDefinitionsApi* | [**get_start_form_data**](docs/WorkflowDefinitionsApi.md#get_start_form_data) | **GET** /workflowDefinitions/workflowDefinition/{workflowDefinitionId}/startFormData | Get start form data.
*WorkflowDefinitionsApi* | [**get_workflow_definition**](docs/WorkflowDefinitionsApi.md#get_workflow_definition) | **GET** /workflowDefinitions/{workflowDefinitionId} | Get workflow definition.
*WorkflowDefinitionsApi* | [**get_workflow_definition_by_process_id**](docs/WorkflowDefinitionsApi.md#get_workflow_definition_by_process_id) | **GET** /workflowDefinitions/process/{processId} | Get workflow definition.
*WorkflowDefinitionsApi* | [**get_workflow_definition_diagram**](docs/WorkflowDefinitionsApi.md#get_workflow_definition_diagram) | **GET** /workflowDefinitions/{workflowDefinitionId}/diagram | Get process diagram.
*WorkflowDefinitionsApi* | [**get_workflow_definition_xml**](docs/WorkflowDefinitionsApi.md#get_workflow_definition_xml) | **GET** /workflowDefinitions/{workflowDefinitionId}/xml | Get XML of workflow definition.
*WorkflowDefinitionsApi* | [**remove_assignment_rule**](docs/WorkflowDefinitionsApi.md#remove_assignment_rule) | **DELETE** /workflowDefinitions/{workflowDefinitionId}/assignmentRules/{ruleId} | Remove assignment rule.
*WorkflowDefinitionsApi* | [**remove_workflow_definition**](docs/WorkflowDefinitionsApi.md#remove_workflow_definition) | **DELETE** /workflowDefinitions/{workflowDefinitionId} | Remove workflow definition.
*WorkflowDefinitionsApi* | [**remove_workflow_definitions_in_job**](docs/WorkflowDefinitionsApi.md#remove_workflow_definitions_in_job) | **POST** /workflowDefinitions/removalJobs | Remove multiple workflow definitions.
*WorkflowInstancesApi* | [**cancel_workflow_instances**](docs/WorkflowInstancesApi.md#cancel_workflow_instances) | **POST** /workflowInstances/{workflowInstanceId}/canceled | Cancel workflow instance.
*WorkflowInstancesApi* | [**find_workflow_instances**](docs/WorkflowInstancesApi.md#find_workflow_instances) | **GET** /workflowInstances | Find workflow instances.
*WorkflowInstancesApi* | [**get_workflow_instance_diagram**](docs/WorkflowInstancesApi.md#get_workflow_instance_diagram) | **GET** /workflowInstances/{workflowInstanceId}/diagram | Returns the file representing the diagram of workflow instance identified by the given ID.
*WorkflowInstancesApi* | [**message_event_received**](docs/WorkflowInstancesApi.md#message_event_received) | **POST** /workflowInstances/{processInstanceId}/messageEvents/{messageName} | Pass message event to workflow engine.
*WorkflowInstancesApi* | [**start_workflow_instances**](docs/WorkflowInstancesApi.md#start_workflow_instances) | **POST** /workflowInstances | Start workflow instances.
*WorkflowInstancesApi* | [**start_workflow_instances_in_job**](docs/WorkflowInstancesApi.md#start_workflow_instances_in_job) | **POST** /workflowInstances/startJobs | Start workflow instances.
*WorkflowTasksApi* | [**cancel_workflow_task**](docs/WorkflowTasksApi.md#cancel_workflow_task) | **POST** /workflowTasks/{workflowTaskId}/canceled | Cancel workflow task.
*WorkflowTasksApi* | [**complete_workflow_tasks**](docs/WorkflowTasksApi.md#complete_workflow_tasks) | **POST** /workflowTasks/completed | Complete workflow tasks.
*WorkflowTasksApi* | [**find_workflow_tasks**](docs/WorkflowTasksApi.md#find_workflow_tasks) | **GET** /workflowTasks | Find workflow tasks.
*WorkflowTasksApi* | [**get_task_form_data**](docs/WorkflowTasksApi.md#get_task_form_data) | **GET** /workflowTasks/{workflowTaskId}/taskFormData | Get task form data.
*WorkflowTasksApi* | [**get_workflow_task**](docs/WorkflowTasksApi.md#get_workflow_task) | **GET** /workflowTasks/{workflowTaskId} | Get workflow task.
*WorkflowTasksApi* | [**reassign_task**](docs/WorkflowTasksApi.md#reassign_task) | **POST** /workflowTasks/{workflowTaskId}/reassign | Reassign task.


## Documentation For Models

 - [ActivityImpl](docs/ActivityImpl.md)
 - [ActivityPagedResponse](docs/ActivityPagedResponse.md)
 - [AddAssetRequest](docs/AddAssetRequest.md)
 - [AddAssetTagsRequest](docs/AddAssetTagsRequest.md)
 - [AddAssetTypeAssignmentRuleRequest](docs/AddAssetTypeAssignmentRuleRequest.md)
 - [AddAssetTypeRequest](docs/AddAssetTypeRequest.md)
 - [AddAssignmentRequest](docs/AddAssignmentRequest.md)
 - [AddAttributeRequest](docs/AddAttributeRequest.md)
 - [AddAttributeTypeRequest](docs/AddAttributeTypeRequest.md)
 - [AddCommentRequest](docs/AddCommentRequest.md)
 - [AddCommunityRequest](docs/AddCommunityRequest.md)
 - [AddComplexRelationRequest](docs/AddComplexRelationRequest.md)
 - [AddComplexRelationTypeRequest](docs/AddComplexRelationTypeRequest.md)
 - [AddDataQualityRuleRequest](docs/AddDataQualityRuleRequest.md)
 - [AddDiagramPictureRequest](docs/AddDiagramPictureRequest.md)
 - [AddDomainRequest](docs/AddDomainRequest.md)
 - [AddDomainTypeAssignmentRuleRequest](docs/AddDomainTypeAssignmentRuleRequest.md)
 - [AddDomainTypeRequest](docs/AddDomainTypeRequest.md)
 - [AddIssueRequest](docs/AddIssueRequest.md)
 - [AddMappingRequest](docs/AddMappingRequest.md)
 - [AddRatingRequest](docs/AddRatingRequest.md)
 - [AddRelationRequest](docs/AddRelationRequest.md)
 - [AddRelationTypeRequest](docs/AddRelationTypeRequest.md)
 - [AddResponsibilityRequest](docs/AddResponsibilityRequest.md)
 - [AddRoleRequest](docs/AddRoleRequest.md)
 - [AddScopeRequest](docs/AddScopeRequest.md)
 - [AddStatusRequest](docs/AddStatusRequest.md)
 - [AddUserGroupRequest](docs/AddUserGroupRequest.md)
 - [AddUserRequest](docs/AddUserRequest.md)
 - [AddUserToUserGroupsRequest](docs/AddUserToUserGroupsRequest.md)
 - [AddUsersToUserGroupRequest](docs/AddUsersToUserGroupRequest.md)
 - [AddViewPermissionRequest](docs/AddViewPermissionRequest.md)
 - [Address](docs/Address.md)
 - [ApplicationInfo](docs/ApplicationInfo.md)
 - [ApplicationVersionImpl](docs/ApplicationVersionImpl.md)
 - [ArticulationRuleImpl](docs/ArticulationRuleImpl.md)
 - [ArticulationRuleRequest](docs/ArticulationRuleRequest.md)
 - [AssetAssignmentRuleImpl](docs/AssetAssignmentRuleImpl.md)
 - [AssetImpl](docs/AssetImpl.md)
 - [AssetPagedResponse](docs/AssetPagedResponse.md)
 - [AssetReferenceImpl](docs/AssetReferenceImpl.md)
 - [AssetTypeImpl](docs/AssetTypeImpl.md)
 - [AssetTypePagedResponse](docs/AssetTypePagedResponse.md)
 - [AssignedAttributeType](docs/AssignedAttributeType.md)
 - [AssignedAttributeTypeAllOf](docs/AssignedAttributeTypeAllOf.md)
 - [AssignedCharacteristicType](docs/AssignedCharacteristicType.md)
 - [AssignedComplexRelationType](docs/AssignedComplexRelationType.md)
 - [AssignedComplexRelationTypeAllOf](docs/AssignedComplexRelationTypeAllOf.md)
 - [AssignedRelationType](docs/AssignedRelationType.md)
 - [AssignedRelationTypeAllOf](docs/AssignedRelationTypeAllOf.md)
 - [AssignmentImpl](docs/AssignmentImpl.md)
 - [AttachmentImpl](docs/AttachmentImpl.md)
 - [AttachmentPagedResponse](docs/AttachmentPagedResponse.md)
 - [Attribute](docs/Attribute.md)
 - [AttributePagedResponse](docs/AttributePagedResponse.md)
 - [AttributeType](docs/AttributeType.md)
 - [AttributeTypePagedResponse](docs/AttributeTypePagedResponse.md)
 - [AttributeValue](docs/AttributeValue.md)
 - [BooleanAttribute](docs/BooleanAttribute.md)
 - [BooleanAttributeAllOf](docs/BooleanAttributeAllOf.md)
 - [BooleanAttributeType](docs/BooleanAttributeType.md)
 - [BooleanAttributeTypeAllOf](docs/BooleanAttributeTypeAllOf.md)
 - [CancelJobRequest](docs/CancelJobRequest.md)
 - [ChangeAssetRequest](docs/ChangeAssetRequest.md)
 - [ChangeAssetTypeAssignmentRuleRequest](docs/ChangeAssetTypeAssignmentRuleRequest.md)
 - [ChangeAssetTypeRequest](docs/ChangeAssetTypeRequest.md)
 - [ChangeAssignmentRequest](docs/ChangeAssignmentRequest.md)
 - [ChangeAttributeRequest](docs/ChangeAttributeRequest.md)
 - [ChangeAttributeTypeRequest](docs/ChangeAttributeTypeRequest.md)
 - [ChangeCommentRequest](docs/ChangeCommentRequest.md)
 - [ChangeCommunityRequest](docs/ChangeCommunityRequest.md)
 - [ChangeComplexRelationRequest](docs/ChangeComplexRelationRequest.md)
 - [ChangeComplexRelationTypeRequest](docs/ChangeComplexRelationTypeRequest.md)
 - [ChangeDataQualityRuleRequest](docs/ChangeDataQualityRuleRequest.md)
 - [ChangeDomainRequest](docs/ChangeDomainRequest.md)
 - [ChangeDomainTypeAssignmentRuleRequest](docs/ChangeDomainTypeAssignmentRuleRequest.md)
 - [ChangeDomainTypeRequest](docs/ChangeDomainTypeRequest.md)
 - [ChangeMappingByExternalEntityRequest](docs/ChangeMappingByExternalEntityRequest.md)
 - [ChangeMappingByMappedResourceRequest](docs/ChangeMappingByMappedResourceRequest.md)
 - [ChangeMappingRequest](docs/ChangeMappingRequest.md)
 - [ChangeRatingRequest](docs/ChangeRatingRequest.md)
 - [ChangeRelationRequest](docs/ChangeRelationRequest.md)
 - [ChangeRelationTypeRequest](docs/ChangeRelationTypeRequest.md)
 - [ChangeRoleRequest](docs/ChangeRoleRequest.md)
 - [ChangeScopeRequest](docs/ChangeScopeRequest.md)
 - [ChangeStatusRequest](docs/ChangeStatusRequest.md)
 - [ChangeTagRequest](docs/ChangeTagRequest.md)
 - [ChangeUserAvatarRequest](docs/ChangeUserAvatarRequest.md)
 - [ChangeUserGroupRequest](docs/ChangeUserGroupRequest.md)
 - [ChangeUserRequest](docs/ChangeUserRequest.md)
 - [ChangeWorkflowDefinitionRequest](docs/ChangeWorkflowDefinitionRequest.md)
 - [CharacteristicTypeAssignmentReference](docs/CharacteristicTypeAssignmentReference.md)
 - [Comment](docs/Comment.md)
 - [CommentPagedResponse](docs/CommentPagedResponse.md)
 - [CommunityImpl](docs/CommunityImpl.md)
 - [CommunityPagedResponse](docs/CommunityPagedResponse.md)
 - [CompleteWorkflowTasksRequest](docs/CompleteWorkflowTasksRequest.md)
 - [ComplexRelationAttributeTypeImpl](docs/ComplexRelationAttributeTypeImpl.md)
 - [ComplexRelationAttributeTypeRequest](docs/ComplexRelationAttributeTypeRequest.md)
 - [ComplexRelationImpl](docs/ComplexRelationImpl.md)
 - [ComplexRelationLegImpl](docs/ComplexRelationLegImpl.md)
 - [ComplexRelationLegRequest](docs/ComplexRelationLegRequest.md)
 - [ComplexRelationLegTypeImpl](docs/ComplexRelationLegTypeImpl.md)
 - [ComplexRelationLegTypeRequest](docs/ComplexRelationLegTypeRequest.md)
 - [ComplexRelationTypeImpl](docs/ComplexRelationTypeImpl.md)
 - [ComplexRelationTypePagedResponse](docs/ComplexRelationTypePagedResponse.md)
 - [ConnectionStringParameter](docs/ConnectionStringParameter.md)
 - [CursorPagedResponseAsset](docs/CursorPagedResponseAsset.md)
 - [CursorPagedResponseAttribute](docs/CursorPagedResponseAttribute.md)
 - [CursorPagedResponseCommunity](docs/CursorPagedResponseCommunity.md)
 - [CursorPagedResponseComplexRelation](docs/CursorPagedResponseComplexRelation.md)
 - [CursorPagedResponseDomain](docs/CursorPagedResponseDomain.md)
 - [CursorPagedResponseRelation](docs/CursorPagedResponseRelation.md)
 - [DGCSession](docs/DGCSession.md)
 - [DataQualityMetricImpl](docs/DataQualityMetricImpl.md)
 - [DataQualityMetricRequest](docs/DataQualityMetricRequest.md)
 - [DataQualityRuleImpl](docs/DataQualityRuleImpl.md)
 - [DataQualityRulePagedResponse](docs/DataQualityRulePagedResponse.md)
 - [DateAttribute](docs/DateAttribute.md)
 - [DateAttributeAllOf](docs/DateAttributeAllOf.md)
 - [DateAttributeType](docs/DateAttributeType.md)
 - [DomainImpl](docs/DomainImpl.md)
 - [DomainPagedResponse](docs/DomainPagedResponse.md)
 - [DomainTypeImpl](docs/DomainTypeImpl.md)
 - [DomainTypePagedResponse](docs/DomainTypePagedResponse.md)
 - [DropdownValue](docs/DropdownValue.md)
 - [Email](docs/Email.md)
 - [ExportComplexRelationsToCSVRequest](docs/ExportComplexRelationsToCSVRequest.md)
 - [ExportComplexRelationsToExcelRequest](docs/ExportComplexRelationsToExcelRequest.md)
 - [FileInfoImpl](docs/FileInfoImpl.md)
 - [FileReferenceImpl](docs/FileReferenceImpl.md)
 - [FileUpload](docs/FileUpload.md)
 - [FormProperty](docs/FormProperty.md)
 - [InlineObject](docs/InlineObject.md)
 - [InlineObject1](docs/InlineObject1.md)
 - [InlineObject2](docs/InlineObject2.md)
 - [InstantMessagingAccount](docs/InstantMessagingAccount.md)
 - [JdbcDriver](docs/JdbcDriver.md)
 - [JdbcDriverFile](docs/JdbcDriverFile.md)
 - [JdbcDriverPagedResponse](docs/JdbcDriverPagedResponse.md)
 - [Job](docs/Job.md)
 - [JobPagedResponse](docs/JobPagedResponse.md)
 - [LoginRequest](docs/LoginRequest.md)
 - [Mapping](docs/Mapping.md)
 - [MappingPagedResponse](docs/MappingPagedResponse.md)
 - [MergeTagsRequest](docs/MergeTagsRequest.md)
 - [MessageEventReceivedRequest](docs/MessageEventReceivedRequest.md)
 - [MultiValueListAttribute](docs/MultiValueListAttribute.md)
 - [MultiValueListAttributeAllOf](docs/MultiValueListAttributeAllOf.md)
 - [MultiValueListAttributeType](docs/MultiValueListAttributeType.md)
 - [MultiValueListAttributeTypeAllOf](docs/MultiValueListAttributeTypeAllOf.md)
 - [NamedDescribedResourceReference](docs/NamedDescribedResourceReference.md)
 - [NamedDescribedWorkflowStartEventType](docs/NamedDescribedWorkflowStartEventType.md)
 - [NamedResourceReferenceImpl](docs/NamedResourceReferenceImpl.md)
 - [NavigationStatisticsEntry](docs/NavigationStatisticsEntry.md)
 - [NavigationStatisticsEntryPagedResponse](docs/NavigationStatisticsEntryPagedResponse.md)
 - [NumericAttribute](docs/NumericAttribute.md)
 - [NumericAttributeAllOf](docs/NumericAttributeAllOf.md)
 - [NumericAttributeType](docs/NumericAttributeType.md)
 - [NumericAttributeTypeAllOf](docs/NumericAttributeTypeAllOf.md)
 - [OptionValue](docs/OptionValue.md)
 - [PagedResponse](docs/PagedResponse.md)
 - [PagedResponseActivity](docs/PagedResponseActivity.md)
 - [PagedResponseAsset](docs/PagedResponseAsset.md)
 - [PagedResponseAssetType](docs/PagedResponseAssetType.md)
 - [PagedResponseAttachment](docs/PagedResponseAttachment.md)
 - [PagedResponseAttributeType](docs/PagedResponseAttributeType.md)
 - [PagedResponseComment](docs/PagedResponseComment.md)
 - [PagedResponseComplexRelationType](docs/PagedResponseComplexRelationType.md)
 - [PagedResponseDataQualityRule](docs/PagedResponseDataQualityRule.md)
 - [PagedResponseDomainType](docs/PagedResponseDomainType.md)
 - [PagedResponseJdbcDriver](docs/PagedResponseJdbcDriver.md)
 - [PagedResponseJob](docs/PagedResponseJob.md)
 - [PagedResponseMapping](docs/PagedResponseMapping.md)
 - [PagedResponseNavigationStatisticsEntry](docs/PagedResponseNavigationStatisticsEntry.md)
 - [PagedResponseRating](docs/PagedResponseRating.md)
 - [PagedResponseRelationType](docs/PagedResponseRelationType.md)
 - [PagedResponseResponsibility](docs/PagedResponseResponsibility.md)
 - [PagedResponseRole](docs/PagedResponseRole.md)
 - [PagedResponseScope](docs/PagedResponseScope.md)
 - [PagedResponseStatus](docs/PagedResponseStatus.md)
 - [PagedResponseTag](docs/PagedResponseTag.md)
 - [PagedResponseUser](docs/PagedResponseUser.md)
 - [PagedResponseUserGroup](docs/PagedResponseUserGroup.md)
 - [PagedResponseValidationResult](docs/PagedResponseValidationResult.md)
 - [PagedResponseViewPermission](docs/PagedResponseViewPermission.md)
 - [PagedResponseWorkflowDefinition](docs/PagedResponseWorkflowDefinition.md)
 - [PagedResponseWorkflowInstance](docs/PagedResponseWorkflowInstance.md)
 - [PagedResponseWorkflowTask](docs/PagedResponseWorkflowTask.md)
 - [PhoneNumber](docs/PhoneNumber.md)
 - [Rating](docs/Rating.md)
 - [RatingsPagedResponse](docs/RatingsPagedResponse.md)
 - [RelatedAssetId](docs/RelatedAssetId.md)
 - [RelatedAssetReference](docs/RelatedAssetReference.md)
 - [RelationImpl](docs/RelationImpl.md)
 - [RelationPagedResponse](docs/RelationPagedResponse.md)
 - [RelationTraceEntryImpl](docs/RelationTraceEntryImpl.md)
 - [RelationTraceEntryRequest](docs/RelationTraceEntryRequest.md)
 - [RelationTraceImpl](docs/RelationTraceImpl.md)
 - [RelationTypeImpl](docs/RelationTypeImpl.md)
 - [RelationTypePagedResponse](docs/RelationTypePagedResponse.md)
 - [RemoveAssetTagsRequest](docs/RemoveAssetTagsRequest.md)
 - [RemoveUserFromUserGroupsRequest](docs/RemoveUserFromUserGroupsRequest.md)
 - [RemoveUsersFromUserGroupRequest](docs/RemoveUsersFromUserGroupRequest.md)
 - [ResourceReference](docs/ResourceReference.md)
 - [ResponsibilityImpl](docs/ResponsibilityImpl.md)
 - [RoleImpl](docs/RoleImpl.md)
 - [ScopeImpl](docs/ScopeImpl.md)
 - [ScopePagedResponse](docs/ScopePagedResponse.md)
 - [ScriptAttribute](docs/ScriptAttribute.md)
 - [ScriptAttributeAllOf](docs/ScriptAttributeAllOf.md)
 - [ScriptAttributeType](docs/ScriptAttributeType.md)
 - [ScriptAttributeTypeAllOf](docs/ScriptAttributeTypeAllOf.md)
 - [SetAssetAttributesRequest](docs/SetAssetAttributesRequest.md)
 - [SetAssetRelationsRequest](docs/SetAssetRelationsRequest.md)
 - [SetAssetResponsibilitiesRequest](docs/SetAssetResponsibilitiesRequest.md)
 - [SetAssetTagsRequest](docs/SetAssetTagsRequest.md)
 - [SetUserGroupsForUserRequest](docs/SetUserGroupsForUserRequest.md)
 - [SingleValueListAttribute](docs/SingleValueListAttribute.md)
 - [SingleValueListAttributeAllOf](docs/SingleValueListAttributeAllOf.md)
 - [SingleValueListAttributeType](docs/SingleValueListAttributeType.md)
 - [SolutionInfo](docs/SolutionInfo.md)
 - [StartFormDataImpl](docs/StartFormDataImpl.md)
 - [StartWorkflowInstancesRequest](docs/StartWorkflowInstancesRequest.md)
 - [StatusImpl](docs/StatusImpl.md)
 - [StatusPagedResponse](docs/StatusPagedResponse.md)
 - [StringAttribute](docs/StringAttribute.md)
 - [StringAttributeType](docs/StringAttributeType.md)
 - [StringAttributeTypeAllOf](docs/StringAttributeTypeAllOf.md)
 - [SymbolDataImpl](docs/SymbolDataImpl.md)
 - [Tag](docs/Tag.md)
 - [TagPagedResponse](docs/TagPagedResponse.md)
 - [TaskFormData](docs/TaskFormData.md)
 - [User](docs/User.md)
 - [UserGroupImpl](docs/UserGroupImpl.md)
 - [UserGroupPagedResponse](docs/UserGroupPagedResponse.md)
 - [UserPagedResponse](docs/UserPagedResponse.md)
 - [UserPermissions](docs/UserPermissions.md)
 - [UserReferenceImpl](docs/UserReferenceImpl.md)
 - [ValidateInJobRequest](docs/ValidateInJobRequest.md)
 - [ValidationResultImpl](docs/ValidationResultImpl.md)
 - [ValidationResultPagedResponse](docs/ValidationResultPagedResponse.md)
 - [ViewPermissionImpl](docs/ViewPermissionImpl.md)
 - [Website](docs/Website.md)
 - [WorkflowDefinitionImpl](docs/WorkflowDefinitionImpl.md)
 - [WorkflowDefinitionPagedResponse](docs/WorkflowDefinitionPagedResponse.md)
 - [WorkflowDefinitionReference](docs/WorkflowDefinitionReference.md)
 - [WorkflowInstance](docs/WorkflowInstance.md)
 - [WorkflowTask](docs/WorkflowTask.md)
 - [WorkflowTaskPagedResponse](docs/WorkflowTaskPagedResponse.md)


## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication


## bearerAuth

- **Type**: Bearer authentication (JWT)


## Author




