# coding: utf-8
"""
[A15] Frank, F.C., and JS Kasper. “Complex Alloy Structures Regarded as Sphere Packings. II. Analysis and Classification of Representative Structures.” Acta Crystallographica 12.7 (1959): 483–499.
[sI] Jeffrey, G A. “Hydrate Inclusion Compounds.” Inclusion Compounds 1 (1984): 135–190.
[CS1] Kosyakov, Viktor I, and T M Polyanskaya. “Using Structural Data for Estimating the Stability of Water Networks in Clathrate and Semiclathrate Hydrates.” Journal of Structural Chemistry 40.2 (1999): 239–245.
[MEP] http://www.iza-structure.org/databases/
"""


density = 0.795     #default density


bondlen = 3      #bond threshold	 
cell = """
12.238818320447 12.238818320447 12.238818320447
"""

waters = """
10.8155661379622 3.79048442202564 0
3.79048442202564 0 1.42325218248478
0 3.05970458011175 6.1194091602235
8.35850097194928 3.88031734849772 8.35850097194928
2.23909181172578 2.23909181172578 2.23909181172578
0 9.17911374033525 6.1194091602235
2.23909181172578 9.99972650872122 2.23909181172578
6.1194091602235 9.90989358224914 4.69615697773872
7.54266134270828 6.1194091602235 9.90989358224914
9.99972650872122 2.23909181172578 9.99972650872122
3.88031734849772 3.88031734849772 3.88031734849772
2.32892473819786 4.69615697773872 6.1194091602235
3.88031734849772 8.35850097194928 3.88031734849772
3.88031734849772 3.88031734849772 8.35850097194928
8.44833389842136 0 1.42325218248478
6.1194091602235 2.32892473819786 4.69615697773872
9.99972650872122 9.99972650872122 2.23909181172578
6.1194091602235 9.90989358224914 7.54266134270828
9.90989358224914 4.69615697773872 6.1194091602235
3.79048442202564 0 10.8155661379622
6.1194091602235 2.32892473819786 7.54266134270828
3.88031734849772 8.35850097194928 8.35850097194928
10.8155661379622 8.44833389842136 0
9.99972650872122 9.99972650872122 9.99972650872122
0 1.42325218248478 3.79048442202564
9.99972650872122 2.23909181172578 2.23909181172578
9.90989358224914 7.54266134270828 6.1194091602235
9.17911374033525 6.1194091602235 0
0 10.8155661379622 8.44833389842136
8.35850097194928 8.35850097194928 8.35850097194928
6.1194091602235 0 3.05970458011175
0 1.42325218248478 8.44833389842136
2.32892473819786 7.54266134270828 6.1194091602235
4.69615697773872 6.1194091602235 2.32892473819786
4.69615697773872 6.1194091602235 9.90989358224914
2.23909181172578 2.23909181172578 9.99972650872122
0 10.8155661379622 3.79048442202564
1.42325218248478 8.44833389842136 0
1.42325218248478 3.79048442202564 0
8.35850097194928 3.88031734849772 3.88031734849772
8.35850097194928 8.35850097194928 3.88031734849772
7.54266134270828 6.1194091602235 2.32892473819786
2.23909181172578 9.99972650872122 9.99972650872122
6.1194091602235 0 9.17911374033525
3.05970458011175 6.1194091602235 0
8.44833389842136 0 10.8155661379622
"""

coord = "absolute"

cages="""
12    0.5000    0.5000    0.5000
12    1.0000    1.0000    0.0000
14    0.5000    0.7500    0.0000
14    0.5000    0.2500    0.0000
14    0.0000    0.5000    0.7500
14    0.2500    1.0000    0.5000
14    0.7500    1.0000    0.5000
14    0.0000    0.5000    0.2500
"""

from genice.cell import cellvectors
cell = cellvectors(a=12.238818320447,
                   b=12.238818320447,
                   c=12.238818320447)
