// group_by = 5
// labels = []
// datapoints = []
function doit(labels, datapoints, group_by, color) {
    const data = {
        labels: labels,
        datasets: [
            {
                label: "Failures",
                backgroundColor: color,
                borderColor: 'rgb(0, 0, 0)',
                data: datapoints,
                fill: false,
            },
        ],
    };
    const configChart = {
        responsive: false,
        type: "bar",
        data,
        options: {
            aspectRatio: 8,
            plugins: {
                //title: //}
                //    display: true,#}
                //    text: '{{ title }}'#}
                // },#}
                legend: {
                    display: false,
                }
            },
            scales: {
                y: {
                    //display: false,#}
                    max: group_by,
                    ticks: {
                        stepSize: 1,
                    }
                },
                x: {
                    //display: false,#}
                    ticks: {
                        callback: function (value, index, ticks) {
                            if (index % 24 === 0) {
                                return labels[index];
                            }
                        }
                    }
                }
            }
        },
    }

    var chartLine = new Chart(
        document.getElementById("barChart"),
        configChart
    );
}
django.jQuery(document).ready(function () {
    $ = django.jQuery;

    const address = 'ws://' + window.location.host + '/ws/checks/';
    let interval = null;
    let connectionError = 0;

    var init = function () {
        if (connectionError >= 6) {
            clearInterval(interval);
            console.log("Connection Error: Aborted");
            return
        }
        let chatSocket = new WebSocket(address);
        chatSocket.onclose = function () {
            $('body').addClass('offline');
            interval = setInterval(init, 10000);
            connectionError++;
        }
        chatSocket.onerror = function () {
            $('body').addClass('offline');
            chatSocket.close();
        }
        chatSocket.onopen = function () {
            $('body').removeClass('offline');
            if (interval) {
                clearInterval(interval);
                interval = null;
            }
        }

        chatSocket.onmessage = function (e) {
            const payload = JSON.parse(e.data);
            if (payload.reason === 'update') {
                window.location.reload();
            } else if (payload.reason === 'ping') {
                $('#lastUpdate').text(payload.ts);
            } else if (payload.reason === 'status') {
                let m = payload.monitor;
                let $target = $('#monitor-' + m.id);
                if ($target.length){
                    $target.find('div.counters').text(m.failures + " / " + m.thresholds[0] + " / " + m.thresholds[1]);
                    $target.find('div.last-check').text(m.last_check);
                    $target.find('div.last-success').text(m.last_success);
                    $target.find('div.last-failure').text(m.last_error);
                    $target.find('img.icon').attr("src", m.icon);
                    $target.find('img.status').attr("src", "/static/images/" + m.status + ".svg");
                    if (m.active) {
                        $target.removeClass("offline")
                    } else {
                        $target.addClass("offline");
                    }
                }
            }
        };

    }
    init();


})
