# WIPP Python Client

[![Build Status](https://github.com/PolusAI/data-tools/wipp_client/workflows/Build%20Main/badge.svg)](https://github.com/ktaletsk/wipp_client/actions)
[![Documentation](https://github.com/PolusAI/data-tools/wipp_client/workflows/Documentation/badge.svg)](https://ktaletsk.github.io/wipp_client/)
[![Code Coverage](https://codecov.io/gh/PolusAI/data-tools/wipp_client/branch/main/graph/badge.svg)](https://codecov.io/gh/ktaletsk/wipp_client)

WIPP API Python client library

---

## Features

-   Search and list all WIPP entities (such as collections, plugins, jobs and workflows)
-   List all members of the image and CSV colections
<!-- -   Create WIPP plugins
-   Access protected APIs with Keycloak token (has to be obtained externally) -->

## Installation

<!-- **Stable Release:** `pip install wipp_client`<br>
**Development Head:** `pip install git+https://github.com/polusai/wipp_client.git#egg=wipp_client&subdirectory=wipp_client` -->
- Clone the repo
- Checkout to the branch of interest
- Intall the library `pip install wipp_client/`

## Quick Start

Before importing the module, set the environment variable:
```sh
export WIPP_API_INTERNAL_URL=http://wipp.url.com/api
```
where `wipp.url.com` must be replaced with url of your WIPP instance.

Try the following commands in Python REPL (`python`) or 
include them in a Python file or Jupyter notebook.
CLI is not provided at this point.

```python
from wipp_client import Wipp

w = Wipp()

# Search image collections
collections = w.search_image_collections("ratBrain")
for c in collections:
    print(c)

# Get list of images in the image collection
images = w.get_image_collections_images(collections[0].id)
for i in images:
    print(i)

# Search CSV collections
csv_collections = w.search_csv_collections("covid")
for csvc in csv_collections:
    print(csvc)

# Get list of CSV files in the CSV collection
w.get_csv_collections_csv_files(csv_collections[0].id)
```

## Documentation

For full package documentation please visit [polusai.github.io/wipp_client](https://polusai.github.io/wipp_client).

## Development

See [CONTRIBUTING.md](CONTRIBUTING.md) for information related to developing the code.

## The Four Commands You Need To Know

1. `pip install -e .[dev]`

    This will install your package in editable mode with all the required development
    dependencies (i.e. `tox`).

2. `make build`

    This will run `tox` which will run all your tests in both Python 3.7
    and Python 3.8 as well as linting your code.

3. `make clean`

    This will clean up various Python and build generated files so that you can ensure
    that you are working in a clean environment.

4. `make docs`

    This will generate and launch a web browser to view the most up-to-date
    documentation for your Python package.

#### Additional Optional Setup Steps:

-   Turn your project into a GitHub repository:
    -   Make an account on [github.com](https://github.com)
    -   Go to [make a new repository](https://github.com/new)
    -   _Recommendations:_
        -   _It is strongly recommended to make the repository name the same as the Python
            package name_
        -   _A lot of the following optional steps are *free* if the repository is Public,
            plus open source is cool_
    -   After a GitHub repo has been created, run the commands listed under:
        "...or push an existing repository from the command line"
-   Register your project with Codecov:
    -   Make an account on [codecov.io](https://codecov.io)(Recommended to sign in with GitHub)
        everything else will be handled for you.
-   Ensure that you have set GitHub pages to build the `gh-pages` branch by selecting the
    `gh-pages` branch in the dropdown in the "GitHub Pages" section of the repository settings.
    ([Repo Settings](https://github.com/ktaletsk/wipp_client/settings))
-   Register your project with PyPI:
    -   Make an account on [pypi.org](https://pypi.org)
    -   Go to your GitHub repository's settings and under the
        [Secrets tab](https://github.com/ktaletsk/wipp_client/settings/secrets/actions),
        add a secret called `PYPI_TOKEN` with your password for your PyPI account.
        Don't worry, no one will see this password because it will be encrypted.
    -   Next time you push to the branch `main` after using `bump2version`, GitHub
        actions will build and deploy your Python package to PyPI.

#### Suggested Git Branch Strategy

1. `main` is for the most up-to-date development, very rarely should you directly
   commit to this branch. GitHub Actions will run on every push and on a CRON to this
   branch but still recommended to commit to your development branches and make pull
   requests to main. If you push a tagged commit with bumpversion, this will also release to PyPI.
2. Your day-to-day work should exist on branches separate from `main`. Even if it is
   just yourself working on the repository, make a PR from your working branch to `main`
   so that you can ensure your commits don't break the development head. GitHub Actions
   will run on every push to any branch or any pull request from any branch to any other
   branch.
3. It is recommended to use "Squash and Merge" commits when committing PR's. It makes
   each set of changes to `main` atomic and as a side effect naturally encourages small
   well defined PR's.


**MIT license**

