# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/50_dset.ipynb.

# %% auto 0
__all__ = ['PandasDataset', 'PandasCategoricalDataset', 'PandasTimeSeriesDataset']

# %% ../nbs/50_dset.ipynb 6
from functools import wraps, partial

# %% ../nbs/50_dset.ipynb 8
from types import FunctionType
from typing import Callable, Optional

# %% ../nbs/50_dset.ipynb 11
#| export

# %% ../nbs/50_dset.ipynb 13
try: import numpy as np
except ImportError: ...

try: import pandas as pd
except ImportError: ...

try: import matplotlib.pyplot as plt
except ImportError: ...

try: import seaborn as sns
except ImportError: ...

# %% ../nbs/50_dset.ipynb 15
try: import torch
except ImportError: ...

try: import torch, torch.nn as nn
except: ...

try: from torch.utils.data import Dataset, DataLoader
except: ...

try: import lightning as L
except: ...
try: from lightning import Trainer, LightningDataModule
except: ...

# %% ../nbs/50_dset.ipynb 17
from nlit import LABEL, MPS
from quac import real, intq
from chck import isslice, iscall, notnone, istuple, isdict, isnone
from asto import to, slice2range
from sigr import get_signature_defaults

from utrc.atyp import P
from utrc.misc import get_categories, grouplens, drop_column
from utrc.smpl import categorical_sample
from utrc.data import datasplit
from pcts import (permute_indicies, normalize_percents, diff_percents, sum_percents)
from etrc import Stage, BatchReturn, DataFormat
from utrc.smpl import categorical_sample
from etrc import Stage, BatchReturn, DataFormat

# %% ../nbs/50_dset.ipynb 19
from .make import diamonds
from .util import DataSplits
from .cats import torch_categorical_sample, categorical_collate_fn

# %% ../nbs/50_dset.ipynb 22
class PandasDataset(Dataset):
    def __init__(
        self, 
        df: pd.DataFrame, 
        col: str = LABEL, 
        device: str = MPS, 
        *args: P.args, 
        replace: bool = False, 
        labels: pd.Series | None = None, 
        **kwargs: P.kwargs
    ):
        super().__init__()
        self.df = df
        self.column = col
        self.labels = labels or get_categories(df, col).values
        self.n_feat = len(df.columns) - (1 if col in df.columns else 0)
        self.device = device
        self.replace = replace
        
    def __len__(self) -> int:
        return self.df.shape[0]

# %% ../nbs/50_dset.ipynb 24
class PandasCategoricalDataset(PandasDataset):
    def __init__(
        self, df: pd.DataFrame, col: str = LABEL, device: str = MPS, *args: P.args, 
        replace: bool = False, 
        labels: pd.Series | None = None, 
        **kwargs: P.kwargs
    ):
        super().__init__(df, col, device, *args, replace=replace, labels=labels, **kwargs)
        self.n_cats = len(self.labels)

    def __len__(self) -> int:
        return min(grouplens(self.df, self.column))
    
    @classmethod
    def collate_fn(cls, xys: tuple[tuple[torch.Tensor, torch.Tensor], ...]):
        return categorical_collate_fn(xys)
        xs = torch.concat(tuple(x for x, _ in xys), dim=1)
        ys = torch.concat(tuple(y for _, y in xys), dim=1)
        return (xs, ys)

    def __getitem__(self, idx):
        n = len(slice2range(idx)) if isslice(idx) else 1
        samples, labels = torch_categorical_sample(
            df=self.df, col=self.column, n=n, replace=self.replace, device=self.device)
        return samples, labels

# %% ../nbs/50_dset.ipynb 25
class PandasTimeSeriesDataset(PandasCategoricalDataset):
    def __init__(
        self, df: pd.DataFrame, col: str = LABEL, device: str = MPS, *args: P.args, 
        replace: bool = False, 
        labels: pd.Series | None = None, 
        **kwargs: P.kwargs
    ):
        super().__init__(df, col, device, *args, replace=replace, labels=labels, **kwargs)
        self.t_dict = dict(enumerate(self.labels))
        self.t_step = torch.linspace(0, self.n_cats - 1, self.n_cats)

# %% ../nbs/50_dset.ipynb 32
#| export

