# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/60_dmod.ipynb.

# %% auto 0
__all__ = ['PandasDataModule', 'PandasCategoricalDataModule', 'PandasTimeSeriesDataModule']

# %% ../nbs/60_dmod.ipynb 6
#| export


# %% ../nbs/60_dmod.ipynb 8
from types import FunctionType

# %% ../nbs/60_dmod.ipynb 11
#| export

# %% ../nbs/60_dmod.ipynb 13
try: import numpy as np
except ImportError: ...

try: import pandas as pd
except ImportError: ...

try: import matplotlib.pyplot as plt
except ImportError: ...

try: import seaborn as sns
except ImportError: ...

# %% ../nbs/60_dmod.ipynb 15
try: import torch
except ImportError: ...

try: import torch, torch.nn as nn
except: ...

try: from torch.utils.data import Dataset, DataLoader
except: ...

try: import lightning as L
except: ...
try: from lightning import LightningDataModule
except: ...

# %% ../nbs/60_dmod.ipynb 17
from nlit import LABEL, MPS
from chck import iscall, notnone
from sigr import get_signature_defaults

from utrc.atyp import P
from utrc.misc import get_categories, grouplens, drop_column
from utrc.smpl import categorical_sample
from utrc.data import datasplit

from etrc import Stage, BatchReturn, DataFormat

# %% ../nbs/60_dmod.ipynb 19
from .cons import DATASET_CLS, DATAFRAME_FN
from .util import DataSplits
from .make import diamonds
from .dset import PandasDataset, PandasCategoricalDataset, PandasTimeSeriesDataset

# %% ../nbs/60_dmod.ipynb 22
class PandasDataModule(LightningDataModule):
    dl_kwargs: dict = dict(drop_last=True)
    batch_size: int = 32
    collate_fn: FunctionType | None
    dataframe_fn: FunctionType | None = diamonds
    splits: DataSplits = DataSplits(.7, .2, .1, .0)
    dataset_cls: FunctionType | None = PandasDataset
    
    def __init__(
        self, 
        df: pd.DataFrame | None = None, 
        col: str = LABEL, 
        device: str = MPS, 
        *args, 
        replace: bool = False, 
        labels: pd.Series | None = None,
        splits: DataSplits | tuple[float, ...] | dict | None = None,
        dataframe_fn: FunctionType | None = None,
        dataset_cls: FunctionType | None = None,
        **kwargs
    ):
        super().__init__()
        self.df = df
        self.column = col
        self.labels = labels or get_categories(df, col).values
        self.n_feat = len(df.columns) - (1 if col in df.columns else 0)
        self.device = device
        self.replace = replace
        self.dataframe_fn = getattr(type(self), DATAFRAME_FN, dataframe_fn)
        self.dataset_cls = getattr(type(self), DATASET_CLS, dataset_cls)
                
        if (splits := DataSplits.make(splits)): self.splits = splits
        self.dl_kwargs = self.dataloader_kwds(**kwargs)
        
        
    def __len__(self) -> int:
        return self.df.shape[0]
    
    def dataloader_kwds(self, **kwargs: P.kwargs) -> dict:
        kws = get_signature_defaults(DataLoader, **{**self.dl_kwargs, **kwargs})
        for k, v in kws.items():            
            n = getattr(self, k, getattr(type(self), k, None))
            if notnone(n) and n != v: kws[k] = n
        return kws
    
    def dataframe_kwds(self, **kwargs: P.kwargs) -> dict:
        if notnone(getattr(self, DATAFRAME_FN, None)):
            kws = get_signature_defaults(self.dataframe_fn, **kwargs)
            for k, v in kws.items():
                n = getattr(self, k, getattr(type(self), k, None))
                if notnone(n) and n != v: kws[k] = v
        return kws
        
    def prepare_data(self, **kwargs: P.kwargs):
        df_fn = kwargs.get(DATAFRAME_FN, self.dataframe_fn)
        if self.df is None and iscall(df_fn):
            kws = self.dataframe_kwds(**kwargs)
            self.df = df_fn(**kws)
        return self
    
    def setup(self, stage: str | Stage = None):
        (self.train_idx, self.valid_idx, self.test_idx, self.pred_idx) = \
            datasplit(drop_column(self.df, self.column), splits=self.splits.astuple(), retdfs=False)
        
        if stage == Stage.fit or stage is None:
            self.train_ds = self.dataset_cls(self.df.iloc[self.train_idx], self.column, self.device)
            self.valid_ds = self.dataset_cls(self.df.iloc[self.valid_idx], self.column, self.device)
        
        if stage == Stage.test or stage is None:
            self.test_ds = self.dataset_cls(self.df.iloc[self.test_idx], self.column, self.device)
        
        if stage == Stage.predict or stage is None:
            self.pred_ds = self.dataset_cls(self.df.iloc[self.pred_idx], self.column, self.device)
            
        return self

    def train_dataloader(self) -> DataLoader:
        return DataLoader(self.train_ds, **self.dl_kwargs)

    def val_dataloader(self) -> DataLoader: 
        return DataLoader(self.valid_ds, **self.dl_kwargs)
    
    def test_dataloader(self) -> DataLoader:
        return DataLoader(self.test_ds, **self.dl_kwargs)

    def predict_dataloader(self) -> DataLoader:      
        return DataLoader(self.pred_ds, **self.dl_kwargs)

    def teardown(self, stage: str | Stage): ...

# %% ../nbs/60_dmod.ipynb 24
class PandasCategoricalDataModule(PandasDataModule):
    collate_fn = PandasCategoricalDataset.collate_fn
    dataset_cls: FunctionType | None = PandasCategoricalDataset
    
    def __init__(self, df: pd.DataFrame, col: str = LABEL, device: str = MPS, *args: P.args, **kwargs: P.kwargs):
        super().__init__(df, col, device, *args, **kwargs)
        self.n_cats = len(self.labels)
        
    def __len__(self) -> int:
        return min(grouplens(self.df, self.column))

# %% ../nbs/60_dmod.ipynb 26
class PandasTimeSeriesDataModule(PandasCategoricalDataModule):
    collate_fn = PandasCategoricalDataset.collate_fn
    
    dataset_cls: FunctionType | None = PandasTimeSeriesDataset
    def __init__(self, df: pd.DataFrame, col: str = LABEL, device: str = MPS, *args: P.args, **kwargs: P.kwargs):
        super().__init__(df, col, device, *args, **kwargs)
        self.t_dict = dict(enumerate(self.labels))
        self.t_step = torch.linspace(0, self.n_cats - 1, self.n_cats)

# %% ../nbs/60_dmod.ipynb 38
#| export

