# dtrc

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

## Developer Guide

### Setup

``` sh
# create conda environment
$ mamba env create -f env.yml

# update conda environment
$ mamba env update -n dtrc --file env.yml
```

### Install

``` sh
pip install -e .

# install from pypi
pip install dtrc
```

### nbdev

``` sh
# activate conda environment
$ conda activate dtrc

# make sure the dtrc package is installed in development mode
$ pip install -e .

# make changes under nbs/ directory
# ...

# compile to have changes apply to the dtrc package
$ nbdev_prepare
```

### Publishing

``` sh
# publish to pypi
$ nbdev_pypi

# publish to conda
$ nbdev_conda --build_args '-c conda-forge'
$ nbdev_conda --mambabuild --build_args '-c conda-forge -c dsm-72'
```

# Usage

## Installation

Install latest from the GitHub
[repository](https://github.com/dsm-72/dtrc):

``` sh
$ pip install git+https://github.com/dsm-72/dtrc.git
```

or from [conda](https://anaconda.org/dsm-72/dtrc)

``` sh
$ conda install -c dsm-72 dtrc
```

or from [pypi](https://pypi.org/project/dtrc/)

``` sh
$ pip install dtrc
```

## Documentation

Documentation can be found hosted on GitHub
[repository](https://github.com/dsm-72/dtrc)
[pages](https://dsm-72.github.io/dtrc/). Additionally you can find
package manager specific guidelines on
[conda](https://anaconda.org/dsm-72/dtrc) and
[pypi](https://pypi.org/project/dtrc/) respectively.

## NumPy Documentation:

- [`np.DataSource`](https://numpy.org/doc/stable/reference/generated/numpy.DataSource.html)

## PyTorch Documentation:

- [`TorchData`](https://pytorch.org/data/beta/index.html)
- [How to Package PyTorch
  Models](https://pytorch.org/docs/stable/package.html)
- [`torch.monitor.Event`](https://pytorch.org/docs/stable/monitor.html#torch.monitor.Event)
- [`torchvision`](https://pytorch.org/vision/stable/index.html)
- [`torchvision.Datasets.VisionDataset`](https://pytorch.org/vision/stable/generated/torchvision.datasets.VisionDataset.html#torchvision.datasets.VisionDataset)
- [`torchvision.utils.flow_to_image`](https://pytorch.org/vision/stable/generated/torchvision.utils.flow_to_image.html)

## PyTorch Models to Consider:

- [Diffusion Video
  AutoEncoders](https://github.com/man805/Diffusion-Video-Autoencoders)
- [ConvLSTM
  AutoEncoder](https://holmdk.github.io/2020/04/02/video_prediction.html)
- [Recurrent All Pairs Field Transforms for Optical
  Flow](https://github.com/princeton-vl/RAFT/blob/master/core/raft.py)
- [Optical Flow Toolbox
  (`mmflow`)](https://github.com/open-mmlab/mmflow/blob/master/docs/en/intro.md)
- [`torchvision.models.optical_flow.raft`](https://github.com/pytorch/vision/blob/main/torchvision/models/optical_flow/raft.py)
