# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/00_core.ipynb (unless otherwise specified).

__all__ = ['isnone', 'map_dict_ex', 'D', 'BDTypeError', 'BDBatchSizeError', 'BDKeyMisMatchError', 'list2tensor',
           'tensor2shape', 'tensor2mu', 'BD']

# Cell
# Python native modules
import os,warnings
# Third party libs
from fastcore.all import *
from fastai.torch_core import *
from fastai.basics import *
import pandas as pd
import torch
import numpy as np
# Local modules

# Cell
def isnone(v): return v is None

# Cell
def map_dict_ex(d,f,*args,gen=False,wise=None,**kwargs):
    "Like `map`, but for dicts and uses `bind`, and supports `str` and indexing"
    g = (bind(f,*args,**kwargs) if callable(f)
         else f.format if isinstance(f,str)
         else f.__getitem__)

    if wise is None:  return map(g,d.items())
    return ((k,g(v)) if wise=='value' else (g(k),v) for k,v in d.items())

# Cell
_error_msg='Found idxs: %s have values more than %s e.g.: %s'

class D(dict):
    "Improved version of `dict` with array handling abilities"
    def __init__(self,*args,mapping=False,**kwargs):
        self.mapping=mapping
        super().__init__(*args,**kwargs)

    def eq_k(self,o:'D',with_diff=False):
        eq=set(o.keys())==set(self.keys())
        if with_diff: return eq,set(o.keys()).symmetric_difference(set(self.keys()))
        return eq
    def _new(self,*args,**kwargs): return type(self)(*args,**kwargs)

    def map(self,f,*args,gen=False,**kwargs):
        return (self._new,noop)[gen](map_dict_ex(self,f,*args,**kwargs),mapping=True)
    def mapk(self,f,*args,gen=False,wise='key',**kwargs):
        return self.map(f,*args,gen=gen,wise=wise,**kwargs)
    def mapv(self,f,*args,gen=False,wise='value',**kwargs):
        return self.map(f,*args,gen=gen,wise=wise,**kwargs)

# Cell
@typedispatch
def stack(a:Tensor,b:Tensor): return torch.vstack((a,b))
@typedispatch
def stack(a:(np.array,np.ndarray),b:(np.array,np.ndarray)): return np.vstack((a,b))

# Cell
class BDTypeError(Exception):
    def __init__(self,k,v):
        self.message=f'Key:{k} has value {type(v)} when it should have type Tensor, or None'
        super().__init__(self.message)
    @classmethod
    def check(cls,d:dict,strict=False):
        for k,v in d.items():
            if isinstance(k,int): raise TypeError(f'{k} cannot be an int since ints can be used to index.')
            types=(Tensor,NoneType)
            if not strict:types=(*types,list,L,np.ndarray,Tensor)
            if not isinstance(v,types): raise cls(k,v)

class BDBatchSizeError(Exception):
    def __init__(self,k,v,bs):
        self.message=f'Key:{k} has shape {v} when it should have shape[0]=={bs}'
        super().__init__(self.message)
    @classmethod
    def check(cls,d:'BD'):
        for k,v in d.items():
            if v.shape[0]!=d.bd_batch_size: raise cls(k,v.shape,d.bd_batch_size)

class BDKeyMisMatchError(Exception):
    def __init__(self,different):
        self.message=f'Keys: {different} are not shared by the dictionaries'
        super().__init__(self.message)
    @classmethod
    def check(cls,d:'BD',other:'BD'):
        eq,different=d.eq_k(other,with_diff=True)
        if not eq: raise cls(different)

# Cell
def list2tensor(l:(L,list,np.ndarray)): return tensor(l) if not isinstance(l,Tensor) else l
@typedispatch
def batch_dim(o:Tensor,bs=1): return o.unsqueeze(0) if len(o.shape)<2 or o.shape[0]>bs else o

# Cell
def tensor2shape(k,t:Tensor,bs):
    return {
        k:t.numpy().reshape(-1,) if len(t.shape)==2 and t.shape[1]==1 else [str(t.shape)]*bs
    }

def tensor2mu(k,t:Tensor,bs):
    return {f'{k}_mu':t.reshape(bs,-1).double().mean(axis=1)}

class BD(D):
    def __init__(self,*args,bd_batch_size=1,**kwargs):
        "Converts listy values to tensors. Adds batch dims and validates them."
        if args and isinstance(args[0],type(self)):bd_batch_size=None
        super().__init__(*args,**kwargs)
        self.bd_batch_size=ifnone(bd_batch_size,self.bs())
        BDTypeError.check(self)
        if not self.mapping:
            self.update(self.mapv(list2tensor).mapv(batch_dim,bs=self.bd_batch_size))
            self.mapping=False
        BDTypeError.check(self,strict=True)
        if not self.mapping: BDBatchSizeError.check(self)

    def bs(self):
        "Return the batch size of `BD` assuming all values have same batch size."
        if len(self.values())==0: return 0
        return dict(self).popitem()[1].shape[0]

    def __getitem__(self,o):
        if isinstance(o,int) or is_listy(o) or isinstance(o,Tensor):
            bs=1 if isinstance(o,int) else None
            return BD({k:self[k][o] for k in self},bd_batch_size=bs)
        return super().__getitem__(o)

    def __add__(self,o):
        BDKeyMisMatchError.check(self,o)
        return BD({k:stack(self[k],o[k]) for k in self},
                  bd_batch_size=self.bd_batch_size+o.bd_batch_size)

    @delegates(pd.DataFrame)
    def pandas(self,mu=False,**kwargs):
        "Turns a `BD` into a pandas Dataframe optionally showing `mu` of values."
        bs=self.bs()
        return pd.DataFrame(merge(
            *tuple(tensor2shape(k,v,bs) for k,v in self.items()),
            *(tuple(tensor2mu(k,v,bs) for k,v in self.items()) if mu else ())
        ),**kwargs)
