# coding: utf-8

"""
    FastFuels API

    A JSON API for creating, editing, and retrieving 3D fuels data for next generation fire behavior models.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from fastfuels_sdk.client_library.models.job_status import JobStatus
from fastfuels_sdk.client_library.models.water_feature_source import WaterFeatureSource
from typing import Optional, Set
from typing_extensions import Self

class WaterFeature(BaseModel):
    """
    WaterFeature
    """ # noqa: E501
    sources: List[WaterFeatureSource] = Field(description="List of sources of road features")
    status: Optional[JobStatus] = None
    created_on: Optional[datetime] = Field(default=None, alias="createdOn")
    modified_on: Optional[datetime] = Field(default=None, alias="modifiedOn")
    checksum: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["sources", "status", "createdOn", "modifiedOn", "checksum"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WaterFeature from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            mode='json',
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if created_on (nullable) is None
        # and model_fields_set contains the field
        if self.created_on is None and "created_on" in self.model_fields_set:
            _dict['createdOn'] = None

        # set to None if modified_on (nullable) is None
        # and model_fields_set contains the field
        if self.modified_on is None and "modified_on" in self.model_fields_set:
            _dict['modifiedOn'] = None

        # set to None if checksum (nullable) is None
        # and model_fields_set contains the field
        if self.checksum is None and "checksum" in self.model_fields_set:
            _dict['checksum'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WaterFeature from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "sources": obj.get("sources"),
            "status": obj.get("status"),
            "createdOn": obj.get("createdOn"),
            "modifiedOn": obj.get("modifiedOn"),
            "checksum": obj.get("checksum")
        })
        return _obj


